/*
 * Decompiled with CFR 0.152.
 */
package com.stta.model;

import com.stta.STTAClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class WhisperHash {
    public static final short EKBIT = 8192;
    public static final String[] signatures = new String[]{"bd577a113a864445d4c299885e0cb97d4ba92b5f", "c78c86eb1a8faa21b369bcd33207cc90d64ae9df", "465707469ff3a37a2b9b8d8f89f2f99de7299dac", "137c40403d78fd54d454da0f9bd998f78703390c", "55356645c2b361a969dfd0ef2c5a50d530afd8d5", "db8a495a91d927739e50b3fc1cc4c6b8f6c2d022"};

    public static boolean checkWhisperHash(File pathToModel) {
        try {
            BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(pathToModel));
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            byte[] buf = new byte[8192];
            int len = fileInput.read(buf);
            while (len != -1) {
                sha1Digest.update(buf, 0, len);
                len = fileInput.read(buf);
            }
            byte[] sha1DigestBytes = sha1Digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte sha1DigestByte : sha1DigestBytes) {
                sb.append(Integer.toString((sha1DigestByte & 0xFF) + 256, 16).substring(1));
            }
            STTAClient.LOGGER.info("SHA1 checksum of model file to be loaded: " + String.valueOf(sb));
            fileInput.close();
            if (Arrays.asList(signatures).contains(sb.toString())) {
                STTAClient.LOGGER.info("SHA1 checksum matches, proceeding to loading...");
                return true;
            }
            STTAClient.LOGGER.error("SHA1 checksum do not match! Not loading...");
            return false;
        }
        catch (IOException | NullPointerException | NoSuchAlgorithmException nil) {
            STTAClient.LOGGER.error("Error occured while trying to check for hash, see following stacktrace:", (Throwable)nil);
            throw new RuntimeException(nil);
        }
    }
}

