/*
 * Decompiled with CFR 0.152.
 */
package com.stta.model;

import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperFullParams;
import io.github.givimad.whisperjni.WhisperJNI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class WhisperModel {
    private static final int SAMPLE_RATE = 16000;
    private static final String BLANK = " [BLANK_AUDIO]";
    private final WhisperJNI whisper;
    private final WhisperContext context;

    protected WhisperModel(WhisperJNI whisper, WhisperContext context) {
        this.whisper = whisper;
        this.context = context;
    }

    public String processSpeech(float[] audioSamples, WhisperFullParams params) {
        float[] paddedSamples = new float[audioSamples.length + 8000];
        System.arraycopy(audioSamples, 0, paddedSamples, 0, audioSamples.length);
        int resultTranscription = this.whisper.full(this.context, params, paddedSamples, audioSamples.length);
        if (resultTranscription != 0) {
            throw new RuntimeException("Transcription failed with code " + resultTranscription);
        }
        int numberOfSegments = this.whisper.fullNSegments(this.context);
        StringBuilder completeText = new StringBuilder();
        for (int i = 0; i < numberOfSegments; ++i) {
            String segmentText = this.whisper.fullGetSegmentText(this.context, i);
            completeText.append(segmentText);
        }
        String textOutput = completeText.toString();
        if (textOutput.contains(BLANK)) {
            textOutput = textOutput.replace(BLANK, "");
        }
        return textOutput;
    }
}

