/*
 * Decompiled with CFR 0.152.
 */
package launchcmd.launchcmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class LaunchCommandCmd {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"launch").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.literal((String)"addMotion").then(Commands.argument((String)"motionX", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"motionY", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"motionZ", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> LaunchCommandCmd.launchAddMotion((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionX"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionY"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionZ")))))))).then(Commands.literal((String)"setMotion").then(Commands.argument((String)"motionX", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"motionY", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"motionZ", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> LaunchCommandCmd.launchSetMotion((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionX"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionY"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionZ")))))))).then(Commands.literal((String)"looking").then(Commands.argument((String)"force", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> LaunchCommandCmd.launchLooking((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"force")))))).then(Commands.literal((String)"setMotionX").then(Commands.argument((String)"motionX", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> LaunchCommandCmd.launchSetMotionX((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionX")))))).then(Commands.literal((String)"setMotionY").then(Commands.argument((String)"motionY", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> LaunchCommandCmd.launchSetMotionY((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionY")))))).then(Commands.literal((String)"setMotionZ").then(Commands.argument((String)"motionZ", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> LaunchCommandCmd.launchSetMotionZ((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"motionZ")))))));
    }

    private static int launchAddMotion(CommandSourceStack source, Collection<? extends Entity> entitiesToLaunch, double motX, double motY, double motZ) {
        for (Entity entity : entitiesToLaunch) {
            Vec3 motion = new Vec3(motX, motY, motZ);
            entity.addDeltaMovement(motion);
            if (!(entity instanceof Player)) continue;
            entity.hurtMarked = true;
        }
        if (entitiesToLaunch.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchadd.success.single", (Object[])new Object[]{((Entity)entitiesToLaunch.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchadd.success.multiple", (Object[])new Object[]{entitiesToLaunch.size()}), true);
        }
        return entitiesToLaunch.size();
    }

    private static int launchSetMotion(CommandSourceStack source, Collection<? extends Entity> entitiesToLaunch, double motX, double motY, double motZ) {
        for (Entity entity : entitiesToLaunch) {
            entity.setDeltaMovement(motX, motY, motZ);
            if (!(entity instanceof Player)) continue;
            entity.hurtMarked = true;
        }
        if (entitiesToLaunch.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.single", (Object[])new Object[]{((Entity)entitiesToLaunch.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.multiple", (Object[])new Object[]{entitiesToLaunch.size()}), true);
        }
        return entitiesToLaunch.size();
    }

    private static int launchLooking(CommandSourceStack source, Collection<? extends Entity> entitiesToLaunch, double force) {
        float sourcePitch = (float)((double)(-source.getRotation().x) * (Math.PI / 180) + 1.5707963267948966);
        float sourceYaw = (float)((double)source.getRotation().y * (Math.PI / 180) + 1.5707963267948966);
        for (Entity entity : entitiesToLaunch) {
            Vec3 motion = new Vec3(force * (Math.cos(sourceYaw) * Math.sin(sourcePitch)), force * Math.sin((double)sourcePitch - 1.5707963267948966), force * (Math.sin(sourceYaw) * Math.sin(sourcePitch)));
            entity.addDeltaMovement(motion);
            if (!(entity instanceof Player)) continue;
            entity.hurtMarked = true;
        }
        if (entitiesToLaunch.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchadd.success.single", (Object[])new Object[]{((Entity)entitiesToLaunch.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchadd.success.multiple", (Object[])new Object[]{entitiesToLaunch.size()}), true);
        }
        return entitiesToLaunch.size();
    }

    private static int launchSetMotionX(CommandSourceStack source, Collection<? extends Entity> entitiesToLaunch, double motX) {
        for (Entity entity : entitiesToLaunch) {
            entity.setDeltaMovement(motX, entity.getDeltaMovement().y(), entity.getDeltaMovement().z());
            if (!(entity instanceof Player)) continue;
            entity.hurtMarked = true;
        }
        if (entitiesToLaunch.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.single", (Object[])new Object[]{((Entity)entitiesToLaunch.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.multiple", (Object[])new Object[]{entitiesToLaunch.size()}), true);
        }
        return entitiesToLaunch.size();
    }

    private static int launchSetMotionY(CommandSourceStack source, Collection<? extends Entity> entitiesToLaunch, double motY) {
        for (Entity entity : entitiesToLaunch) {
            entity.setDeltaMovement(entity.getDeltaMovement().x(), motY, entity.getDeltaMovement().z());
            if (!(entity instanceof Player)) continue;
            entity.hurtMarked = true;
        }
        if (entitiesToLaunch.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.single", (Object[])new Object[]{((Entity)entitiesToLaunch.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.multiple", (Object[])new Object[]{entitiesToLaunch.size()}), true);
        }
        return entitiesToLaunch.size();
    }

    private static int launchSetMotionZ(CommandSourceStack source, Collection<? extends Entity> entitiesToLaunch, double motZ) {
        for (Entity entity : entitiesToLaunch) {
            entity.setDeltaMovement(entity.getDeltaMovement().x(), entity.getDeltaMovement().y(), motZ);
            if (!(entity instanceof Player)) continue;
            entity.hurtMarked = true;
        }
        if (entitiesToLaunch.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.single", (Object[])new Object[]{((Entity)entitiesToLaunch.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.launchcmd.launchset.success.multiple", (Object[])new Object[]{entitiesToLaunch.size()}), true);
        }
        return entitiesToLaunch.size();
    }
}

