/*
 * Decompiled with CFR 0.152.
 */
package com.hightide.fabric.commands.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class HypixelItemData {
    public static String hypixelItemsJSON = "[]";
    private static final Gson gson = new Gson();
    static final String[] itemRarityCodes = new String[]{"", "\u00a7a", "\u00a79", "\u00a75", "\u00a76", "\u00a7d", "\u00a7b", "\u00a7c", "\u00a7c", "\u00a74", "\u00a74"};
    static final String[] itemRarityNames = new String[]{"COMMON", "UNCOMMON", "RARE", "EPIC", "LEGENDARY", "MYTHIC", "DIVINE", "SPECIAL", "SUPER SPECIAL", "ULTIMATE", "ADMIN"};
    static final String locationCode = "\u00a72";
    static final String enemyCode = "\u00a74";
    static final String npcCode = "\u00a7b";
    static final String creatureCode = "\u00a73";

    public static String searchItemList(char letter, String rarity) {
        JsonArray items = (JsonArray)gson.fromJson(hypixelItemsJSON, JsonArray.class);
        StringBuilder result = new StringBuilder();
        rarity = rarity.toUpperCase();
        for (JsonElement element : items) {
            JsonObject item = element.getAsJsonObject();
            String itemName = item.get("item_name").getAsString().replace("\u00a7r", "").toUpperCase();
            String itemRarity = item.get("item_rarity").getAsString().replace("\u00a7r", "");
            String cleanedItemRarity = itemRarity.replaceAll("\u00a7[0-9a-fk-or]", "").toUpperCase();
            String cleanedItemName = itemName.replaceAll("\u00a7[0-9a-fk-or]", "").toUpperCase();
            if (cleanedItemName.charAt(0) != Character.toUpperCase(letter) || !cleanedItemRarity.contains(rarity)) continue;
            if (!result.isEmpty()) {
                result.append(",");
            }
            result.append(item.get("item_id").getAsString());
        }
        if (result.toString().length() < 2) {
            result.append("No items found...");
        }
        return result.toString();
    }

    public static void InitializeItems() {
        HypixelItemData.AddItemToData("Glacite Jewel", "glacite_jewel", "item", false, 2, 2000, "The (rarityCode)Glacite Jewel\u00a7r has a 0.5% or 1 in 200 chance to drop from (enemyCode)Ice Walkers(eEnemyCode) in the (locationCode)Dwarven Mines(eLocationCode).", "");
        HypixelItemData.AddItemToData("Summoning Eye", "summoning_eye", "item", false, 3, 0, "The (rarityCode)Summoning Eye\u00a7r is dropped at a 100% chance from (enemyCode)Special Zealots(eEnemyCode). A (enemyCode)Special Zealot(eEnemyCode) is spawned at a 1 in 420 chance from killing (enemyCode)Zealots(eEnemyCode) and a 1 in 360 chance from killing (enemyCode)Zealot Bruisers(eEnemyCode) in (locationCode)The End(eLocationCode).", "");
        HypixelItemData.AddItemToData("Aspect of the Dragons", "aspect_of_the_dragons", "sword", false, 4, 100000, "The (rarityCode)Aspect Of The Dragons\u00a7r has a 3% chance per placed \u00a75Summoning Eye\u00a75\u00a7r to be obtained after killing a (enemyCode)Dragon(eEnemyCode) in the (locationCode)Dragon's Nest(eLocationCode) section of (locationCode)The End(eLocationCode).", "");
        HypixelItemData.AddItemToData("Recombobulator 3000", "recombobulator_3000", "ITEM", true, 4, 0, "A (rarityCode)Recombobulator 3000\u00a7r has a chance to rarely appear in (locationCode)Catacombs(eLocationCode) Obsidian and Bedrock chests from any floor or from defeating any (enemyCode)Dungeon boss(eEnemyCode) 250 times, and claiming your free (rarityCode)Recombobulator 3000(eRarityCode) from Boss Collection.", "");
        HypixelItemData.AddItemToData("Hot Potato Book", "hot_potato_book", "item", false, 3, 38400, "The (rarityCode)Hot Potato Book\u00a7r can be crafted with 3 Paper and 1 \u00a7aEnchanted Baked Potato\u00a7a\u00a7r after unlocking Potato Collection VIII (8). It can also be obtained from any tier of chest at the end of any (locationCode)Dungeon floor(eLocationCode).", "");
        HypixelItemData.AddItemToData("Dwarven Sack", "dwarven_sack", "sack", false, 3, 0, "The (rarityCode)Dwarven Sack\u00a7r can be purchased from the (locationCode)Bits Shop(eLocationCode) in the (locationCode)Skyblock Hub(eLocationCode) for \u00a7b14,000 Bits\u00a7r.", "");
        HypixelItemData.AddItemToData("Dwarven Tankard", "dwarven_tankard", "item", false, 3, 10, "The (rarityCode)Dwarven Tankard\u00a7r is obtained by approaching a group of NPCs in the (locationCode)Dwarven Mines(eLocationCode) and typing 'burp' in public chat. These NPCs consist of \u00a7bGimley\u00a7b\u00a7r, \u00a7bHornum\u00a7b\u00a7r, \u00a7bSargwyn\u00a7b\u00a7r and \u00a7bTarwen\u00a7b\u00a7r, who are sometimes referred to as '\u00a7bThe Dwarves\u00a7b\u00a7r'.", "");
        HypixelItemData.AddItemToData("Cake Soul", "cake_soul", "ITEm", false, 5, 0, "(rarityCode)Cake Souls\u00a7r have a 0.1% chance to drop when consuming \u00a75Century Cakes\u00a7r by a player with more than 8 hours of playtime. They come in the form of different dyes corresponding to the cake they were obtained from.", "");
        HypixelItemData.AddItemToData("Complete Century Cake Bundle", "complete_century_cake_bundle", "item", false, 5, 0, "A (rarityCode)Complete Century Cake Bundle\u00a7r could be obtained from the Raffle of the Century during SkyBlock Year 300.", "");
        HypixelItemData.AddItemToData("Divan's Drill", "divans_drill", "DRILL", false, 5, 0, "(rarityCode)Divan's Drill\u00a7r can be forged in (locationCode)The Forge\u00a7r at Heart of the Mountain Tier 7. The recipe requires 1 \u00a76Divan's Alloy\u00a76\u00a7r, 1 \u00a76Titanium Drill DR-X655\u00a76\u00a7r, and \u00a7650,000,000 Coins\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Diamond Magmafish", "diamond_magmafish", "item", false, 5, 0, "The (rarityCode)Diamond Magmafish\u00a7r recipe is unlocked from the Magmafish Collection X and can be crafted with 80 \u00a76Gold Magmafish\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Gold Magmafish", "gold_magmafish", "item", false, 4, 128000, "After reaching Magmafish Collection VII (7), a (rarityCode)Gold Magmafish(eRarityCode) can be crafted with 80 \u00a75Silver Magmafish\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Silver Magmafish", "silver_magmafish", "item", false, 3, 1600, "A (rarityCode)Silver Magmafish\u00a7r can drop from (enemyCode)Taurus(eEnemyCode) and (enemyCode)Lord Jawbus\u00a7r. The (rarityCode)Silver Magmafish(eRarityCode) recipe is unlocked from the Magmafish Collection III, and can be crafted with 80 \u00a7aMagmafish\u00a7a\u00a7r.", "");
        HypixelItemData.AddItemToData("Crux Chronomicon", "crux_chronomicon", "Accessory", false, 5, 0, "The (rarityCode)Crux Chronomicon\u00a7r can be crafted using 32 \u00a7aSplatter Cruxes\u00a7a\u00a7r and a \u00a76Crux Heirloom\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Plasma Bucket", "plasma_bucket", "item", false, 5, 50000, "The (rarityCode)Plasma Bucket\u00a7r can be crafted using 2 \u00a76Magma Buckets\u00a76\u00a7r and 1 \u00a74Heat Core\u00a74\u00a7r.", "");
        HypixelItemData.AddItemToData("Retro-Encabulating Visor", "retro-encabulating_visor", "helmet", false, 5, 0, "The (rarityCode)Retro-Encabulating Visor\u00a7r can be obtained by speaking to Unhinged Kloon in the (locationCode)West Village(eLocationCode). One can also be re-purchased from him for \u00a751,000 Motes\u00a75\u00a7r if necessary.", "");
        HypixelItemData.AddItemToData("Radioactive Vial", "radioactive_vial", "item", false, 5, 100000, "The (rarityCode)Radioactive Vial\u00a7r has a 0.3% chance to drop from killing (enemyCode)Lord Jawbus(eEnemyCode).", "");
        HypixelItemData.AddItemToData("Scorched Books", "scorched_books", "power stone", false, 5, 1, "(rarityCode)Scorched Books\u00a7r are obtained by being Blaze Slayer 2 by killing a Tier II, Tier III, or Tier IV (enemyCode)Inferno Demonlord(eEnemyCode).", "");
        HypixelItemData.AddItemToData("Astraea", "astraea", "sword", false, 4, 200, "The (rarityCode)Astraea\u00a7r can be crafted using 8 \u00a75Jolly Pink Rocks\u00a75\u00a7r and 1 \u00a76Necron's Blade (Unrefined)\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Annihilation Cloak", "annihilation_cloak", "cloak", false, 4, 0, "The (rarityCode)Annihilation Cloak\u00a7r can be crafted after unlocking Blaze Slayer 7 with 2 \u00a76Wood Singularities\u00a76\u00a7r, 1 \u00a75Destruction Cloak\u00a75\u00a7r, 256 \u00a79Molten Powder\u00a79\u00a7r, 8 \u00a75Inferno Vertexes\u00a75\u00a7r, and 16 \u00a79Enchanted Sulphur Cubes\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Anti-Bite Scarf", "anti-bite_scarf", "helmet", false, 4, 0, "The Anti-Bite Scarf can be crafted with 32 \u00a7aCoven Seals\u00a7a\u00a7r and a \u00a75Used Detransfigured Face\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Glacial Fragment", "glacial_fragment", "ITEM", false, 3, 0, "(rarityCode)Glacial Fragment\u00a7r has a 9.58% chance to appear as Frozen Treasure.", "");
        HypixelItemData.AddItemToData("Pickonimbus 2000", "pickonimbus_2000", "pickaxe", false, 3, 12, "The (rarityCode)Pickonimbus 2000\u00a7r can be found in treasure chests located in the (locationCode)Crystal Hollows(eLocationCode). They also have a 3.276% chance to appear for each roll of a (locationCode)Crystal Nucleus(eLocationCode) loot bundle.", "");
        HypixelItemData.AddItemToData("Livid Dagger", "livid_dagger", "SWORD", false, 4, 500000, "The (rarityCode)Livid Dagger\u00a7r is obtainable from either an Obsidian or Bedrock Dungeon Reward Chest in the (locationCode)Catacombs Floor V(eLocationCode) or the (enemyCode)Livid(eEnemyCode) Collection after defeating (enemyCode)Livid(eEnemyCode) 150 times.", "");
        HypixelItemData.AddItemToData("Aurora Staff", "aurora_staff", "sword", false, 4, 46875, "The (rarityCode)Aurora Staff\u00a7r has a chance to spawn in a (enemyCode)Kuudra(eEnemyCode) Loot Chest after defeating (enemyCode)Kuudra(eEnemyCode).", "");
        HypixelItemData.AddItemToData("Atomsplit Katana", "atomsplit_katana", "SwOrD", false, 4, 0, "The (rarityCode)Atomsplit Katana\u00a7r can be crafted after unlocking (enemyCode)Enderman(eEnemyCode) Slayer 6. It can also be crafted using 2 \u00a76Null Blades\u00a76\u00a7r and 1 \u00a75Vorpal Katana\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Auger Rod", "auger_rod", "fiSHing ROD", false, 4, 0, "The (rarityCode)Auger Rod\u00a7r can be crafted with 128 \u00a79Enchanted Packed Ice\u00a79\u00a7r and 1 \u00a75Yeti Rod\u00a75\u00a7r. This recipe is unlocked after completing Ice Collection X.", "");
        HypixelItemData.AddItemToData("Auto Recombobulator", "auto_recombobulator", "accessory", false, 4, 1000, "The (rarityCode)Auto Recombobulator\u00a7r is obtainable in a Bedrock (locationCode)Dungeon(eLocationCode) Reward Chest in the (locationCode)Catacombs Floor VII(eLocationCode).", "");
        HypixelItemData.AddItemToData("Awakened Summoning Eye", "awakened_summoning_eye", "item", false, 4, 0, "The (rarityCode)Awakened Summoning Eye\u00a7r can be crafted using 5 \u00a75Summoning Eyes\u00a75\u00a7r and 4 \u00a79Null Ovoids\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Axe of the Shredded", "axe_of_the_shredded", "sword", false, 4, 0, "The (rarityCode)Axe of the Shredded\u00a7r can be crafted after unlocking (enemyCode)Zombie(eEnemyCode) Slayer VIII (8). It can also be crafted using 256 \u00a79Revenant Viscera\u00a79\u00a7r, 4 \u00a75Shard of the Shredded\u00a75\u00a7r, and 1 \u00a76Reaper Falchion\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Aspect Of The Draconic", "aspect_of_the_draconic", "sword", false, 4, 100000, "Currently, the (rarityCode)Aspect of the Draconic(eRarityCode) is not currently obtainable.", "");
        HypixelItemData.AddItemToData("Artifact of Control", "artifact_of_control", "accessory", false, 4, 0, "The (rarityCode)Artifact of Control(eRarityCode) can be obtained by bidding in Shen's Auction. The top 10 bidders win this item.", "");
        HypixelItemData.AddItemToData("Bat Artifact", "bat_artifact", "accessory", false, 4, 0, "The (rarityCode)Bat Artifact(eRarityCode) can be purchased from the Fear Mongerer in the (locationCode)Skyblock Hub(eLocationCode) with 64 \u00a75Purple Candy(eRarityCode) and 1 \u00a75Bat Ring(eRarityCode).", "");
        HypixelItemData.AddItemToData("Bedrock", "bedrock", "item", false, 4, 1, "(rarityCode)Bedrock(eRarityCode) cannot be obtained through normal gameplay as it was introduced through a bug in the game. It can still be traded from other players, usually through the (locationCode)Auction House(eLocationCode).", "");
        HypixelItemData.AddItemToData("Blazetekk\u2122 Ham Radio", "blazetekk_ham_radio", "item", false, 4, 0, "After reaching Blaze Slayer 6, the (rarityCode)Blazetekk\u2122 Ham Radio(eRarityCode) can be crafted with 96 \u00a79Molten Powder\u00a79\u00a7r, 24 \u00a75Inferno Vertexes\u00a75\u00a7r, and 64 \u00a79Enchanted Redstone Lamps\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Bonemerang", "bonemerang", "bow", false, 4, 0, "The (rarityCode)Bonemerang(eRarityCode) can be crafted using 15 \u00a7aEnchanted String\u00a7a\u00a7r, 10 \u00a79Enchanted Bone Blocks\u00a79\u00a7r, and 5 \u00a75Spirit Bones\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Booster Cookie", "booster_cookie", "item", false, 4, 0, "(rarityCode)Booster Cookies(eRarityCode) can be bought through Elizabeth or the (rarityCode)Booster Cookie(eRarityCode) Menu for 325 Gems each. Elizabeth gives out 1 (rarityCode)Booster Cookie(eRarityCode) to each player for free. (rarityCode)Booster Cookies(eRarityCode) can also be purchased from the Bazaar using Coins. It is the only item that players on Ironman profiles can purchase through this system.", "");
        HypixelItemData.AddItemToData("Bouquet of Lies", "bouquet_of_lies", "sword", true, 4, 100000, "The (rarityCode)Bouquet of Lies(eRarityCode) is crafted using 12 \u00a75Fel Roses\u00a75\u00a7r, and 1 \u00a76Flower of Truth\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Bubba Blister", "bubba_blister", "POWEr StOne", false, 4, 10000, "The (rarityCode)Bubba Blister(eRarityCode) has a small chance to drop from a (enemyCode)Riftstalker Bloodfiend(eEnemyCode) after obtaining Vampire Slayer 3.", "");
        HypixelItemData.AddItemToData("Builder's Ruler", "builders_ruler", "item", false, 4, 0, "(rarityCode)Builder's Ruler(eRarityCode) is obtained by purchasing it from the Desk on your (locationCode)Garden Island(eLocationCode) for \u00a7c20 Copper\u00a7c\u00a7r.", "");
        HypixelItemData.AddItemToData("Builder's Wand", "builders_wand", "item", false, 4, 0, "(rarityCode)Builder's Wand(eRarityCode) is obtained by purchasing it from Elizabeth at the (locationCode)Community Center(eLocationCode) for \u00a7b12,000 Bits\u00a7b\u00a7r.", "");
        HypixelItemData.AddItemToData("Candy Relic", "candy_relic", "accessory", false, 4, 0, "The (rarityCode)Candy Relic(eRarityCode) can be obtained from the Fear Mongerer in the (locationCode)Hub(eLocationCode) during the Spooky Festival. It costs 1,024 \u00a75Purple Candy\u00a75\u00a7r and 1 \u00a75Candy Artifact\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Claw Fossil", "claw_fossil", "item", false, 4, 0, "\u00a74There is no information on how to obtain this item!\u00a74\u00a7r", "");
        HypixelItemData.AddItemToData("Chirping Stereo", "chirping_stereo", "item", false, 4, 500, "The (rarityCode)Chirping Stereo(eRarityCode) has a 0.5% chance to drop from killing a Cricket on the (locationCode)Garden Island(eLocationCode).", "");
        HypixelItemData.AddItemToData("Clover Helmet", "clover_helmet", "helmet", false, 4, 0, "The (rarityCode)Clover Helmet(eRarityCode) appears in Shen's Auction every 5 SkyBlock Years. To obtain it, you must be one of the top 10 bidders for it at the end of this auction.", "");
        HypixelItemData.AddItemToData("Clubbed Fossil", "clubbed_fossil", "item", false, 4, 0, "\u00a74There is no information on how to obtain this item!\u00a74\u00a7r", "");
        HypixelItemData.AddItemToData("Crown of Greed", "crown_of_greed", "helmet", false, 4, 1000000, "The (rarityCode)Crown of Greed(eRarityCode) can be obtained by digging up Griffin Burrows with an EPIC or LEGENDARY \u00a75Griffin Pet\u00a75\u00a7r in the Mythological Ritual event, a perk of Mayor Diana.", "");
        HypixelItemData.AddItemToData("Cryopowder Shard", "cryopowder_shard", "item", false, 4, 0, "A (rarityCode)Cryopowder Shard(eRarityCode) has a 0.03% chance to drop from \u00a79Red Gifts\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Daedalus Stick", "daedalus_stick", "item", false, 4, 250000, "The (rarityCode)Daedalus Stick(eRarityCode) can only be obtained when Mayor Diana has her Mythological Ritual event active. Use the \u00a79Ancestral Spade\u00a79\u00a7r to dig up (enemyCode)Minotaurs(eEnemyCode) and kill them for a 0.08% chance of dropping one.", "");
        HypixelItemData.AddItemToData("Dark Claymore", "dark_claymore", "longsword", false, 4, 0, "The (rarityCode)Dark Claymore(eRarityCode) is obtainable from Bedrock Dungeon Reward Chests in the Master Mode (locationCode)Catacombs Floor VII(eLocationCode).", "");
        HypixelItemData.AddItemToData("Deathripper Dagger", "deathripper_dagger", "sword", false, 4, 0, "The (rarityCode)Pyrochaos Dagger(eRarityCode) can be crafted after unlocking Blaze Slayer 6. It can also be crafted using 64 \u00a79Molten Powder\u00a79\u00a7r, 16 \u00a75Inferno Vertexes\u00a75\u00a7r, 16 \u00a79Enchanted Sulphur Cubes\u00a79\u00a7r, and 1 \u00a75Mawdredge Dagger\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Ditto Blob", "ditto_blob", "cosmetic", false, 4, 0, "The (rarityCode)Ditto Blob(eRarityCode) can be purchased from the (locationCode)Bits Shop(eLocationCode) for \u00a7c600 Bits\u00a7c\u00a7r.", "");
        HypixelItemData.AddItemToData("Draconic Blade", "draconic_blade", "item", false, 4, 100000, "The (rarityCode)Draconic Blade(eRarityCode) is currently unobtainable.", "");
        HypixelItemData.AddItemToData("Dungeon Orb", "dungeon_orb", "item", true, 4, 0, "The (rarityCode)Dungeon Orb(eRarityCode) is given to the player at the start of their dungeon experience or whenever the player enters (locationCode)Entrance(eLocationCode), (locationCode)Floor 1(eLocationCode), or (locationCode)Floor 2(eLocationCode) of the Catacombs without a (rarityCode)Dungeon Orb(eRarityCode) in their inventory.", "");
        HypixelItemData.AddItemToData("Dungeon Sack", "dungeon_sack", "item", false, 4, 0, "The (rarityCode)Dungeon Sack(eRarityCode) can be purchased from the (locationCode)Bits Shop(eLocationCode) for \u00a7c14,000 Bits\u00a7c\u00a7r.", "");
        HypixelItemData.AddItemToData("Eccentric Painting", "eccentric_painting", "power stone", false, 4, 1, "(rarityCode)Eccentric Paintings(eRarityCode) can be obtained from the (rarityCode)Eccentric Painting Bundle(eRarityCode), which can be purchased from the Dark Auction. It has a 4.877% chance of showing up in the first or third round, and it cannot show up twice.", "");
        HypixelItemData.AddItemToData("Eccentric Painting Bundle", "eccentric_painting_bundle", "item", false, 4, 9, "An (rarityCode)Eccentric Painting Bundle(eRarityCode) can be bid on in the Dark Auction. It has a 4.877% chance of showing up in the first or third round, and it cannot show up twice.", "");
        HypixelItemData.AddItemToData("Ender Relic", "ender_relic", "accessory", false, 4, 0, "The (rarityCode)Ender Relic(eRarityCode) can be crafted after unlocking Enderman Slayer 7. It is crafted using 128 \u00a7aEnchanted Obsidian\u00a7a\u00a7r, 96 \u00a7aEnchanted Eyes of Ender\u00a7a\u00a7r, 1 (rarityCode)Exceedingly Rare Ender Artifact Upgrader(eRarityCode) and 1 \u00a75Ender Artifact\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Enderman Cortex Rewriter", "enderman_cortex_rewriter", "item", false, 4, 80000, "The (rarityCode)Enderman Cortex Rewriter(eRarityCode) has a 0.1% to drop from killing (enemyCode)Voidling Extremists(eRarityCode).", "");
        HypixelItemData.AddItemToData("Enriched Kuudra Chunk", "enriched_kuudra_chunk", "item", false, 4, 0, "The (rarityCode)Enriched Kuudra Chunk(eRarityCode) can be obtained by reaching Kuudra Collection V.", "");
        HypixelItemData.AddItemToData("Exceedingly Rare Ender Artifact Upgrader", "exceedingly_rare_ender_artifact_upgrader", "item", false, 4, 0, "The (rarityCode)Exceedingly Rare Ender Artifact Upgrader(eRarityCode) is a RNGesus item drop from the (enemyCode)Tier IV Voidgloom Seraph(eEnemyCode) Enderman Slayer boss (It will only drop once you've reached at least Enderman Slayer LVL 6).", "");
        HypixelItemData.AddItemToData("Condensed Fermento", "condensed_fermento", "item", false, 4, 2250000, "(rarityCode)Condensed Fermento(eRarityCode) can be crafted with 9 (rarityCode)Fermentos(eRarityCode).", "");
        HypixelItemData.AddItemToData("Digested Mosquito", "digested_mosquito", "item", false, 4, 0, "The (rarityCode)Digested Mosquito(eRarityCode) is a Pray RNGesus item drop from the (enemyCode)Tier IV Tarantula Broodfather(eEnemyCode) Spider Slayer boss. It will only drop once you've reached at least Spider Slayer LVL 7", "");
        HypixelItemData.AddItemToData("Dragon Egg", "dragon_egg", "item", false, 4, 0, "(rarityCode)Dragon Eggs(eRarityCode) have only ever been obtained through glitches, and are not intended to be in the game. They are a blacklisted item and cannot be auctioned.", "");
        HypixelItemData.AddItemToData("Fang-tastic Chocolate Chip", "fang-tastic_chocolate_chip", "power stone", false, 4, 10000, "The (rarityCode)Fang-tastic Chocolate Chip(eRarityCode) has a small chance to drop from a (enemyCode)Riftstalker Bloodfiend(eEnemyCode) after obtaining Vampire Slayer 3.", "");
        HypixelItemData.AddItemToData("Fel Skull", "fel_skull", "ITEM", true, 4, 0, "The (rarityCode)Fel Skull(eRarityCode) can be obtained from Dungeon Reward Chests in the (locationCode)Catacombs Floor VI(eLocationCode). Its base roll chance is 0.5624%.", "");
        HypixelItemData.AddItemToData("Felthorn Reaper", "felthorn_reaper", "LongSword", true, 4, 0, "The (rarityCode)Felthorn Reaper(eRarityCode) can be crafted with 5 \u00a75Fel Roses\u00a75\u00a7r, a \u00a76Fel Skull\u00a76\u00a7r, and a \u00a75Bone Reaver\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Fermento", "fermento", "item", false, 4, 250000, "(rarityCode)Fermento(eRarityCode) has a 0.005% to 0.007% chance to drop while using the \u00a75Squash Armor\u00a75\u00a7r while farming Sugar Cane, Cactus, Mushroom, or Nether Warts.", "");
        HypixelItemData.AddItemToData("Flex Helmet", "flex_helmet", "helmet", false, 4, 0, "A (rarityCode)Flex Helmet(eRarityCode) can be bid on as an auction at (locationCode)Barrier Street(eLocationCode) for \u00a7dMotes\u00a7d\u00a7r, in a similar way to Shen's Auction.", "");
        HypixelItemData.AddItemToData("Florid Zombie Sword", "florid_zombie_sword", "sword", false, 4, 0, "The (rarityCode)Florid Zombie Sword(eRarityCode) can be crafted using 24 \u00a79Healing Tissues\u00a79\u00a7r and an \u00a75Ornate Zombie Sword\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Flower of Truth", "flower_of_truth", "sword", true, 4, 100000, "The (rarityCode)Flower of Truth(eRarityCode) can be crafted using 9 \u00a79Ancient Roses\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Footprint Fossil", "footprint_fossil", "item", false, 4, 0, "There is no information on obtaining a (rarityCode)Footprint Fossil(eRarityCode).", "");
        HypixelItemData.AddItemToData("Frigid Husk", "frigid_husk", "reforge StOnE", false, 4, 0, "The (rarityCode)Frigid Husk(eRarityCode) can be Forged after reaching Glacite Collection VII. It is forged in the (locationCode)Dwarven Mines(eRarityCode) with 4 \u00a75Glacite Amalgamation\u00a75\u00a7r, and a \u00a75Flawless Onyx Gemstone\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Frosty The Howitzer", "frosty_the_howitzer", "item", false, 4, 100, "(rarityCode)Frosty The Howitzer(eRarityCode) can be obtained by combining \u00a75Frosty The Snow Blaster\u00a75\u00a7r with a \u00a76Cryopowder Shard\u00a76\u00a7r in an Anvil.", "");
        HypixelItemData.AddItemToData("Frozen Spider", "frozen_spider", "item", false, 4, 1, "The (rarityCode)Frozen Spider(eRarityCode) is obtained by fishing in the (locationCode)Spider's Den(eLocationCode) with an \u00a79Ice Rod\u00a79\u00a7r and Spooky Bait.", "");
        HypixelItemData.AddItemToData("Gemstone Gauntlet", "gemstone_gauntlet", "gauntlet", false, 4, 0, "The (rarityCode)Gemstone Gauntlet(eRarityCode) can be crafted after unlocking Gemstone Collection XI. It is crafted using 8 \u00a75Flawless Ruby Gemstones\u00a75\u00a7r and 16 \u00a79Enchanted Gold Blocks\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Giant Fishing Rod", "giant_fishing_rod", "fishing rod", false, 4, 0, "The (rarityCode)Giant Fishing Rod(eRarityCode) is sold on Shen's Auction, which can be found under the (locationCode)Auction House(eLocationCode) in the (locationCode)SkyBlock Hub(eLocationCode).", "");
        HypixelItemData.AddItemToData("Giant's Eye Sword", "giants_eye_sword", "sword", false, 4, 1000, "The (rarityCode)Giant's Eye Sword(eRarityCode) cannot be obtained.", "");
        HypixelItemData.AddItemToData("Giant's Sword", "giants_sword", "sword", false, 4, 1000, "The (rarityCode)Giant's Sword(eRarityCode) is obtainable from a Bedrock Dungeon Reward Chest in the (locationCode)Catacombs Floor VI(eLocationCode).", "");
        HypixelItemData.AddItemToData("Gillsplash Belt", "gillsplash_belt", "belt", false, 4, 9000, "The (rarityCode)Gillsplash Belt(eRarityCode) can be crafted with the \u00a75Finwave Belt\u00a75\u00a7r, 2 \u00a7dDiamond Magmafish\u00a7d\u00a7r and 6 \u00a75Lava Shells\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Gillsplash Cloak", "gillsplash_cloak", "cloak", false, 4, 9000, "The (rarityCode)Gillsplash Cloak(eRarityCode) can be crafted with the \u00a75Finwave Cloak\u00a75\u00a7r, 2 \u00a7dDiamond Magmafish\u00a7d\u00a7r and 4 \u00a75Lava Shells\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Gillsplash Gloves", "gillsplash_gloves", "gloves", false, 4, 9000, "(rarityCode)Gillsplash Gloves(eRarityCode) can be crafted with \u00a75Finwave Gloves\u00a75\u00a7r, 2 \u00a7dDiamond Magmafish\u00a7d\u00a7r and 3 \u00a75Lava Shells\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Glacite Shard", "glacite_shard", "power stone", false, 4, 1, "The (rarityCode)Glacite Shard(eRarityCode) has a 0.5% chance to drop from killing a (enemyCode)Glacite Mutt(eEnemyCode), (enemyCode)Glacite Caver(eEnemyCode), (enemyCode)Glacite Mage(eEnemyCode), or a (enemyCode)Glacite Bowman(eEnemyCode).", "");
        HypixelItemData.AddItemToData("Gold Gift Talisman", "gold_gift_talisman", "accessory", false, 4, 0, "The (rarityCode)Gold Gift Talisman(eRarityCode) can be purchased from Einary for \u00a7d200 North Stars\u00a7d\u00a7r and 1 \u00a75Purple Gift Talisman\u00a75\u00a7r. Unlike some other items sold from them, it can only be purchased in December.", "");
        HypixelItemData.AddItemToData("Golden Jerry Artifact", "golden_jerry_artifact", "accessory", false, 4, 0, "The (rarityCode)Golden Jerry Artifact(eRarityCode) can be crafted by combining 5 \u00a75Purple Jerry Talismans\u00a75\u00a7r together.", "");
        HypixelItemData.AddItemToData("Great Spook Staff", "great_spook_staff", "item", false, 4, 1, "The (rarityCode)Great Spook Staff(eRarityCode) can be obtained once by bringing 10 (rarityCode)Frozen Spiders(eRarityCode) to the Tyashoi Alchemist during the Alchemy Experiments Halloween Event.", "");
        HypixelItemData.AddItemToData("Great White Shark Tooth", "great_white_shark_tooth", "item", false, 4, 0, "The (rarityCode)Great White Shark Tooth(eRarityCode) can be obtained by killing a (enemyCode)Great White Shark(eEnemyCode) during a Fishing Festival. It has a base 10% drop chance, or a 2% drop chance from Loot Share.", "");
        HypixelItemData.AddItemToData("Great White Tooth Meal", "great_white_tooth_meal", "item", false, 4, 12000, "A piece of (rarityCode)Great White Tooth Meal(eRarityCode) can be crafted with 4 \u00a76Great White Shark Tooth\u00a76\u00a7r and an \u00a7aEnchanted Bone\u00a7a\u00a7r.", "");
        HypixelItemData.AddItemToData("Guardian Lucky Block", "guardian_lucky_block", "rift item", false, 4, 30000, "A (rarityCode)Guardian Lucky Block(eRarityCode) has a small chance to drop when defeating a (enemyCode)Riftstalker Bloodfiend(eEnemyCode) from a Vampire Slayer quest after obtaining Vampire Slayer 4.", "");
        HypixelItemData.AddItemToData("Heavy Pearl", "heavy_pearl", "item", false, 4, 0, "The (rarityCode)Heavy Pearl(eRarityCode) can be obtained from the (locationCode)Belly of the Beast(eLocationCode) under the (locationCode)Matriarch's Lair(eLocationCode), which can be accessed by being consumed by (enemyCode)The Matriarch(eEnemyCode). You can only obtain up to 3 (rarityCode)Heavy Pearls(eRarityCode) every 1 real life day, and they occasionally generate throughout the day if you haven't claimed 3 yet. If you aren't able to collect all three (rarityCode)Heavy Pearls(eRarityCode) successfully, you will be placed on a short 10 minute cooldown before being able to obtain any remaining ones, but 3 pearls is still the maximum per day. The maximum daily count can be increased up to 9 by consuming \u00a7cMatriarch's Perfume\u00a7c\u00a7r.", "");
        HypixelItemData.AddItemToData("Hegemony Artifact", "hegemony_artifact", "accessory", false, 4, 0, "The (rarityCode)Hegemony Artifact(eRarityCode) can only be purchased from the Dark Auction when Scorpius is the mayor of SkyBlock. Otherwise, players will have to buy it from the (locationCode)Auction House(eLocationCode) in the (locationCode)SkyBlock Hub(eLocationCode).", "");
        HypixelItemData.AddItemToData("Helix Fossil", "helix_fossil", "item", false, 4, 0, "The (rarityCode)Helix Fossil(eRarityCode) has a 1.31% chance to drop as a reward upon completing the (locationCode)Crystal Nucleus(eLocationCode) quest within the (locationCode)Crystal Hollows(eLocationCode).", "");
        HypixelItemData.AddItemToData("Hellfire Rod", "hellfire_rod", "fishing rod", false, 4, 5634000, "The (rarityCode)Hellfire Rod(eRarityCode) can be crafted with an \u00a75Inferno Rod\u00a75\u00a7r and 80 \u00a76Gold Magmafish\u00a76\u00a7r. This recipe is unlocked in the Magmafish Collection XII.", "");
        HypixelItemData.AddItemToData("High Class Archfiend Dice", "high_class_archfiend_dice", "item", false, 4, 0, "After reaching Blaze Slayer 7, the (rarityCode)High Class Archfiend Dice(eRarityCode) (eRarityCode)has a 0.25% chance to drop from the \u00a7lTier IV\u00a7l\u00a7r (enemyCode)Inferno Demonlord(eEnemyCode) when it is defeated.", "");
        HypixelItemData.AddItemToData("Hilt of True Ice", "hilt_of_true_ice", "item", false, 4, 0, "The (rarityCode)Hilt of True Ice(eRarityCode) is a rare drop from the (enemyCode)Yeti(eEnemyCode) sea creature.", "");
        HypixelItemData.AddItemToData("Hollow Wand", "hollow_wand", "wand", false, 4, 10000, "The (rarityCode)Hollow Wand(eRarityCode) has a small chance to spawn in a Kuudra Loot Chest at the end of a Kuudra run after defeating (enemyCode)Kuudra(eEnemyCode).", "");
        HypixelItemData.AddItemToData("Hot Stuff", "hot_stuff", "reforge stone", false, 4, 0, "(rarityCode)Hot Stuff(eRarityCode) is unlocked by reaching Hard Stone 4. It can be obtained through (locationCode)The Forge(eLocationCode) or through crafting. Forging takes 1 day and requires 64 Rough Amber Gemstone and 128 Hard Stone. Crafting requires 96 \u00a7aEnchanted Hard Stone\u00a7a\u00a7r and 1 Lava Bucket.", "");
        HypixelItemData.AddItemToData("Hypergolic Gabagool", "hypergolic_gabagool", "item", false, 4, 1, "The (rarityCode)Hypergolic Gabagool(eRarityCode) can be crafted with 12 \u00a75Heavy Gabagool\u00a75\u00a7r and 1 \u00a79Sulphuric Coal\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Hyperion", "hyperion", "sword", true, 4, 200, "The (rarityCode)Hyperion(eRarityCode) can be crafted using 8 \u00a75L.A.S.R.'s Eyes\u00a75\u00a7r and 1 \u00a76Necron's Blade (Unrefined)\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Infernal Kuudra Core", "infernal_kuudra_core", "accessory", false, 4, 1, "The (rarityCode)Infernal Kuudra Core(eRarityCode) is obtainable from combining 4 \u00a75Fiery Kuudra Cores\u00a75\u00a7r together.", "");
        HypixelItemData.AddItemToData("Inferno Apex", "inferno_apex", "item", false, 4, 0, "The (rarityCode)Inferno Apex(eRarityCode) has a 1/1,309,091 or 0.00007639% chance to be generated by an \u00a79Inferno Minion\u00a79\u00a7r that is using hypergolic \u00a76Inferno Minion Fuel\u00a76\u00a7r for each item generated. It can also be crafted using 16 \u00a75Hypergolic Ionized Ceramics\u00a75\u00a7r, 64 \u00a75Inferno Vertexes\u00a75\u00a7r, and 64 \u00a79Molten Powder\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("InfiniVacuum\u2122 Hooverius", "infinivacuum_hooverius", "vacuum", false, 4, 0, "The (rarityCode)InfiniVacuum\u2122 Hooverius(eRarityCode) can be bought for \u00a7c2,500 Copper\u00a7c\u00a7r, a \u00a76Chirping Stereo\u00a76\u00a7r, and an \u00a75InfiniVacuum\u2122\u00a75\u00a7r at (locationCode)SkyMart(eLocationCode).", "");
        HypixelItemData.AddItemToData("Jacobus Register", "jacobus_register", "accessory", false, 4, 0, "The (rarityCode)Jacobus Register(eRarityCode) is automatically unlocked after purchasing 10 additional Accessory Bag slots from \u00a7bJacobus\u00a7b\u00a7r, who is located in the (locationCode)Thaumaturgist(eLocationCode) in the (locationCode)Hub island(eLocationCode). This costs a total of \u00a7621,500,000 Coins\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Jerry 3D Glasses", "jerry_3d_glasses", "item", false, 4, 0, "The (rarityCode)Jerry 3D Glasses(eRarityCode) have a chance to drop from Jerry Boxes.", "");
        HypixelItemData.AddItemToData("Judgement Core", "judgement_core", "item", false, 4, 0, "The (rarityCode)Judgement Core(eRarityCode) is a Pray RNGesus item drop from the (enemyCode)Tier IV Voidgloom Seraph(eEnemyCode) Enderman Slayer boss. It will only drop once you've reached at least Enderman Slayer LVL 7.", "");
        HypixelItemData.AddItemToData("Jungle Heart", "jungle_heart", "item", false, 4, 0, "The (rarityCode)Jungle Heart(eRarityCode) can be obtained from all Treasure Chests in the (locationCode)Jungle section(eLocationCode) of the (locationCode)Crystal Hollows(eLocationCode).", "");
        HypixelItemData.AddItemToData("Kuudra Follower Relic", "kuudra_follower_relic", "accessory", false, 4, 0, "The (rarityCode)Kuudra Follower Relic(eRarityCode) can be obtained from speaking to the \u00a7bKuudra Gatekeeper\u00a7b\u00a7r while wearing a full set of \u00a7cKuudra Follower Armor\u00a7c\u00a7r with a \u00a75Kuudra Follower Artifact\u00a75\u00a7r and COMMON Kuudra Teeth Plaque in your inventory and then clicking the Poison Kuudra's Teeth! button. If you lose it, it can be re-purchased from \u00a7bRusty\u00a7b\u00a7r for \u00a76150,000,000 Coins\u00a76\u00a7r and 64 \u00a75Kuudra Teeth\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Magic Top Hat", "magic_top_hat", "item", false, 4, 0, "The (rarityCode)Magic Top Hat(eRarityCode) can be purchased from \u00a7bEinary\u00a7b\u00a7r for \u00a7d500 North Stars\u00a7d\u00a7r and 10 \u00a75Volcanic Rock\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Magma Bucket", "magma_bucket", "item", false, 4, 50000, "The (rarityCode)Magma Bucket(eRarityCode) can be crafted using 2 \u00a75Enchanted Lava Buckets\u00a75\u00a7r and 1 \u00a7cHeat Core\u00a7c\u00a7r.", "");
        HypixelItemData.AddItemToData("Magma Lord Fragment", "magma_lord_fragment", "item", false, 4, 0, "The (rarityCode)Magma Lord Fragment(eRarityCode) has a chance to be dropped after helping defeat a \u00a7lLevel 600\u00a7l\u00a7r (enemyCode)Lord Jawbus(eEnemyCode), which can be fished up on the (locationCode)Crimson Isle(eLocationCode).", "");
        HypixelItemData.AddItemToData("Master Skull - Tier 7", "master_skull_t7", "accessory", true, 4, 0, "A (rarityCode)Master Skull - Tier 7(eRarityCode) can be obtained by combining 4 \u00a75Master Skull - Tier 6\u00a75\u00a7r's together.", "");
        HypixelItemData.AddItemToData("Melon Dicer 3.0", "melon_dicer_3", "axe", false, 4, 0, "A (rarityCode)Melon Dicer 3.0(eRarityCode) can be crafted using 128 \u00a79Enchanted Melon Blocks\u00a79\u00a7r and 1 \u00a75Melon Dicer 2.0\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Midas Staff", "midas_staff", "sword", false, 4, 0, "The (rarityCode)Midas Staff(eRarityCode) can be obtained from the Dark Auction while \u00a7dScorpius\u00a7d\u00a7r is the active Mayor.", "");
        HypixelItemData.AddItemToData("Midas Sword", "midas_sword", "sword", false, 4, 10000, "The (rarityCode)Midas Sword(eRarityCode) can be bid on in the Dark Auction. It has a 7.542% chance of showing up once during the item pool rounds.", "");
        HypixelItemData.AddItemToData("Mixed Mite Gel", "mixed_mite_gel", "item", false, 4, 15000, "(rarityCode)Mixed Mite Gel(eRarityCode) is crafted from \u00a75Mite Gel\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Mosquito Bow", "mosquito_bow", "bow", false, 4, 0, "The (rarityCode)Mosquito Bow(eRarityCode) can be crafted after unlocking \u00a7lSpider Slayer 7\u00a7l\u00a7r. It is crafted using 192 \u00a79Tarantula Silk\u00a79\u00a7r, 128 \u00a7aEnchanted Iron\u00a7a\u00a7r, and 1 \u00a76Digested Mosquito\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Necromancer Sword", "necromancer_sword", "sword", true, 4, 1000, "The (rarityCode)Necromancer Sword(eRarityCode) is obtainable from either a \u00a7lBedrock\u00a7l\u00a7r or \u00a7lObsidian Dungeon Reward Chest\u00a7l\u00a7r in the (locationCode)Catacombs Floor VI(eLocationCode) or the (enemyCode)Sadan(eEnemyCode) Collection after defeating (enemyCode)Sadan(eEnemyCode) 750 times.", "");
        HypixelItemData.AddItemToData("Necron's Blade (Unrefined)", "unrefined_necrons_blade", "sword", true, 4, 200, "The (rarityCode)Necron's Blade (Unrefined)(eRarityCode) can be crafted using 24 \u00a79Wither Catalysts\u00a79\u00a7r and 1 \u00a75Necron's Handle\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Nether Star", "nether_star", "item", false, 4, 10000, "The (rarityCode)Nether Star(eRarityCode) can be dropped when killing a \u00a7llevel 100\u00a7l\u00a7r (enemyCode)Vanquisher(eEnemyCode), which has a chance to spawn when killing any mob on the (locationCode)Crimson Isle(eLocationCode).", "");
        HypixelItemData.AddItemToData("Null Blade", "null_blade", "item", false, 4, 0, "A (rarityCode)Null Blade(eRarityCode) can be crafted with 64 \u00a79Null Ovoids\u00a79\u00a7r, 64 \u00a79Enchanted Quartz Blocks\u00a79\u00a7r, and 3 \u00a75Null Edges\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Pendant of Divan", "pendant_of_divan", "necklace", false, 4, 0, "The (rarityCode)Divan's Pendant(eRarityCode) can be forged after reaching \u00a7lHeart of the Mountain Tier 10\u00a7l\u00a7r. It is forged with 1 \u00a76Shattered Locket\u00a76\u00a7r, 1 \u00a76Perfect Plate\u00a76\u00a7r, and 10 \u00a75Divan Fragments\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Perfect Chisel", "perfect_chisel", "chisel", false, 4, 1000, "The (rarityCode)Perfect Chisel(eRarityCode) can be forged after reaching \u00a7lHeart of the Mountain Tier 10\u00a7l\u00a7r. It is forged with 1 \u00a75Glacite-Plated Chisel\u00a75\u00a7r, 1 \u00a76Perfect Plate\u00a76\u00a7r, and 1 \u00a79Bejeweled Handle\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Perfect Plate", "perfect_plate", "item", false, 4, 0, "A (rarityCode)Perfect Plate(eRarityCode) can be forged after reaching \u00a7lHeart of the Mountain Tier 10\u00a7l\u00a7r. It is forged with 1 \u00a79Umber Plate\u00a79\u00a7r, 1 \u00a79Tungsten Plate\u00a79\u00a7r, and 1 \u00a79Mithril Plate\u00a79\u00a7r.", "");
        HypixelItemData.AddItemToData("Perfectly Cut Diamond", "perfectly_cut_diamond", "item", false, 4, 0, "A (rarityCode)Perfectly Cut Diamond(eRarityCode) can be purchased from (npcCode)Gemma(eNpcCode) for 1,000 \u00a7lDiamond Essence\u00a7l\u00a7r and 2 \u00a75Refined Diamonds\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Personal Compactor 7000", "personal_compactor_7000", "accessory", false, 4, 0, "The (rarityCode)Personal Compactor 7000(eRarityCode) can be crafted using 56 \u00a79Enchanted Redstone Blocks\u00a79\u00a7r and 1 \u00a75Personal Compactor 6000\u00a75\u00a7r. It can only be crafted after unlocking Redstone Collection XIV.", "");
        HypixelItemData.AddItemToData("Personal Deletor 7000", "personal_deletor_7000", "accessory", false, 4, 0, "The (rarityCode)Personal Deletor 7000(eRarityCode) can be unlocked from \u00a7lIron Collection XII\u00a7l\u00a7r and crafted by using 7 \u00a79Enchanted Iron Blocks\u00a79\u00a7r and 1 \u00a75Personal Deletor 6000\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Phantom Rod", "phantom_rod", "fishing rod", false, 4, 0, "The (rarityCode)Phantom Rod(eRarityCode) is dropped by the (enemyCode)Phantom Fisher(eEnemyCode). The base drop chance is 1%.", "");
        HypixelItemData.AddItemToData("Pig Mask", "pig_mask", "helmet", false, 4, 0, "The (rarityCode)Pig Mask(eRarityCode) cannot currently be obtained.", "");
        HypixelItemData.AddItemToData("Pigman Sword", "pigman_sword", "sword", false, 4, 3100000, "The (rarityCode)Pigman Sword(eRarityCode) can be crafted with 48 Enchanted Grilled Pork and a single Stick after unlocking \u00a7lRaw Porkchop Collection IX (9)\u00a7l\u00a7r.", "");
        HypixelItemData.AddItemToData("Plasma Nucleus", "plasma_nucleus", "item", false, 4, 0, "The (rarityCode)Plasma Nucleus(eRarityCode) is obtained from the Dark Auction. It is only sold when (npcCode)Scorpius(eNpcCode) is the active mayor.", "");
        HypixelItemData.AddItemToData("Plasmaflux Power Orb", "plasmaflux_power_orb", "power orb", false, 4, 0, "The (rarityCode)Plasmaflux Power Orb(eRarityCode) is crafted using 256 \u00a7aEnchanted Obsidian\u00a7a\u00a7r, 72 \u00a79Golden Tooth\u00a79\u00a7r, 1 \u00a75Overflux Power Orb\u00a75\u00a7r, and 1 \u00a76Plasma Nucleus\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Pooch Sword", "pooch_sword", "sword", false, 4, 0, "The (rarityCode)Pooch Sword(eRarityCode) can be crafted after unlocking \u00a7lWolf Slayer 6\u00a7l\u00a7r. It can also be crafted using 48 \u00a79Golden Teeth\u00a79\u00a7r and 1 \u00a75Shaman Sword\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Potato Crown", "potato_crown", "helmet", false, 4, 0, "The (rarityCode)Potato Crown(eRarityCode) cannot currently be obtained.", "");
        HypixelItemData.AddItemToData("Precursor Eye", "precursor_eye", "helmet", true, 4, 1000, "The (rarityCode)Precursor Eye(eRarityCode) can be obtained from a \u00a7lBedrock Dungeon Reward Chest\u00a7l\u00a7r in the (locationCode)Catacombs Floor VI(eLocationCode).", "");
        HypixelItemData.AddItemToData("Primal Dragon Egg", "primal_dragon_egg", "item", false, 4, 0, "The (rarityCode)Primal Dragon Egg(eRarityCode) has a \u00a7l0.1%\u00a7l\u00a7r chance per placed \u00a76Awakened Summoning Eye\u00a76\u00a7r to drop from defeating a (enemyCode)Primal Dragon(eEnemyCode) in (locationCode)The End(eLocationCode).", "");
        HypixelItemData.AddItemToData("Pumpkin Dicer 3.0", "pumpkin_dicer_3.0", "axe", false, 4, 0, "A (rarityCode)Pumpkin Dicer 3.0(eRarityCode) can be crafted using 32 \u00a79Polished Pumpkins\u00a79\u00a7r and 1 \u00a75Pumpkin Dicer 2.0\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Pure Mithril Gem", "pure_mithril_gem", "item", false, 4, 0, "A (rarityCode)Pure Mithril Gem(eRarityCode) has a \u00a7l1% chance\u00a7l\u00a7r to drop from a (enemyCode)Diamond Goblin(eEnemyCode).", "");
        HypixelItemData.AddItemToData("Pyrochaos Dagger", "pyrochaos_dagger", "sword", false, 4, 0, "The (rarityCode)Pyrochaos Dagger(eRarityCode) can be crafted after unlocking \u00a7lBlaze Slayer 6\u00a7l\u00a7r. It is crafted using 64 \u00a79Molten Powder\u00a79\u00a7r, 16 \u00a75Inferno Vertexes\u00a75\u00a7r, 8 \u00a76Gold Magmafish\u00a76\u00a7r, and 1 \u00a75Kindlebane Dagger\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Racing Helmet", "racing_helmet", "helmet", false, 4, 0, "The (rarityCode)Racing Helmet(eRarityCode) can be obtained in Shen's Auction. It is awarded to the ten players who place the highest bids.", "");
        HypixelItemData.AddItemToData("Random Century Cake Bundle", "random_century_cake_bundle", "item", false, 4, 0, "The (rarityCode)Random Century Cake Bundle(eRarityCode) cannot currently be obtained. However, this item can be traded between players.", "");
        HypixelItemData.AddItemToData("Razor-sharp Shark Tooth Necklace", "razorsharp_shark_tooth_necklace", "accessory", false, 4, 0, "The (rarityCode)Razor-sharp Shark Tooth Necklace(eRarityCode) can be crafted using 1 \u00a75Sharp Shark Tooth Necklace\u00a75\u00a7r and 4 \u00a76Great White Shark Teeth\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Reaper Gem", "reaper_gem", "pet item", false, 4, 0, "A (rarityCode)Reaper Gem(eRarityCode) is obtained from reaching \u00a7lZombie Slayer 9\u00a7l\u00a7r.", "");
        HypixelItemData.AddItemToData("Reaper Mask", "reaper_mask", "helmet", false, 4, 0, "After reaching \u00a7lZombie Slayer 7\u00a7l\u00a7r, a (rarityCode)Reaper Mask(eRarityCode) can be crafted with 128 \u00a79Revenant Viscera\u00a79\u00a7r, 32 \u00a7aEnchanted String\u00a7a\u00a7r, a \u00a75Beheaded Horror\u00a75\u00a7r, and a \u00a75Revived Heart\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Reaper Orb", "reaper_orb", "accessory", false, 4, 0, "The (rarityCode)Reaper Orb(eRarityCode) can be crafted after unlocking \u00a7lZombie Slayer Level 8\u00a7l\u00a7r. One can be crafted using 8 \u00a76Scythe Blades\u00a76\u00a7r.", "");
        HypixelItemData.AddItemToData("Reaper Pepper", "reaper_pepper", "item", false, 4, 0, "The (rarityCode)Reaper Pepper(eRarityCode) has a \u00a7l0.00021825% chance\u00a7l\u00a7r to be generated by an (npcCode)Inferno Minion(eNpcCode) that is using hypergolic \u00a76Inferno Minion Fuel\u00a76\u00a7r for each item generated.", "");
        HypixelItemData.AddItemToData("Reaper Scythe", "reaper_scythe", "sword", false, 4, 0, "The (rarityCode)Reaper Scythe(eRarityCode) can be crafted using 64 \u00a79Revenant Viscera\u00a79\u00a7r, 3 \u00a75Reaper Falchions\u00a75\u00a7r, and \u00a76Scythe Blade\u00a76\u00a7r. The (rarityCode)Reaper Scythe(eRarityCode) can only be crafted once \u00a7lZombie Slayer Level 7\u00a7l\u00a7r is reached.", "");
        HypixelItemData.AddItemToData("Refined Dark Cacao Truffle", "refined_dark_cacao_truffle", "item", false, 4, 0, "The (rarityCode)Refined Dark Cacao Truffle(eRarityCode) can be obtained by keeping a \u00a79Dark Cacao Truffle\u00a79\u00a7r in your inventory for \u00a7l300 real hours\u00a7l\u00a7r (\u00a7l18,000 real minutes\u00a7l\u00a7r).", "");
        HypixelItemData.AddItemToData("Refined Titanium", "refined_titanium", "item", false, 4, 51000, "(rarityCode)Refined Titanium(eRarityCode) can be forged in (locationCode)The Forge(eLocationCode) after reaching \u00a7lHeart of the Mountain Tier 2\u00a7l\u00a7r. This recipe requires 16 \u00a75Enchanted Titanium\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Revive Stone", "revive_stone", "item", true, 4, 1, "The (rarityCode)Revive Stone(eRarityCode) can be obtained by through various ways, the most common way to obtain these items are by killing (creatureCode)fairies(eCreatureCode) in a (locationCode)Fairy Room(eLocationCode) in any (locationCode)Dungeon Floor(eLocationCode).", "");
        HypixelItemData.AddItemToData("Rift Necklace", "rift_necklace", "necklace", false, 4, 0, "The (rarityCode)Rift Necklace(eRarityCode) can be obtained by talking to (npcCode)Elise(eNpcCode) in the (locationCode)Wizard's Tower(eLocationCode) on the (locationCode)Hub Island(eLocationCode).", "There are 2 variants of the (rarityCode)Rift Necklace(eRarityCode). There is a \u00a7d\u00a7l\u00a7k$\u00a7d\u00a7l\u00a7r\u00a7dMYTHIC\u00a7d\u00a7r\u00a7d\u00a7l\u00a7k$\u00a7d\u00a7r one and a \u00a76\u00a7lLEGENDARY\u00a76\u00a7r one. The \u00a76\u00a7lLEGENDARY\u00a76\u00a7r one can be obtained by talking to (npcCode)Elise(eNpcCode) in (locationCode)the Hub(eLocationCode) and the other (npcCode)Elise(eNpcCode) in (locationCode)The Rift(eLocationCode).");
        HypixelItemData.AddItemToData("Ring of Broken Love", "ring_of_broken_love", "accessory", false, 4, 0, "The (rarityCode)Ring of Broken Love(eRarityCode) can be obtained at the end of (npcCode)Detective Amog's(eNpcCode) quest.", "");
        HypixelItemData.AddItemToData("Rod of The Sea", "rod_of_the_sea", "fishing rod", false, 4, 111000, "The (rarityCode)Rod of The Sea(eRarityCode) can be crafted with 4 \u00a76Great White Shark Tooth\u00a76\u00a7r, 4 \u00a75Enchanted Shark Fins\u00a75\u00a7r, and 1 \u00a75Rod of Legends\u00a75\u00a7r.", "");
        HypixelItemData.AddItemToData("Royal Pigeon", "royal_pigeon", "item", false, 4, 0, "A (rarityCode)Royal Pigeon(eRarityCode) can be unlocked upon completing \u00a7l500 Commissions\u00a7l\u00a7r in the (locationCode)Dwarven Mines(eLocationCode) or the (locationCode)Crystal Hollows(eLocationCode).", "");
    }

    private static void AddItemToData(String itemName, String itemId, String itemType, Boolean isDungeon, Integer itemRarity, Integer npcSellPrice, String obtaining, String additionalInformation) {
        Object newHypixelItemsJSON = hypixelItemsJSON.replace("]", "");
        if (((String)newHypixelItemsJSON).endsWith("}")) {
            newHypixelItemsJSON = (String)newHypixelItemsJSON + ",";
        }
        Object rarity = isDungeon != false ? String.format("%s\u00a7l%s DUNGEON %s\u00a7r", itemRarityCodes[itemRarity], itemRarityNames[itemRarity], itemType.toUpperCase()) : String.format("%s\u00a7l%s%s %s\u00a7r", itemRarityCodes[itemRarity], itemRarityNames[itemRarity], itemType.toUpperCase(), itemRarityCodes[itemRarity]);
        String price = null;
        if (itemRarity == 5) {
            rarity = "\u00a7d\u00a7k\u00a7l#\u00a7r " + (String)rarity + " \u00a7d\u00a7k\u00a7l#\u00a7r";
        }
        price = npcSellPrice == 1 ? String.format("\u00a76%s coin\u00a7r", String.format("%,d", npcSellPrice)) : (npcSellPrice >= 2 ? String.format("\u00a76%s coins\u00a7r", String.format("%,d", npcSellPrice)) : "Unsalable");
        String parsedAdditionalInformation = additionalInformation.isEmpty() ? "No additional information given." : additionalInformation;
        hypixelItemsJSON = newHypixelItemsJSON = (String)newHypixelItemsJSON + String.format("{\"item_name\":\"(rarityCode)%s\u00a7r\",\"item_id\":\"%s\",\"item_rarity\":\"%s\",\"npc_sp\":\"%s\",\"obtaining\":\"%s\",\"additional_information\":\"%s\"}]", itemName, itemId, rarity, price, obtaining, parsedAdditionalInformation).replace("(rarityCode)", itemRarityCodes[itemRarity]).replace("(eRarityCode)", itemRarityCodes[itemRarity] + "\u00a7r").replace("(locationCode)", locationCode).replace("(eLocationCode)", "\u00a72\u00a7r").replace("(enemyCode)", enemyCode).replace("(eEnemyCode)", "\u00a74\u00a7r").replace("(npcCode)", npcCode).replace("(eNpcCode)", "\u00a7b\u00a7r").replace("(creatureCode)", creatureCode).replace("(eCreatureCode)", "\u00a73\u00a7r");
    }

    public static String getHypixelItemsJSON() {
        return hypixelItemsJSON;
    }
}

