/*
 * Decompiled with CFR 0.152.
 */
package com.hightide.fabric.commands.command;

import com.hightide.fabric.commands.modules.HTSoundManager;
import com.hightide.fabric.commands.modules.ScamChecker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_3417;

public class ScammerDB {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hsbscammers").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"Check").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"public", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ScammerDB.checkPlayer((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), BoolArgumentType.getBool((CommandContext)ctx, (String)"public"))))).executes(ctx -> ScammerDB.displayErrorMessage((FabricClientCommandSource)ctx.getSource(), 0)))).executes(ctx -> ScammerDB.displayErrorMessage((FabricClientCommandSource)ctx.getSource(), 1)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"Report").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"reason", (ArgumentType)StringArgumentType.string()).executes(ctx -> ScammerDB.reportPlayer((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"reason")))))).executes(ctx -> ScammerDB.displayErrorMessage((FabricClientCommandSource)ctx.getSource(), 3)))).executes(ctx -> ScammerDB.displayErrorMessage((FabricClientCommandSource)ctx.getSource(), 2)));
    }

    private static int checkPlayer(FabricClientCommandSource source, String playerName, boolean isPublic) {
        boolean isScammer = ScamChecker.isPlayerInDatabase(playerName);
        if (isScammer) {
            if (isPublic) {
                source.getPlayer().field_3944.method_45729("[HTSBCMDS] !!WARNING!! Player \"" + playerName + "\" is registered on the scammer database! Please be careful while trading!");
            } else {
                source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)("\u00a7c\u00a7l!!WARNING!! \u00a7cPlayer \"" + playerName + "\" is registered as a scammer!\nTrade with them at your own discretion...\u00a7f")));
            }
            source.getClient().field_1724.method_5783(class_3417.field_14608, 1.0f, 0.7f);
        } else {
            source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)("\u00a7aPlayer \"" + playerName + "\" is not registered as a scammer!\u00a7f")));
        }
        return 0;
    }

    private static int reportPlayer(FabricClientCommandSource source, String playerName, String reason) {
        String charactersAllowed = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        for (int i = 0; i < playerName.length(); ++i) {
            if (charactersAllowed.contains(String.valueOf(playerName.charAt(i)))) continue;
            source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)"\u00a7cThe players name must not contain special characters!\u00a7f"));
            HTSoundManager.PlayClientSound(HTSoundManager.CommandSoundType.ERROR, source.getClient(), class_3417.field_15008, 1.0f, 0.7f);
            return 0;
        }
        if (playerName.length() > 16) {
            source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)"\u00a7cThe players name must not exceed 16 characters!\u00a7f"));
            HTSoundManager.PlayClientSound(HTSoundManager.CommandSoundType.ERROR, source.getClient(), class_3417.field_15008, 1.0f, 0.7f);
            return 0;
        }
        int reportSuccess = ScamChecker.addPlayerReport(playerName, reason);
        if (reportSuccess == 1) {
            source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)("\u00a7aSuccessfully reported " + playerName + " for \"" + reason + "\"!\u00a7f")));
            HTSoundManager.PlayClientSound(HTSoundManager.CommandSoundType.SUCCESS, source.getClient(), class_3417.field_14709, 1.0f, 0.9f);
        } else if (reportSuccess == 2) {
            source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)"\u00a7cYou have been banned from reporting users! (Likely due to spam).\u00a7f"));
            HTSoundManager.PlayClientSound(HTSoundManager.CommandSoundType.ERROR, source.getClient(), class_3417.field_14608, 1.0f, 0.6f);
        } else {
            source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)"\u00a7cFailed to create a report! Please try again later...\u00a7f"));
            HTSoundManager.PlayClientSound(HTSoundManager.CommandSoundType.ERROR, source.getClient(), class_3417.field_15008, 1.0f, 0.7f);
        }
        return 0;
    }

    private static int displayErrorMessage(FabricClientCommandSource source, int errorId) {
        String[] errors = new String[]{"\u00a7cYou must specify either true or false! /hsbscammers <player> <public?(true/false)>\u00a7f", "\u00a7cYou must specify a player! /hsbscammers <player> <public?(true/false)>\u00a7f", "\u00a7cYou must choose to Check a player or Report a player! /hsbscammers (Report/Check) <player> <public(true/false)>\u00a7f", "\u00a7cIn order to report a player, you must specify a player!\u00a7f"};
        source.getClient().field_1705.method_1743().method_1812(class_2561.method_30163((String)errors[errorId]));
        HTSoundManager.PlayClientSound(HTSoundManager.CommandSoundType.ERROR, source.getClient(), class_3417.field_15008, 1.0f, 0.7f);
        return 0;
    }
}

