/*
 * Decompiled with CFR 0.152.
 */
package com.hightide.fabric.commands.hypixel;

import java.util.Optional;

public final class HypixelRecipe {
    public String recipeName;
    public String recipeId;
    public String recipeCategory;
    public String[] recipeIngredients = new String[0];
    public String[] recipeRequirements = new String[0];

    public HypixelRecipe(String recipeName, String recipeId, String recipeCategory, String[] recipeIngredients, String[] recipeRequirements) {
        this.recipeName = recipeName;
        this.recipeId = recipeId;
        this.recipeCategory = recipeCategory;
        this.recipeIngredients = recipeIngredients;
        this.recipeRequirements = recipeRequirements;
    }

    public int getIngredientCount() {
        return this.recipeIngredients.length;
    }

    public int getRequirementCount() {
        return this.recipeRequirements.length;
    }

    public String getRecipeData() {
        StringBuilder tempData = new StringBuilder();
        tempData.append("\u00a7aRecipe Name:\u00a7a\u00a7r ").append(this.recipeName).append("\n");
        tempData.append("\u00a7aRecipe ID:\u00a7a\u00a7r ").append(this.recipeId).append("\n");
        tempData.append("\u00a7aCategory:\u00a7a\u00a7r ").append(this.recipeCategory).append("\n");
        tempData.append("\u00a7aRecipe Ingredients:\u00a7a\u00a7r\n");
        for (String recipeIngredient : this.recipeIngredients) {
            tempData.append("\u00a7b-\u00a7b\u00a7r ").append(recipeIngredient).append("\n");
        }
        if (this.recipeRequirements.length > 0) {
            tempData.append("\u00a7aRecipe Requirements:\u00a7a\u00a7r\n");
            for (String recipeRequirement : this.recipeIngredients) {
                tempData.append("\u00a7b-\u00a7b\u00a7r ").append(recipeRequirement).append("\n");
            }
        }
        if (tempData.toString().endsWith("\n")) {
            Optional.of(tempData.toString()).map(str -> str.substring(0, str.length() - 1));
        }
        return tempData.toString();
    }
}

