/*
 * Decompiled with CFR 0.152.
 */
package com.hightide.fabric.commands.modules;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class HyRepManager {
    private static final String API_URL = "https://hightide.coolpage.biz/api/hypixel/sbcmds/rep/api.php?player=";
    private static final Gson gson = new Gson();

    public static PlayerReputation getPlayerReputation(String player) throws Exception {
        String line;
        URL url = new URL(API_URL + player);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = br.readLine()) != null) {
            response.append(line);
        }
        br.close();
        conn.disconnect();
        return (PlayerReputation)gson.fromJson(response.toString(), PlayerReputation.class);
    }

    public static PlayerReputation updatePlayerReputation(String player, String direction, String self) throws Exception {
        String line;
        if (!direction.equals("up") && !direction.equals("down")) {
            throw new IllegalArgumentException("Invalid direction: Use 'up' or 'down'");
        }
        URL url = new URL(API_URL + player + "&direction=" + direction + "&self=" + self);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = br.readLine()) != null) {
            response.append(line);
        }
        br.close();
        conn.disconnect();
        return (PlayerReputation)gson.fromJson(response.toString(), PlayerReputation.class);
    }

    public class PlayerReputation {
        public String player;
        public int reputation;
    }
}

