/*
 * Decompiled with CFR 0.152.
 */
package com.hightide.fabric.commands.modules;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class ScamChecker {
    public static boolean isPlayerInDatabase(String playerName) {
        try {
            String line;
            String apiUrl = "https://hightide.coolpage.biz/api/hypixel/sbcmds/scams/api.php?player=" + playerName;
            URL url = new URL(apiUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("HTTP error: " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            br.close();
            conn.disconnect();
            return response.toString().contains("\"exists\":true");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int addPlayerReport(String playerName, String reportReason) {
        try {
            String line;
            String encodedReason = URLEncoder.encode(reportReason, "UTF-8");
            String apiUrl = "https://hightide.coolpage.biz/api/hypixel/sbcmds/scams/api.php?player=" + URLEncoder.encode(playerName, "UTF-8") + "&report=" + encodedReason;
            URL url = new URL(apiUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("HTTP error: " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            br.close();
            conn.disconnect();
            if (response.toString().contains("\"success\":\"Report submitted successfully\"")) {
                return 1;
            }
            if (response.toString().contains("\"error\":\"Access denied: Your IP is banned\"")) {
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

