/*
 * Decompiled with CFR 0.152.
 */
package org.nka.notchplease;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWNativeCocoa;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Unique;

public class Notchplease
implements ClientModInitializer {
    static String gpuName;
    static boolean isAppleSilicon;
    static boolean isMacOS;
    public static ArrayList<Integer> resolutionHeights;

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            if (isMacOS) {
                gpuName = GL11.glGetString((int)7937);
                isAppleSilicon = gpuName != null && gpuName.contains("Apple");
            }
        });
    }

    public static boolean listAvailableResolutions() {
        if (!isMacOS || !isAppleSilicon) {
            return false;
        }
        resolutionHeights = new ArrayList();
        long window = class_310.method_1551().method_22683().method_4490();
        long monitor = GLFW.glfwGetWindowMonitor((long)window);
        if (monitor == 0L) {
            return false;
        }
        int displayID = GLFWNativeCocoa.glfwGetCocoaMonitor((long)monitor);
        if (CoreGraphics.INSTANCE.CGDisplayIsBuiltin(displayID) == 0) {
            return false;
        }
        GLFWVidMode.Buffer vidModes = GLFW.glfwGetVideoModes((long)monitor);
        if (vidModes == null) {
            return false;
        }
        for (int i = 0; i < vidModes.limit(); ++i) {
            GLFWVidMode mode = (GLFWVidMode)vidModes.get(i);
            resolutionHeights.add(mode.height());
        }
        return !resolutionHeights.isEmpty();
    }

    @Unique
    public static int getScaledNotchHeight() {
        if (!(isMacOS && isAppleSilicon && Notchplease.listAvailableResolutions())) {
            return -1;
        }
        int currentHeight = class_310.method_1551().method_22683().method_4507();
        boolean isFullScreen = class_310.method_1551().method_22683().method_4498();
        double currentScale = class_310.method_1551().method_22683().method_4495();
        if (currentHeight % 10 == 0 || resolutionHeights == null || !isFullScreen || !isAppleSilicon) {
            return -1;
        }
        int rawNotchHeight = Notchplease.getRawNotchHeight(currentHeight);
        if (rawNotchHeight > 200 || rawNotchHeight < 0) {
            return -1;
        }
        return (int)((double)rawNotchHeight / currentScale);
    }

    private static int getRawNotchHeight(int currentHeight) {
        int closestNonNotchedHeight = Integer.MIN_VALUE;
        int closestHeightDiff = Integer.MAX_VALUE;
        for (Integer height : resolutionHeights) {
            int currentHeightDiff = Math.abs(currentHeight - height);
            if (height >= currentHeight || currentHeightDiff >= closestHeightDiff) continue;
            closestHeightDiff = currentHeightDiff;
            closestNonNotchedHeight = height;
        }
        return currentHeight - closestNonNotchedHeight;
    }

    static {
        isAppleSilicon = false;
        isMacOS = false;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("mac")) {
            System.out.println("Notch, Please! macOS detected.");
            isMacOS = true;
        } else {
            System.out.println("Notch, Please! Non-macOS system detected. No changes will be made.");
        }
        resolutionHeights = new ArrayList();
    }

    public static interface CoreGraphics
    extends Library {
        public static final CoreGraphics INSTANCE = (CoreGraphics)Native.load((String)"CoreGraphics", CoreGraphics.class);

        public int CGDisplayIsBuiltin(int var1);
    }
}

