/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.smoothpickup;

import dev.mineland.smoothpickup.SmoothPickup;
import dev.mineland.smoothpickup.optionsParser;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.Scanner;

public class SmoothPickupConfig {
    private boolean freeGridEnabled = true;
    private boolean itemTransition = false;
    private double lerpThing = 0.5;
    public final Path defaultConfigPath = Path.of("config", "smooth_pickup.cfg");
    public static SmoothPickupConfig DEFAULT = new SmoothPickupConfig();

    public SmoothPickupConfig() {
        this.freeGridEnabled = true;
        this.itemTransition = false;
        this.lerpThing = 0.5;
    }

    public SmoothPickupConfig(SmoothPickupConfig settings) {
        this.copyFrom(settings);
    }

    public void loadSettings() {
        this.loadSettingsFromFile(this.defaultConfigPath);
    }

    public void loadSettingsFromFile(Path filePath) {
        File file = filePath.toFile();
        try {
            if (!file.exists()) {
                SmoothPickup.logger.debug("creating config file at " + file.getPath());
                file.createNewFile();
                file.mkdirs();
                this.writeConfig(filePath);
                SmoothPickup.logger.debug("Created new config file");
                return;
            }
            Scanner scanner = new Scanner(file);
            int currentLine = 0;
            HashMap<Integer, String> errors = new HashMap<Integer, String>();
            while (scanner.hasNext()) {
                ++currentLine;
                String line = scanner.nextLine();
                if (line.trim().isEmpty()) continue;
                String[] equalSplitted = line.split("=");
                int equalsSplit = equalSplitted.length;
                if (equalsSplit != 2) {
                    errors.put(currentLine, String.format("Line has incorret = amounts! [%s]", line));
                    continue;
                }
                String key = equalSplitted[0].trim();
                String value = equalSplitted[1].trim();
                switch (key) {
                    case "free_grid_enabled": {
                        Optional<Boolean> option = optionsParser.parseBoolean(value);
                        if (option.isEmpty()) {
                            errors.put(currentLine, String.format("free_grid_enabled was incorrect! [%s]", line));
                            this.freeGridEnabled = SmoothPickupConfig.DEFAULT.freeGridEnabled;
                            break;
                        }
                        this.freeGridEnabled = option.get();
                        break;
                    }
                    case "item_transition": {
                        Optional<Boolean> option = optionsParser.parseBoolean(value);
                        if (option.isEmpty()) {
                            errors.put(currentLine, String.format("item_transition was incorrect! [%s]", line));
                            this.itemTransition = SmoothPickupConfig.DEFAULT.itemTransition;
                            break;
                        }
                        this.itemTransition = option.get();
                    }
                }
            }
            SmoothPickup.logger.debug(String.format("Loaded config from %s", filePath));
            if (!errors.isEmpty()) {
                StringBuilder errorListString = new StringBuilder();
                for (Integer key : errors.keySet()) {
                    errorListString.append(String.format(":%d | %s\n", key, errors.get(key)));
                }
                SmoothPickup.logger.warn(String.format("Found %d errors when loading the config.\n%s", errors.size(), errorListString));
            }
        }
        catch (Exception e) {
            SmoothPickup.logger.error("Failed to read config! \n", (Throwable)e);
        }
    }

    public void loadSettingsFromString(String settings) {
    }

    public void writeConfig(Path configFilePath) {
        try (FileWriter fileWriter = new FileWriter(configFilePath.toFile());){
            String template = "free_grid_enabled = %s\nitem_transition = %s";
            String finalFileText = template.formatted(this.freeGridEnabled, this.itemTransition);
            fileWriter.write(finalFileText);
        }
        catch (Exception e) {
            SmoothPickup.logger.error("Failed to write config! \n{}", (Object)String.valueOf(e));
        }
    }

    public void flushConfig() {
        this.writeConfig(this.defaultConfigPath);
    }

    public void copyFrom(SmoothPickupConfig config) {
        this.freeGridEnabled = config.freeGridEnabled;
        this.itemTransition = config.itemTransition;
        this.lerpThing = config.lerpThing;
    }

    public SmoothPickupConfig copy() {
        return new SmoothPickupConfig(this);
    }

    public boolean isFreeGridEnabled() {
        return this.freeGridEnabled;
    }

    public void setFreeGridEnabled(boolean freeGridEnabled) {
        this.freeGridEnabled = freeGridEnabled;
    }

    public void toggleFreeGridEnabled() {
        this.freeGridEnabled = !this.freeGridEnabled;
    }

    public boolean isItemTransition() {
        return this.itemTransition;
    }

    public void setItemTransition(boolean itemTransition) {
        this.itemTransition = itemTransition;
    }

    public double getLerpThing() {
        return this.lerpThing;
    }

    public void setLerpThing(double lerpThing) {
        this.lerpThing = lerpThing;
    }
}

