/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.smoothpickup;

import dev.mineland.smoothpickup.GuiUtils;
import dev.mineland.smoothpickup.SmoothPickup;
import dev.mineland.smoothpickup.SmoothPickupGlobals;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.MenuTooltipPositioner;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class InventoryHotswapMethods {
    public static void renderCarriedItemHead(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        if (!SmoothPickup.getActiveConfig().isFreeGridEnabled()) {
            return;
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(GuiUtils.getRenderX() - (float)i, GuiUtils.getRenderY() - (float)j);
        SmoothPickupGlobals.carriedItemIsRendering = true;
    }

    public static void renderCarriedItemTail(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        if (!SmoothPickup.getActiveConfig().isFreeGridEnabled()) {
            return;
        }
        guiGraphics.pose().popMatrix();
        SmoothPickupGlobals.carriedItemIsRendering = false;
    }

    public static void renderTooltipHead(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        SmoothPickupGlobals.tooltipIsRendering = true;
    }

    public static void renderTooltipTail(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        SmoothPickupGlobals.tooltipIsRendering = false;
    }

    public static void renderGuiTooltipHead(GuiGraphics guiGraphics, Font font, List<ClientTooltipComponent> list, int i, int j, ClientTooltipPositioner clientTooltipPositioner, @Nullable ResourceLocation resourceLocation, CallbackInfo ci) {
        if (!SmoothPickup.getActiveConfig().isFreeGridEnabled()) {
            return;
        }
        float newPosX = GuiUtils.getRenderX() - (float)i;
        float newPosY = GuiUtils.getRenderY() - (float)j;
        if (clientTooltipPositioner.getClass() == MenuTooltipPositioner.class) {
            int minX = 0;
            int minY = list.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clientTooltipComponent : list) {
                int m = clientTooltipComponent.getWidth(font);
                if (m > minX) {
                    minX = m;
                }
                minY += clientTooltipComponent.getHeight(font);
            }
            Vector2ic positionVector2i = clientTooltipPositioner.positionTooltip(Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight(), i, j, minX, minY);
            Vector2ic nextPositionVector2i = clientTooltipPositioner.positionTooltip(Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight(), i, j + 1, minX, minY);
            newPosY *= (float)(nextPositionVector2i.y() - positionVector2i.y());
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(newPosX, newPosY);
    }

    public static void renderGuiTooltipTail(GuiGraphics guiGraphics, Font font, List<ClientTooltipComponent> list, int i, int j, ClientTooltipPositioner clientTooltipPositioner, @Nullable ResourceLocation resourceLocation, CallbackInfo ci) {
        if (!SmoothPickup.getActiveConfig().isFreeGridEnabled()) {
            return;
        }
        guiGraphics.pose().popMatrix();
    }
}

