/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.smoothpickup.screens;

import dev.mineland.smoothpickup.SmoothPickup;
import dev.mineland.smoothpickup.SmoothPickupConfig;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class SmoothPickupConfigScreen
extends Screen {
    private Screen parent;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 33, 33);
    private final HashMap<AbstractWidget, settingsStuff> settingsWidgets = new HashMap();
    private final SmoothPickupConfig backupConfig;
    private final SmoothPickupConfig config = SmoothPickup.getActiveConfig();
    private final Button btnFreeGrid = Button.builder((Component)Component.literal((String)"Enable free grid"), button -> this.settingsWidgets.get(button).onClick()).tooltip(Tooltip.create((Component)Component.translatable((String)"smoothPickup.settings.isFreeGridEnabled.tooltip"))).build();

    public SmoothPickupConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"smoothPickup.settings.title"));
        this.parent = parent;
        this.font = Minecraft.getInstance().font;
        this.backupConfig = SmoothPickup.getActiveConfig().copy();
        this.config.loadSettings();
        this.createLayout();
        this.settingsWidgets.put((AbstractWidget)this.btnFreeGrid, new settingsStuff(){

            @Override
            public void onClick() {
                SmoothPickupConfigScreen.this.config.toggleFreeGridEnabled();
                this.updateText();
            }

            @Override
            public void updateText() {
                SmoothPickupConfigScreen.this.btnFreeGrid.setMessage(SmoothPickupConfigScreen.this.getButtonText((Component)Component.translatable((String)"smoothPickup.settings.isFreeGridEnabled"), SmoothPickupConfigScreen.this.config.isFreeGridEnabled()));
            }
        });
    }

    void createLayout() {
        this.layout.addTitleHeader((Component)Component.translatable((String)"smoothPickup.settings.title"), this.getFont());
        LinearLayout footerLayout = LinearLayout.horizontal().spacing(8);
        footerLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onCancel()).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).build());
        this.layout.addToFooter((LayoutElement)footerLayout);
        LinearLayout mainBodyLayout = LinearLayout.vertical();
        mainBodyLayout.addChild((LayoutElement)this.btnFreeGrid);
        this.layout.addToContents((LayoutElement)mainBodyLayout);
    }

    protected void init() {
        this.layout.visitWidgets(widget -> {
            AbstractWidget h = (AbstractWidget)this.addRenderableWidget((GuiEventListener)widget);
            if (this.settingsWidgets.containsKey(h)) {
                this.settingsWidgets.get(h).updateText();
            }
        });
        this.layout.arrangeElements();
    }

    public void onClose() {
        this.flushSettings();
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void onCancel() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
        SmoothPickup.activeConfig = this.backupConfig;
    }

    public void updateButtonText() {
    }

    public void flushSettings() {
        SmoothPickup.logger.debug("Flushing settings!");
        this.config.flushConfig();
    }

    private Component getButtonText(Component trans, Number value) {
        return this.getButtonTextInternal(trans, (Component)Component.literal((String)value.toString()));
    }

    private Component getButtonText(Component trans, String value) {
        return this.getButtonTextInternal(trans, (Component)Component.literal((String)value));
    }

    private Component getButtonText(Component trans, Boolean value) {
        MutableComponent valueComponent = Component.literal((String)String.format("%b", value));
        valueComponent.withStyle(Style.EMPTY.withColor(value != false ? ChatFormatting.GREEN : ChatFormatting.RED));
        return this.getButtonTextInternal(trans, (Component)valueComponent);
    }

    private Component getButtonTextInternal(Component trans, Component valueComponent) {
        MutableComponent separatorComponent = Component.literal((String)": ");
        return Component.empty().append(trans).append((Component)separatorComponent).append(valueComponent);
    }

    private static interface settingsStuff {
        public void onClick();

        public void updateText();
    }
}

