/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.change_of_cart.common.dispenser;

import com.davigj.change_of_cart.core.ChangeOfCart;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class HoneycombDispenseBehavior
extends OptionalDispenseItemBehavior {
    @NotNull
    protected ItemStack execute(BlockSource p_123580_, @NotNull ItemStack stack) {
        ServerLevel level = p_123580_.level();
        if (!level.isClientSide()) {
            BlockPos blockpos = p_123580_.pos().relative((Direction)p_123580_.state().getValue((Property)DispenserBlock.FACING));
            this.setSuccess(HoneycombDispenseBehavior.tryWaxCart(level, blockpos));
            if (this.isSuccess()) {
                stack.shrink(1);
            }
        }
        return stack;
    }

    private static boolean tryWaxCart(ServerLevel level, BlockPos pos) {
        TrackedDataManager manager = TrackedDataManager.INSTANCE;
        for (AbstractMinecart cart : level.getEntitiesOfClass(AbstractMinecart.class, new AABB(pos), EntitySelector.NO_SPECTATORS)) {
            if (((Boolean)manager.getValue((Entity)cart, ChangeOfCart.WAXED)).booleanValue()) continue;
            manager.setValue((Entity)cart, ChangeOfCart.WAXED, (Object)true);
            level.playSound((Player)null, cart.getX(), cart.getY(), cart.getZ(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.NEUTRAL, 1.0f, 0.8f);
            if (!level.isClientSide) {
                for (int i = 0; i < 5; ++i) {
                    RandomSource random = level.getRandom();
                    level.sendParticles((ParticleOptions)ParticleTypes.WAX_ON, cart.getX() + random.nextDouble() - 0.5, cart.getEyeY() + random.nextDouble(), cart.getZ() + random.nextDouble() - 0.5, 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            return true;
        }
        return false;
    }
}

