/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.change_of_cart.core.mixin;

import com.davigj.change_of_cart.core.CCConfig;
import com.davigj.change_of_cart.core.ChangeOfCart;
import com.davigj.change_of_cart.core.other.CCBlockTags;
import com.davigj.change_of_cart.core.other.CCItemTags;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractMinecart.class})
public class AbstractMinecartMixin {
    @ModifyVariable(method={"applyNaturalSlowdown"}, at=@At(value="STORE", ordinal=0), name={"d0"})
    private double modifySlowdownFactor(double d0) {
        AbstractMinecart cart = (AbstractMinecart)this;
        double frictionBonus = 0.0;
        if (cart.level().getBlockState(cart.blockPosition().below()).is(CCBlockTags.RAIL_BEDDING)) {
            frictionBonus += (double)((Integer)CCConfig.COMMON.railBeddingBonus.get()).intValue() * 0.1 * 0.003;
        }
        if (((Boolean)TrackedDataManager.INSTANCE.getValue((Entity)cart, ChangeOfCart.WAXED)).booleanValue()) {
            frictionBonus += (double)((Integer)CCConfig.COMMON.waxFrictionBonus.get()).intValue() * 0.1 * 0.003;
        }
        if (frictionBonus != 0.0) {
            frictionBonus = Mth.clamp((double)frictionBonus, (double)0.0, (double)0.003);
            d0 = cart.isVehicle() ? 0.997 + frictionBonus : 0.96 + frictionBonus * 10.0;
        }
        return d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (ModList.get().isLoaded("copperative")) {
            AbstractMinecart cart = (AbstractMinecart)this;
            if (cart.level().isClientSide) {
                Minecraft minecraft = Minecraft.getInstance();
                LocalPlayer player = minecraft.player;
                if (player != null && (player.getMainHandItem().is(CCItemTags.WAX_INDICATORS) || player.getOffhandItem().is(CCItemTags.WAX_INDICATORS))) {
                    TrackedDataManager manager = TrackedDataManager.INSTANCE;
                    RandomSource random = cart.level().getRandom();
                    if (cart.tickCount % 5 == 0 && player.level() instanceof ClientLevel && ((Boolean)manager.getValue((Entity)cart, ChangeOfCart.WAXED)).booleanValue()) {
                        cart.level().addParticle((ParticleOptions)ParticleTypes.WAX_ON, cart.getX() + random.nextDouble() - 0.5, cart.getEyeY() + random.nextDouble() - 0.35, cart.getZ() + random.nextDouble() - 0.5, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }
}

