/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import shipItemTransport.code.Logger;
import shipItemTransport.code.ShipItemTransportBlock;

public class ChestHelper {
    public static boolean isChest(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ChestBlock) {
            return true;
        }
        Logger.sendMessage("block is not a chest", false);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            return blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
        }
        Logger.sendMessage("block is not a chest", false);
        return false;
    }

    public static boolean isDoubleChest(Level level, BlockPos chestPos1, BlockPos chestPos2) {
        Logger.sendMessage("in is double chest method", false);
        if (!level.m_46749_(chestPos1) || !level.m_46749_(chestPos2)) {
            return false;
        }
        BlockState state1 = level.m_8055_(chestPos1);
        BlockState state2 = level.m_8055_(chestPos2);
        if (state1.m_60734_() != state2.m_60734_()) {
            return false;
        }
        if (state1.m_60734_() instanceof ChestBlock) {
            ChestType type1 = (ChestType)state1.m_61143_((Property)ChestBlock.f_51479_);
            ChestType type2 = (ChestType)state2.m_61143_((Property)ChestBlock.f_51479_);
            Direction facing1 = (Direction)state1.m_61143_((Property)ChestBlock.f_51478_);
            Direction facing2 = (Direction)state2.m_61143_((Property)ChestBlock.f_51478_);
            Logger.sendMessage("Checking if double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_() + " type 1== " + type1, false);
            if (facing1 != facing2) {
                return false;
            }
            if (facing1 == Direction.SOUTH) {
                if (type1 == ChestType.LEFT && chestPos1.m_123341_() - 1 == chestPos2.m_123341_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
                if (type1 == ChestType.RIGHT && chestPos1.m_123341_() + 1 == chestPos2.m_123341_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
            }
            if (facing1 == Direction.NORTH) {
                if (type1 == ChestType.LEFT && chestPos1.m_123341_() + 1 == chestPos2.m_123341_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
                if (type1 == ChestType.RIGHT && chestPos1.m_123341_() - 1 == chestPos2.m_123341_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
            }
            if (facing1 == Direction.EAST) {
                if (type1 == ChestType.RIGHT && chestPos1.m_123343_() - 1 == chestPos2.m_123343_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
                if (type1 == ChestType.LEFT && chestPos1.m_123343_() + 1 == chestPos2.m_123343_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
            }
            if (facing1 == Direction.WEST) {
                if (type1 == ChestType.RIGHT && chestPos1.m_123343_() + 1 == chestPos2.m_123343_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
                if (type1 == ChestType.LEFT && chestPos1.m_123343_() - 1 == chestPos2.m_123343_()) {
                    Logger.sendMessage("Detected double chest between " + chestPos1 + " and " + chestPos2 + " (facing1: " + facing1 + ") (facing2: " + facing2 + ") axis == " + facing1.m_122434_(), false);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean areChestsConnected(ChestBlockEntity chest1, ChestBlockEntity chest2) {
        BlockState state1 = chest1.m_58900_();
        BlockState state2 = chest2.m_58900_();
        if (state1.m_60734_() instanceof ChestBlock && state2.m_60734_() instanceof ChestBlock) {
            ChestType type1 = (ChestType)state1.m_61143_((Property)ChestBlock.f_51479_);
            ChestType type2 = (ChestType)state2.m_61143_((Property)ChestBlock.f_51479_);
            return type1 != ChestType.SINGLE || type2 != ChestType.SINGLE;
        }
        return false;
    }

    private static boolean arePositionsAdjacent(BlockPos pos1, BlockPos pos2) {
        int dx = Math.abs(pos1.m_123341_() - pos2.m_123341_());
        int dz = Math.abs(pos1.m_123343_() - pos2.m_123343_());
        return dx == 1 && dz == 0 || dx == 0 && dz == 1;
    }

    public static Set<BlockPos> findConnectedChests(Level level, BlockPos startPos) {
        HashSet<BlockPos> connected = new HashSet<BlockPos>();
        connected.add(startPos);
        for (Direction dir : ChestHelper.getPossibleDoubleChestDirections()) {
            BlockPos neighbor = startPos.m_121945_(dir);
            Logger.sendMessage("Checking Direction for double chest dir== " + dir, false);
            if (!ChestHelper.isChest(level, neighbor) || !ChestHelper.isDoubleChest(level, startPos, neighbor)) continue;
            connected.add(neighbor);
            Logger.sendMessage("Found direct double chest connection: " + startPos + " <-> " + neighbor, false);
            break;
        }
        return connected;
    }

    private static Direction[] getPossibleDoubleChestDirections() {
        return new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    }

    public static BlockPos determinePrimaryPosition(Set<BlockPos> chestGroup) {
        if (chestGroup.size() == 1) {
            return chestGroup.iterator().next();
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(chestGroup);
        BlockPos pos1 = (BlockPos)positions.get(0);
        BlockPos pos2 = (BlockPos)positions.get(1);
        Level level = ChestHelper.getLevelFromAnyPosition(positions);
        if (level != null) {
            BlockState state1 = level.m_8055_(pos1);
            BlockState state2 = level.m_8055_(pos2);
            if (state1.m_60734_() instanceof ChestBlock && state2.m_60734_() instanceof ChestBlock) {
                ChestType type1 = (ChestType)state1.m_61143_((Property)ChestBlock.f_51479_);
                ChestType type2 = (ChestType)state2.m_61143_((Property)ChestBlock.f_51479_);
                if (type1 == ChestType.LEFT) {
                    return pos1;
                }
                if (type2 == ChestType.LEFT) {
                    return pos2;
                }
            }
        }
        return positions.stream().min((p1, p2) -> {
            int xCompare = Integer.compare(p1.m_123341_(), p2.m_123341_());
            if (xCompare != 0) {
                return xCompare;
            }
            return Integer.compare(p1.m_123343_(), p2.m_123343_());
        }).orElse((BlockPos)positions.get(0));
    }

    private static Level getLevelFromAnyPosition(Collection<BlockPos> positions) {
        if (positions.isEmpty()) {
            return null;
        }
        BlockPos firstPos = positions.iterator().next();
        return null;
    }

    public static Direction[] getValidConnectionDirections(Level level, BlockPos multiblockPos) {
        BlockState state = level.m_8055_(multiblockPos);
        if (state.m_61138_((Property)ShipItemTransportBlock.FACING)) {
            Direction facing = (Direction)state.m_61143_((Property)ShipItemTransportBlock.FACING);
            return (Direction[])Arrays.stream(Direction.values()).filter(dir -> dir != facing).toArray(Direction[]::new);
        }
        return Direction.values();
    }
}

