/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    public static boolean SEND_LOGS_TO_ALL_PLAYERS = false;
    public static boolean CREATE_LOG_FILES = false;
    public static boolean CONSOLE_LOGS = true;
    public static int ITEM_TRANSFER_RATE = 4;
    private static final String CONFIG_FILE_NAME = "ship_item_transporter.toml";
    private static final String DEFAULT_CONFIG = "# Ship Item Transporter Configuration\n# Whether to send multiblock logs to all players in chat\nsendLogsToAllPlayers=false\n\n# Whether to create log files in the logs/ directory\ncreateLogFiles=false\n\n# Whether to output logs to console (useful for debugging)\nconsoleLogs=true\n\n# Item transport settings\n# How many items to transfer per tick (20 ticks = 1 second)\nitemTransferRate=4\n\n";

    public static void load() {
        try {
            Path configDir = FMLPaths.CONFIGDIR.get();
            Path configFile = configDir.resolve(CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                Config.createDefaultConfig(configFile);
            }
            Config.readConfig(configFile);
            Config.applyConfig();
            if (CONSOLE_LOGS) {
                System.out.println("[Ship Item Transporter] Config loaded successfully");
            }
        }
        catch (Exception e) {
            System.out.println("[Ship Item Transporter] Failed to load config: " + e.getMessage());
            Config.applyDefaults();
        }
    }

    private static void createDefaultConfig(Path configFile) throws IOException {
        Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
        Files.write(configFile, DEFAULT_CONFIG.getBytes(), new OpenOption[0]);
        if (CONSOLE_LOGS) {
            System.out.println("[Ship Item Transporter] Created default config file");
        }
    }

    private static void readConfig(Path configFile) throws IOException {
        String[] lines;
        String content = new String(Files.readAllBytes(configFile));
        for (String line : lines = content.split("\n")) {
            String[] parts;
            if ((line = line.trim()).startsWith("#") || line.isEmpty() || (parts = line.split("=", 2)).length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            Config.parseConfigValue(key, value);
        }
    }

    private static void parseConfigValue(String key, String value) {
        block15: {
            try {
                switch (key) {
                    case "sendLogsToAllPlayers": {
                        SEND_LOGS_TO_ALL_PLAYERS = Config.parseBoolean(value, false);
                        break;
                    }
                    case "createLogFiles": {
                        CREATE_LOG_FILES = Config.parseBoolean(value, false);
                        break;
                    }
                    case "consoleLogs": {
                        CONSOLE_LOGS = Config.parseBoolean(value, true);
                        break;
                    }
                    case "itemTransferRate": {
                        ITEM_TRANSFER_RATE = Config.parseInt(value, 4);
                        break;
                    }
                    default: {
                        if (CONSOLE_LOGS) {
                            System.out.println("[Ship Item Transporter] Unknown config option: " + key);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!CONSOLE_LOGS) break block15;
                System.out.println("[Ship Item Transporter] Invalid value for " + key + ": " + value);
            }
        }
    }

    private static int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (CONSOLE_LOGS) {
                System.out.println("[Ship Item Transporter] Using default value " + defaultValue + " for " + value);
            }
            return defaultValue;
        }
    }

    private static boolean parseBoolean(String value, boolean defaultValue) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if (CONSOLE_LOGS) {
            System.out.println("[Ship Item Transporter] Using default value " + defaultValue + " for " + value);
        }
        return defaultValue;
    }

    private static void applyConfig() {
        if (CONSOLE_LOGS) {
            System.out.println("[Ship Item Transporter] Config applied:");
            System.out.println("[Ship Item Transporter] - Player logs: " + SEND_LOGS_TO_ALL_PLAYERS);
            System.out.println("[Ship Item Transporter] - File logs: " + CREATE_LOG_FILES);
            System.out.println("[Ship Item Transporter] - Console logs: " + CONSOLE_LOGS);
            System.out.println("[Ship Item Transporter] - Item transfer rate: " + ITEM_TRANSFER_RATE);
        }
    }

    private static void applyDefaults() {
        SEND_LOGS_TO_ALL_PLAYERS = false;
        CREATE_LOG_FILES = false;
        CONSOLE_LOGS = true;
        ITEM_TRANSFER_RATE = 4;
    }

    public static void reload() {
        Config.load();
    }
}

