/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.ShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import shipItemTransport.code.BlockCountSyncPacket;
import shipItemTransport.code.ChestCountSyncPacket;
import shipItemTransport.code.ChestHelper;
import shipItemTransport.code.Config;
import shipItemTransport.code.Logger;
import shipItemTransport.code.NetworkHandler;
import shipItemTransport.code.ShipInfoSyncPacket;
import shipItemTransport.code.ShipItemTransportBlock;
import shipItemTransport.code.ShipItemTransportBlockEntity;
import shipItemTransport.code.ShipItemTransportMenu;

public class MultiblockManager {
    private final Map<String, MultiblockData> multiblocks = new HashMap<String, MultiblockData>();
    private final Map<BlockPos, String> blockToMultiblock = new HashMap<BlockPos, String>();
    private final Map<String, Boolean> multiblockModes = new HashMap<String, Boolean>();
    private final Map<String, Set<BlockPos>> multiblockChests = new HashMap<String, Set<BlockPos>>();
    private final Map<BlockPos, Set<String>> chestToMultiblocks = new HashMap<BlockPos, Set<String>>();
    private final Map<BlockPos, Set<BlockPos>> chestGroups = new HashMap<BlockPos, Set<BlockPos>>();
    private final Map<BlockPos, BlockPos> chestToPrimary = new HashMap<BlockPos, BlockPos>();
    private static Map<Level, MultiblockManager> multiblockManagers = new WeakHashMap<Level, MultiblockManager>();
    private final Level level;
    private final Map<String, MultiblockTransferData> transferDataCache = new HashMap<String, MultiblockTransferData>();
    private int transferTickCounter = 0;

    public MultiblockManager(Level level) {
        this.level = level;
    }

    public static MultiblockManager get(Level level) {
        if (multiblockManagers.containsKey(level)) {
            return multiblockManagers.get(level);
        }
        MultiblockManager manager = new MultiblockManager(level);
        multiblockManagers.put(level, manager);
        return manager;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (MultiblockManager manager : multiblockManagers.values()) {
                manager.tick();
            }
        }
    }

    public void tick() {
        if (this.level.f_46443_) {
            return;
        }
        ++this.transferTickCounter;
        if (this.transferTickCounter >= 50) {
            this.transferTickCounter = 0;
            this.runItemTransfers();
        }
    }

    private void runItemTransfers() {
        Logger.sendMessage("=== Starting transfer cycle ===", true);
        this.updateTransferDataCache();
        ArrayList<MultiblockTransferData> allMultiblocks = new ArrayList<MultiblockTransferData>(this.transferDataCache.values());
        Logger.sendMessage("Multiblocks in cache: " + allMultiblocks.size(), true);
        int pairsChecked = 0;
        int transfersExecuted = 0;
        for (int i = 0; i < allMultiblocks.size(); ++i) {
            for (int j = i + 1; j < allMultiblocks.size(); ++j) {
                MultiblockTransferData data2;
                ++pairsChecked;
                MultiblockTransferData data1 = (MultiblockTransferData)allMultiblocks.get(i);
                if (!this.shouldTransferBetween(data1, data2 = (MultiblockTransferData)allMultiblocks.get(j))) continue;
                ++transfersExecuted;
                this.executeItemTransfer(data1, data2);
            }
        }
        Logger.sendMessage(String.format("Pairs checked: %d, Transfers executed: %d", pairsChecked, transfersExecuted), true);
        Logger.sendMessage("=== Transfer cycle complete ===", true);
    }

    private void updateTransferDataCache() {
        this.transferDataCache.clear();
        for (Map.Entry<String, MultiblockData> entry : this.multiblocks.entrySet()) {
            String multiblockId = entry.getKey();
            MultiblockData data = entry.getValue();
            Direction worldFacing = this.calculateWorldFacing(data);
            AABB extendedOBB = this.calculateExtendedOBB(data, worldFacing);
            Vec3 center = this.calculateWorldCenter(data, extendedOBB);
            boolean isImportMode = this.getMultiblockMode(multiblockId);
            int blockCount = data.blocks.size();
            Set chests = this.multiblockChests.getOrDefault(multiblockId, new HashSet());
            MultiblockTransferData transferData = new MultiblockTransferData(multiblockId, data.blocks, data.isOnShip, data.shipId, worldFacing, extendedOBB, isImportMode, blockCount, chests, center);
            this.transferDataCache.put(multiblockId, transferData);
            Logger.sendMessage(String.format("Multiblock %s: blocks=%d, facing=%s, mode=%s, onShip=%s, chests=%d, center=%s", multiblockId, blockCount, worldFacing, isImportMode ? "IMPORT" : "EXPORT", data.isOnShip, chests.size(), center.toString()), true);
        }
    }

    private Vec3 calculateWorldCenter(MultiblockData data, AABB localOBB) {
        if (!data.isOnShip || data.shipId == null) {
            return new Vec3(localOBB.f_82288_ + (localOBB.f_82291_ - localOBB.f_82288_) / 2.0, localOBB.f_82289_ + (localOBB.f_82292_ - localOBB.f_82289_) / 2.0, localOBB.f_82290_ + (localOBB.f_82293_ - localOBB.f_82290_) / 2.0);
        }
        Ship ship = this.findShipById(data.shipId);
        if (ship == null) {
            return new Vec3(localOBB.f_82288_ + (localOBB.f_82291_ - localOBB.f_82288_) / 2.0, localOBB.f_82289_ + (localOBB.f_82292_ - localOBB.f_82289_) / 2.0, localOBB.f_82290_ + (localOBB.f_82293_ - localOBB.f_82290_) / 2.0);
        }
        double centerX = localOBB.f_82288_ + (localOBB.f_82291_ - localOBB.f_82288_) / 2.0;
        double centerY = localOBB.f_82289_ + (localOBB.f_82292_ - localOBB.f_82289_) / 2.0;
        double centerZ = localOBB.f_82290_ + (localOBB.f_82293_ - localOBB.f_82290_) / 2.0;
        Vector3d localCenter = new Vector3d(centerX, centerY, centerZ);
        Vector3d worldCenter = new Vector3d((Vector3dc)localCenter);
        ship.getTransform().getShipToWorld().transformPosition(worldCenter);
        Logger.sendMessage(String.format("Ship center transform: local(%.2f, %.2f, %.2f) -> world(%.2f, %.2f, %.2f)", centerX, centerY, centerZ, worldCenter.x, worldCenter.y, worldCenter.z), true);
        return new Vec3(worldCenter.x, worldCenter.y, worldCenter.z);
    }

    private Direction calculateWorldFacing(MultiblockData data) {
        Logger.sendMessage("=== CALCULATING WORLD FACING ===", true);
        if (!data.isOnShip || data.shipId == null) {
            BlockPos firstPos = data.blocks.iterator().next();
            BlockState state = this.level.m_8055_(firstPos);
            Direction facing = Direction.NORTH;
            if (state.m_61138_((Property)ShipItemTransportBlock.FACING)) {
                facing = (Direction)state.m_61143_((Property)ShipItemTransportBlock.FACING);
            }
            Logger.sendMessage("Ground multiblock - Using local facing: " + facing, true);
            return facing;
        }
        Ship ship = this.findShipById(data.shipId);
        if (ship == null) {
            Logger.sendMessage("Ship not found for ID: " + data.shipId + " - using local facing", true);
            BlockPos firstPos = data.blocks.iterator().next();
            BlockState state = this.level.m_8055_(firstPos);
            Direction facing = Direction.NORTH;
            if (state.m_61138_((Property)ShipItemTransportBlock.FACING)) {
                facing = (Direction)state.m_61143_((Property)ShipItemTransportBlock.FACING);
            }
            return facing;
        }
        BlockPos firstPos = data.blocks.iterator().next();
        BlockState state = this.level.m_8055_(firstPos);
        Direction localFacing = Direction.NORTH;
        if (state.m_61138_((Property)ShipItemTransportBlock.FACING)) {
            localFacing = (Direction)state.m_61143_((Property)ShipItemTransportBlock.FACING);
        }
        Logger.sendMessage("Ship multiblock - Local facing: " + localFacing, true);
        Vector3d localFacingVector = this.getDirectionVector(localFacing);
        Logger.sendMessage("Local facing vector: " + String.format("(%.2f, %.2f, %.2f)", localFacingVector.x, localFacingVector.y, localFacingVector.z), true);
        Vector3d worldFacingVector = this.transformLocalToWorld(ship, localFacingVector);
        Logger.sendMessage("World facing vector: " + String.format("(%.2f, %.2f, %.2f)", worldFacingVector.x, worldFacingVector.y, worldFacingVector.z), true);
        Direction worldFacing = this.getClosestDirection(worldFacingVector);
        Logger.sendMessage("Final world facing: " + worldFacing, true);
        try {
            ShipTransform transform = ship.getTransform();
            Vector3d shipPos = (Vector3d)transform.getPositionInWorld();
            Logger.sendMessage("Ship position: " + String.format("(%.2f, %.2f, %.2f)", shipPos.x, shipPos.y, shipPos.z), true);
            Vector3d testNorth = new Vector3d(0.0, 0.0, -1.0);
            Vector3d testNorthWorld = new Vector3d((Vector3dc)testNorth);
            transform.getShipToWorld().transformDirection(testNorthWorld);
            Logger.sendMessage("Test NORTH in world: " + String.format("(%.2f, %.2f, %.2f) -> %s", testNorth.x, testNorth.y, testNorth.z, this.getClosestDirection(testNorthWorld)), true);
            Vector3d testEast = new Vector3d(1.0, 0.0, 0.0);
            Vector3d testEastWorld = new Vector3d((Vector3dc)testEast);
            transform.getShipToWorld().transformDirection(testEastWorld);
            Logger.sendMessage("Test EAST in world: " + String.format("(%.2f, %.2f, %.2f) -> %s", testEast.x, testEast.y, testEast.z, this.getClosestDirection(testEastWorld)), true);
        }
        catch (Exception e) {
            Logger.sendMessage("Error getting ship transform: " + e.getMessage(), true);
        }
        Logger.sendMessage("=== END WORLD FACING CALCULATION ===", true);
        return worldFacing;
    }

    private Vector3d getDirectionVector(Direction direction) {
        return new Vector3d((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
    }

    private Vector3d transformLocalToWorld(Ship ship, Vector3d localVector) {
        Vector3d worldVector = new Vector3d((Vector3dc)localVector);
        ship.getTransform().getShipToWorld().transformDirection(worldVector);
        return worldVector.normalize();
    }

    private Direction getClosestDirection(Vector3d vector) {
        double maxDot = -1.7976931348623157E308;
        Direction closestDirection = Direction.NORTH;
        for (Direction dir : Direction.values()) {
            Vector3d dirVector = this.getDirectionVector(dir);
            double dot = vector.dot((Vector3dc)dirVector);
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            closestDirection = dir;
        }
        return closestDirection;
    }

    private AABB calculateExtendedOBB(MultiblockData data, Direction worldFacing) {
        Logger.sendMessage("=== CALCULATING EXTENDED OBB ===", true);
        Logger.sendMessage("World facing for OBB: " + worldFacing, true);
        AABB baseAABB = null;
        for (BlockPos pos : data.blocks) {
            AABB blockAABB = data.isOnShip && data.shipId != null ? new AABB(pos) : new AABB(pos);
            if (baseAABB == null) {
                baseAABB = blockAABB;
                continue;
            }
            baseAABB = baseAABB.m_82367_(blockAABB);
        }
        if (baseAABB == null) {
            Logger.sendMessage("No blocks found for OBB calculation", true);
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        Logger.sendMessage("Base OBB: " + baseAABB.toString(), true);
        AABB extendedOBB = baseAABB.m_82363_((double)worldFacing.m_122429_(), (double)worldFacing.m_122430_(), (double)worldFacing.m_122431_());
        Logger.sendMessage("Extended OBB: " + extendedOBB.toString(), true);
        Logger.sendMessage("=== END OBB CALCULATION ===", true);
        return extendedOBB;
    }

    private Ship findShipById(Long shipId) {
        if (this.level.f_46443_) {
            return null;
        }
        ShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((Level)this.level);
        if (shipWorld == null) {
            return null;
        }
        return shipWorld.getAllShips().getById(shipId.longValue());
    }

    private boolean shouldTransferBetween(MultiblockTransferData data1, MultiblockTransferData data2) {
        Logger.sendMessage("=== TRANSFER CHECK BETWEEN " + data1.multiblockId + " AND " + data2.multiblockId + " ===", true);
        Logger.sendMessage("Multiblock 1 - OnShip: " + data1.isOnShip + ", Facing: " + data1.worldFacing + ", Mode: " + (data1.isImportMode ? "IMPORT" : "EXPORT"), true);
        Logger.sendMessage("Multiblock 2 - OnShip: " + data2.isOnShip + ", Facing: " + data2.worldFacing + ", Mode: " + (data2.isImportMode ? "IMPORT" : "EXPORT"), true);
        if (!this.areMultiblocksClose(data1, data2)) {
            Logger.sendMessage("  \u274c Failed: Too far apart", true);
            return false;
        }
        Logger.sendMessage("  \u2705 Passed: Distance check", true);
        if (!this.shouldTransferBasedOnLocation(data1, data2)) {
            Logger.sendMessage("  \u274c Failed: Location filter", true);
            return false;
        }
        Logger.sendMessage("  \u2705 Passed: Location filter", true);
        if (!this.shouldTransferBasedOnMode(data1, data2)) {
            Logger.sendMessage("  \u274c Failed: Mode compatibility", true);
            return false;
        }
        Logger.sendMessage("  \u2705 Passed: Mode compatibility", true);
        Logger.sendMessage("=== OBB INTERSECTION CHECK ===", true);
        Logger.sendMessage("OBB1 (Ship): " + data1.extendedOBB.toString(), true);
        Logger.sendMessage("OBB2 (Ground): " + data2.extendedOBB.toString(), true);
        AABB obb1World = data1.extendedOBB;
        AABB obb2World = data2.extendedOBB;
        if (data1.isOnShip && data1.shipId != null) {
            obb1World = this.transformOBBToWorld(data1);
            Logger.sendMessage("Transformed OBB1 to world: " + obb1World.toString(), true);
        }
        if (data2.isOnShip && data2.shipId != null) {
            obb2World = this.transformOBBToWorld(data2);
            Logger.sendMessage("Transformed OBB2 to world: " + obb1World.toString(), true);
        }
        Logger.sendMessage("=== OBB INTERSECTION CHECK after the transform to world ===", true);
        Logger.sendMessage("OBB1 (Ship): " + obb1World.toString(), true);
        Logger.sendMessage("OBB2 (Ground): " + obb2World.toString(), true);
        boolean intersects = obb1World.m_82381_(obb2World);
        Logger.sendMessage("OBB Intersection result: " + intersects, true);
        this.manualOBBIntersectionCheck(obb1World, obb2World);
        if (!intersects) {
            Logger.sendMessage("  \u274c Failed: OBB intersection", true);
            return false;
        }
        Logger.sendMessage("  \u2705 Passed: OBB intersection", true);
        if (!this.areFacingDirectionsCompatible(data1.worldFacing, data2.worldFacing)) {
            Logger.sendMessage("  \u274c Failed: Facing directions " + data1.worldFacing + " vs " + data2.worldFacing, true);
            return false;
        }
        Logger.sendMessage("  \u2705 Passed: Facing directions " + data1.worldFacing + " vs " + data2.worldFacing, true);
        Logger.sendMessage("  \u2705 ALL CHECKS PASSED - Transfer approved!", true);
        Logger.sendMessage("=== END TRANSFER CHECK ===", true);
        return true;
    }

    private AABB transformOBBToWorld(MultiblockTransferData shipData) {
        if (!shipData.isOnShip || shipData.shipId == null) {
            return shipData.extendedOBB;
        }
        Ship ship = this.findShipById(shipData.shipId);
        if (ship == null) {
            return shipData.extendedOBB;
        }
        Vector3d min = new Vector3d(shipData.extendedOBB.f_82288_, shipData.extendedOBB.f_82289_, shipData.extendedOBB.f_82290_);
        Vector3d max = new Vector3d(shipData.extendedOBB.f_82291_, shipData.extendedOBB.f_82292_, shipData.extendedOBB.f_82293_);
        ship.getTransform().getShipToWorld().transformPosition(min);
        ship.getTransform().getShipToWorld().transformPosition(max);
        return new AABB(Math.min(min.x, max.x), Math.min(min.y, max.y), Math.min(min.z, max.z), Math.max(min.x, max.x), Math.max(min.y, max.y), Math.max(min.z, max.z));
    }

    private void manualOBBIntersectionCheck(AABB obb1, AABB obb2) {
        double gap;
        Logger.sendMessage("=== MANUAL OBB INTERSECTION CHECK ===", true);
        Logger.sendMessage("OBB1 bounds - X: " + obb1.f_82288_ + " to " + obb1.f_82291_ + ", Y: " + obb1.f_82289_ + " to " + obb1.f_82292_ + ", Z: " + obb1.f_82290_ + " to " + obb1.f_82293_, true);
        Logger.sendMessage("OBB2 bounds - X: " + obb2.f_82288_ + " to " + obb2.f_82291_ + ", Y: " + obb2.f_82289_ + " to " + obb2.f_82292_ + ", Z: " + obb2.f_82290_ + " to " + obb2.f_82293_, true);
        boolean xOverlap = obb1.f_82291_ >= obb2.f_82288_ && obb1.f_82288_ <= obb2.f_82291_;
        boolean yOverlap = obb1.f_82292_ >= obb2.f_82289_ && obb1.f_82289_ <= obb2.f_82292_;
        boolean zOverlap = obb1.f_82293_ >= obb2.f_82290_ && obb1.f_82290_ <= obb2.f_82293_;
        Logger.sendMessage("X-axis overlap: " + xOverlap, true);
        Logger.sendMessage("Y-axis overlap: " + yOverlap, true);
        Logger.sendMessage("Z-axis overlap: " + zOverlap, true);
        Logger.sendMessage("All axes overlap: " + (xOverlap && yOverlap && zOverlap), true);
        if (!xOverlap) {
            gap = Math.max(obb2.f_82288_ - obb1.f_82291_, obb1.f_82288_ - obb2.f_82291_);
            Logger.sendMessage("X-axis gap: " + gap, true);
        }
        if (!yOverlap) {
            gap = Math.max(obb2.f_82289_ - obb1.f_82292_, obb1.f_82289_ - obb2.f_82292_);
            Logger.sendMessage("Y-axis gap: " + gap, true);
        }
        if (!zOverlap) {
            gap = Math.max(obb2.f_82290_ - obb1.f_82293_, obb1.f_82290_ - obb2.f_82293_);
            Logger.sendMessage("Z-axis gap: " + gap, true);
        }
        Logger.sendMessage("=== END MANUAL CHECK ===", true);
    }

    private boolean areMultiblocksClose(MultiblockTransferData data1, MultiblockTransferData data2) {
        double maxReasonableDistance;
        double distance = data1.center.m_82554_(data2.center);
        boolean result = distance <= (maxReasonableDistance = 50.0);
        Logger.sendMessage(String.format("  Distance: %.1f, Max: %.1f, Result: %s", distance, maxReasonableDistance, result ? "CLOSE" : "FAR"), true);
        return result;
    }

    private boolean shouldTransferBasedOnLocation(MultiblockTransferData data1, MultiblockTransferData data2) {
        if (!data1.isOnShip && !data2.isOnShip) {
            Logger.sendMessage("  Both on ground - NO TRANSFER", true);
            return false;
        }
        if (data1.isOnShip && data2.isOnShip && data1.shipId != null && data1.shipId.equals(data2.shipId)) {
            Logger.sendMessage("  Both on same ship - NO TRANSFER", true);
            return false;
        }
        Logger.sendMessage("  Valid location combination", true);
        return true;
    }

    private boolean shouldTransferBasedOnMode(MultiblockTransferData data1, MultiblockTransferData data2) {
        boolean result = data1.isImportMode != data2.isImportMode;
        Logger.sendMessage(String.format("  Modes: %s vs %s, Result: %s", data1.isImportMode ? "IMPORT" : "EXPORT", data2.isImportMode ? "IMPORT" : "EXPORT", result ? "COMPATIBLE" : "INCOMPATIBLE"), true);
        return result;
    }

    private boolean areFacingDirectionsCompatible(Direction facing1, Direction facing2) {
        boolean result = facing1 == facing2.m_122424_();
        Logger.sendMessage(String.format("  Facings: %s vs %s, Result: %s", facing1, facing2, result ? "OPPOSITE" : "NOT OPPOSITE"), true);
        return result;
    }

    private void executeItemTransfer(MultiblockTransferData data1, MultiblockTransferData data2) {
        MultiblockTransferData exporter = data1.isImportMode ? data2 : data1;
        MultiblockTransferData importer = data1.isImportMode ? data1 : data2;
        float alignmentPercent = this.calculateAlignmentPercent(exporter, importer);
        int transferAmount = this.calculateTransferAmount(exporter, importer, alignmentPercent);
        Logger.sendMessage(String.format("TRANSFER: %s -> %s, Alignment: %.1f%%, Amount: %d", exporter.multiblockId, importer.multiblockId, Float.valueOf(alignmentPercent), transferAmount), true);
        if (transferAmount > 0) {
            this.performItemTransfer(exporter, importer, transferAmount);
        }
    }

    private float calculateAlignmentPercent(MultiblockTransferData exporter, MultiblockTransferData importer) {
        float alignment;
        AABB exporterAABB = this.getWorldOBB(exporter);
        AABB importerAABB = this.getWorldOBB(importer);
        Direction facing = exporter.worldFacing;
        if (facing.m_122434_().m_122479_()) {
            double importerHeight;
            double overlapY = Math.min(exporterAABB.f_82292_, importerAABB.f_82292_) - Math.max(exporterAABB.f_82289_, importerAABB.f_82289_);
            double exporterHeight = exporterAABB.m_82376_();
            double minHeight = Math.min(exporterHeight, importerHeight = importerAABB.m_82376_());
            alignment = minHeight <= 0.0 || overlapY <= 0.0 ? 0.0f : (float)Math.max(0.0, Math.min(100.0, overlapY / minHeight * 100.0));
            Logger.sendMessage(String.format("  Horizontal alignment: overlapY=%.3f, minHeight=%.3f, alignment=%.1f%%", overlapY, minHeight, Float.valueOf(alignment)), true);
        } else {
            double overlapX = Math.min(exporterAABB.f_82291_, importerAABB.f_82291_) - Math.max(exporterAABB.f_82288_, importerAABB.f_82288_);
            double overlapZ = Math.min(exporterAABB.f_82293_, importerAABB.f_82293_) - Math.max(exporterAABB.f_82290_, importerAABB.f_82290_);
            if (overlapX <= 0.0 || overlapZ <= 0.0) {
                alignment = 0.0f;
                Logger.sendMessage(String.format("  Vertical alignment: NO OVERLAP (overlapX=%.3f, overlapZ=%.3f)", overlapX, overlapZ), true);
            } else {
                double importerArea;
                double exporterArea = exporterAABB.m_82362_() * exporterAABB.m_82385_();
                double minArea = Math.min(exporterArea, importerArea = importerAABB.m_82362_() * importerAABB.m_82385_());
                if (minArea <= 0.0) {
                    alignment = 0.0f;
                } else {
                    double overlapArea = overlapX * overlapZ;
                    alignment = (float)Math.max(0.0, Math.min(100.0, overlapArea / minArea * 100.0));
                }
                Logger.sendMessage(String.format("  Vertical alignment: overlapX=%.3f, overlapZ=%.3f, overlapArea=%.3f, minArea=%.3f, alignment=%.1f%%", overlapX, overlapZ, overlapX * overlapZ, minArea, Float.valueOf(alignment)), true);
            }
        }
        return alignment;
    }

    private AABB getWorldOBB(MultiblockTransferData data) {
        if (data.isOnShip && data.shipId != null) {
            return this.transformOBBToWorld(data);
        }
        return data.extendedOBB;
    }

    private int calculateTransferAmount(MultiblockTransferData exporter, MultiblockTransferData importer, float alignmentPercent) {
        int baseTransferRate = Config.ITEM_TRANSFER_RATE;
        int blockBonus = Math.min(exporter.blockCount, importer.blockCount) * baseTransferRate;
        int actualTransfer = (int)((double)blockBonus * ((double)alignmentPercent / 100.0));
        if (alignmentPercent > 0.0f && actualTransfer < baseTransferRate) {
            actualTransfer = baseTransferRate;
        }
        int maxTransfer = baseTransferRate * 10;
        actualTransfer = Math.min(actualTransfer, maxTransfer);
        Logger.sendMessage(String.format("  Transfer calc: baseRate=%d, blockBonus=%d, aligned=%d", baseTransferRate, blockBonus, actualTransfer), true);
        return actualTransfer;
    }

    private void performItemTransfer(MultiblockTransferData exporter, MultiblockTransferData importer, int transferAmount) {
        if (exporter.chests.isEmpty() || importer.chests.isEmpty()) {
            Logger.sendMessage("  \u274c No chests available for transfer", true);
            return;
        }
        List<IItemHandler> exporterHandlers = this.getItemHandlers(exporter.chests);
        List<IItemHandler> importerHandlers = this.getItemHandlers(importer.chests);
        if (exporterHandlers.isEmpty() || importerHandlers.isEmpty()) {
            Logger.sendMessage("  \u274c No item handlers available", true);
            return;
        }
        Logger.sendMessage(String.format("  Chests: exporter=%d, importer=%d", exporterHandlers.size(), importerHandlers.size()), true);
        int remainingTransfer = transferAmount;
        int totalTransferred = 0;
        for (IItemHandler exporterHandler : exporterHandlers) {
            if (remainingTransfer <= 0) break;
            for (int slot = 0; slot < exporterHandler.getSlots() && remainingTransfer > 0; ++slot) {
                int actuallyTransferred;
                ItemStack extracted = exporterHandler.extractItem(slot, remainingTransfer, true);
                if (extracted.m_41619_()) continue;
                ItemStack remaining = extracted.m_41777_();
                for (IItemHandler importerHandler : importerHandlers) {
                    if (remaining.m_41619_()) break;
                    for (int importerSlot = 0; importerSlot < importerHandler.getSlots() && !(remaining = importerHandler.insertItem(importerSlot, remaining, false)).m_41619_(); ++importerSlot) {
                    }
                }
                if ((actuallyTransferred = extracted.m_41613_() - remaining.m_41613_()) <= 0) continue;
                exporterHandler.extractItem(slot, actuallyTransferred, false);
                remainingTransfer -= actuallyTransferred;
                totalTransferred += actuallyTransferred;
                Logger.sendMessage(String.format("  Transferred %d items", actuallyTransferred), true);
            }
        }
        Logger.sendMessage(String.format("  \u2705 Transfer complete: %d/%d items moved", totalTransferred, transferAmount), true);
    }

    private List<IItemHandler> getItemHandlers(Set<BlockPos> chestPositions) {
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        for (BlockPos pos : chestPositions) {
            IItemHandler handler;
            BlockEntity blockEntity = this.level.m_7702_(pos);
            if (blockEntity == null || (handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)) == null) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    public String recreateMultiblock(Set<BlockPos> blocks, boolean importMode, String multiblockId) {
        if (this.level.f_46443_) {
            return null;
        }
        BlockPos firstBlock = blocks.iterator().next();
        boolean isOnShip = this.isBlockOnShip(firstBlock);
        Long shipId = isOnShip ? this.getShipIdForBlock(firstBlock) : null;
        String id = multiblockId;
        this.multiblocks.put(id, new MultiblockData(id, new HashSet<BlockPos>(blocks), isOnShip, shipId));
        this.multiblockModes.put(id, importMode);
        this.multiblockChests.put(id, new HashSet());
        for (BlockPos pos : blocks) {
            this.blockToMultiblock.put(pos, id);
        }
        Logger.sendMessage("Created new multiblock " + id + " with " + blocks.size() + " blocks (on ship: " + isOnShip + ", shipId: " + shipId + ")", false);
        return id;
    }

    public String createMultiblock(Set<BlockPos> blocks, boolean importMode) {
        if (this.level.f_46443_) {
            return null;
        }
        BlockPos firstBlock = blocks.iterator().next();
        boolean isOnShip = this.isBlockOnShip(firstBlock);
        Long shipId = isOnShip ? this.getShipIdForBlock(firstBlock) : null;
        String id = UUID.randomUUID().toString();
        this.multiblocks.put(id, new MultiblockData(id, new HashSet<BlockPos>(blocks), isOnShip, shipId));
        this.multiblockModes.put(id, importMode);
        this.multiblockChests.put(id, new HashSet());
        for (BlockPos pos : blocks) {
            this.blockToMultiblock.put(pos, id);
        }
        Logger.sendMessage("Created new multiblock " + id + " with " + blocks.size() + " blocks (on ship: " + isOnShip + ", shipId: " + shipId + ")", false);
        return id;
    }

    public void removeMultiblock(String id) {
        if (this.level.f_46443_) {
            return;
        }
        MultiblockData data = this.multiblocks.remove(id);
        if (data != null) {
            for (BlockPos pos : data.blocks) {
                this.blockToMultiblock.remove(pos);
            }
        }
        this.multiblockModes.remove(id);
        Set<BlockPos> chests = this.multiblockChests.remove(id);
        if (chests != null) {
            for (BlockPos chestPos : chests) {
                Set<String> multiblockIds = this.chestToMultiblocks.get(chestPos);
                if (multiblockIds == null) continue;
                multiblockIds.remove(id);
                if (!multiblockIds.isEmpty()) continue;
                this.chestToMultiblocks.remove(chestPos);
            }
        }
        Logger.sendMessage("Removed multiblock " + id, false);
    }

    public void updateMultiblock(String id, Set<BlockPos> blocks) {
        if (this.level.f_46443_) {
            return;
        }
        MultiblockData oldData = this.multiblocks.get(id);
        if (oldData != null) {
            for (BlockPos pos : oldData.blocks) {
                this.blockToMultiblock.remove(pos);
            }
        }
        for (BlockPos pos : blocks) {
            this.blockToMultiblock.put(pos, id);
        }
        boolean isOnShip = oldData != null ? oldData.isOnShip : this.isBlockOnShip(blocks.iterator().next());
        Long shipId = oldData != null ? oldData.shipId : this.getShipIdForBlock(blocks.iterator().next());
        this.multiblocks.put(id, new MultiblockData(id, new HashSet<BlockPos>(blocks), isOnShip, shipId));
        this.sendBlockCountSync(id, blocks.size());
        Logger.sendMessage("Updated multiblock " + id + " with " + blocks.size() + " blocks (on ship: " + isOnShip + ")", false);
    }

    public String getMultiblockForBlock(BlockPos pos) {
        if (this.level.f_46443_) {
            return null;
        }
        return this.blockToMultiblock.get(pos);
    }

    public Set<BlockPos> getMultiblockBlocks(String id) {
        if (this.level.f_46443_) {
            return Collections.emptySet();
        }
        MultiblockData data = this.multiblocks.get(id);
        return data != null ? new HashSet<BlockPos>(data.blocks) : Collections.emptySet();
    }

    public int getMultiblockChestCount(String id) {
        if (this.level.f_46443_) {
            return 0;
        }
        Set<BlockPos> chests = this.multiblockChests.get(id);
        return chests != null ? chests.size() : 0;
    }

    public boolean getMultiblockMode(String multiblockId) {
        return this.multiblockModes.getOrDefault(multiblockId, true);
    }

    public void toggleMultiblockMode(String multiblockId) {
        boolean currentMode = this.multiblockModes.getOrDefault(multiblockId, true);
        boolean newMode = !currentMode;
        this.multiblockModes.put(multiblockId, newMode);
        Set<BlockPos> blocks = this.getMultiblockBlocks(multiblockId);
        for (BlockPos pos : blocks) {
            this.updateBlockEntityMode(pos, newMode);
        }
        Logger.sendMessage("Multiblock " + multiblockId + " toggled to " + (newMode ? "import" : "export") + " mode", false);
    }

    private void updateBlockEntityMode(BlockPos pos, boolean importMode) {
        BlockEntity blockEntity = this.level.m_7702_(pos);
        if (blockEntity instanceof ShipItemTransportBlockEntity) {
            ShipItemTransportBlockEntity blockEntity2 = (ShipItemTransportBlockEntity)blockEntity;
            blockEntity2.setImportMode(importMode);
            blockEntity2.m_6596_();
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7260_(pos, this.level.m_8055_(pos), this.level.m_8055_(pos), 3);
            }
        }
    }

    public void handleChestNearMultiblock(BlockPos chestPos, BlockPos multiblockPos) {
        String multiblockId = this.getMultiblockForBlock(multiblockPos);
        if (multiblockId == null) {
            Logger.sendMessage("No multiblock found for block at " + multiblockPos, false);
            return;
        }
        Logger.sendMessage("Handling chest at " + chestPos + " near multiblock " + multiblockId, false);
        BlockPos primaryChestPos = this.getOrCreateChestGroup(chestPos);
        if (this.isAnyChestInGroupConnectedToMultiblock(primaryChestPos, multiblockId) && !this.multiblockChests.get(multiblockId).contains(primaryChestPos)) {
            this.multiblockChests.get(multiblockId).add(primaryChestPos);
            this.chestToMultiblocks.computeIfAbsent(primaryChestPos, k -> new HashSet()).add(multiblockId);
            this.sendChestCountSync(multiblockId, this.multiblockChests.get(multiblockId).size());
            Logger.sendMessage("Added chest group (primary: " + primaryChestPos + ") to multiblock " + multiblockId + ". Total chests: " + this.multiblockChests.get(multiblockId).size(), false);
        }
    }

    private boolean isAnyChestInGroupConnectedToMultiblock(BlockPos primaryChestPos, String multiblockId) {
        Set<BlockPos> chestGroup = this.chestGroups.get(primaryChestPos);
        if (chestGroup == null) {
            return false;
        }
        Set<BlockPos> multiblockBlocks = this.getMultiblockBlocks(multiblockId);
        for (BlockPos chestPos : chestGroup) {
            for (BlockPos multiblockBlockPos : multiblockBlocks) {
                for (Direction dir : ChestHelper.getValidConnectionDirections(this.level, multiblockBlockPos)) {
                    if (!multiblockBlockPos.m_121945_(dir).equals((Object)chestPos)) continue;
                    Logger.sendMessage("Chest at " + chestPos + " is connected to multiblock " + multiblockId + " via block at " + multiblockBlockPos, false);
                    return true;
                }
            }
        }
        return false;
    }

    public void handlePossibleChestRemoval(BlockPos possibleChestPos) {
        if (this.chestToPrimary.containsKey(possibleChestPos)) {
            Logger.sendMessage("Possible chest removal at " + possibleChestPos, false);
            this.handleChestRemoved(possibleChestPos);
        }
    }

    private void handleChestRemoved(BlockPos chestPos) {
        BlockPos primaryPos = this.chestToPrimary.get(chestPos);
        if (primaryPos == null) {
            Logger.sendMessage("No primary chest found for removed chest at " + chestPos, false);
            return;
        }
        Set<String> connectedMultiblocks = this.chestToMultiblocks.get(primaryPos);
        if (connectedMultiblocks == null) {
            Logger.sendMessage("No multiblocks found for primary chest at " + primaryPos, false);
            this.updateChestGroupAfterBreak(chestPos);
            return;
        }
        Logger.sendMessage("Processing chest removal at " + chestPos + " from multiblocks: " + connectedMultiblocks, false);
        boolean anyConnected = false;
        for (String multiblockId : connectedMultiblocks) {
            if (!this.isAnyChestInGroupConnectedToMultiblock(primaryPos, multiblockId)) continue;
            anyConnected = true;
            break;
        }
        if (!anyConnected) {
            for (String multiblockId : connectedMultiblocks) {
                this.multiblockChests.get(multiblockId).remove(primaryPos);
                Logger.sendMessage("Removed chest group (primary: " + primaryPos + ") from multiblock " + multiblockId, false);
            }
            this.chestToMultiblocks.remove(primaryPos);
            for (String multiblockId : connectedMultiblocks) {
                this.sendChestCountSync(multiblockId, this.multiblockChests.get(multiblockId).size());
            }
        }
        this.updateChestGroupAfterBreak(chestPos);
    }

    private BlockPos getOrCreateChestGroup(BlockPos chestPos) {
        BlockPos existingPrimary = this.chestToPrimary.get(chestPos);
        if (existingPrimary != null) {
            return existingPrimary;
        }
        Set<BlockPos> connectedChests = ChestHelper.findConnectedChests(this.level, chestPos);
        BlockPos targetPrimary = null;
        for (BlockPos connectedChest : connectedChests) {
            BlockPos primaryForConnected = this.chestToPrimary.get(connectedChest);
            if (primaryForConnected == null || !this.chestGroups.containsKey(primaryForConnected)) continue;
            targetPrimary = primaryForConnected;
            break;
        }
        if (targetPrimary != null) {
            Set<BlockPos> existingGroup = this.chestGroups.get(targetPrimary);
            HashSet<BlockPos> mergedGroup = new HashSet<BlockPos>(existingGroup);
            mergedGroup.addAll(connectedChests);
            this.chestGroups.put(targetPrimary, mergedGroup);
            for (BlockPos pos : mergedGroup) {
                this.chestToPrimary.put(pos, targetPrimary);
            }
            Logger.sendMessage("MERGED chest group - Input: " + chestPos + ", Joined existing primary: " + targetPrimary + ", All members: " + mergedGroup, false);
            return targetPrimary;
        }
        BlockPos primaryPos = connectedChests.size() == 1 ? chestPos : this.determineConsistentPrimaryPosition(connectedChests);
        this.registerChestGroup(primaryPos, connectedChests);
        Logger.sendMessage("Created NEW chest group - Input: " + chestPos + ", Primary: " + primaryPos + ", All members: " + connectedChests, false);
        return primaryPos;
    }

    private BlockPos determineConsistentPrimaryPosition(Set<BlockPos> chestGroup) {
        return chestGroup.stream().min((pos1, pos2) -> {
            int xCompare = Integer.compare(pos1.m_123341_(), pos2.m_123341_());
            if (xCompare != 0) {
                return xCompare;
            }
            int zCompare = Integer.compare(pos1.m_123343_(), pos2.m_123343_());
            if (zCompare != 0) {
                return zCompare;
            }
            return Integer.compare(pos1.m_123342_(), pos2.m_123342_());
        }).orElse(chestGroup.iterator().next());
    }

    private void registerChestGroup(BlockPos primaryPos, Set<BlockPos> chestGroup) {
        this.chestGroups.put(primaryPos, chestGroup);
        for (BlockPos pos : chestGroup) {
            this.chestToPrimary.put(pos, primaryPos);
        }
    }

    private void updateChestGroupAfterBreak(BlockPos brokenChestPos) {
        BlockPos primaryPos = this.chestToPrimary.get(brokenChestPos);
        if (primaryPos == null) {
            return;
        }
        Set<BlockPos> chestGroup = this.chestGroups.get(primaryPos);
        if (chestGroup == null) {
            return;
        }
        chestGroup.remove(brokenChestPos);
        this.chestToPrimary.remove(brokenChestPos);
        if (chestGroup.isEmpty()) {
            this.chestGroups.remove(primaryPos);
            Set<String> connectedMultiblocks = this.chestToMultiblocks.remove(primaryPos);
            if (connectedMultiblocks != null) {
                for (String multiblockId : connectedMultiblocks) {
                    this.multiblockChests.get(multiblockId).remove(primaryPos);
                }
            }
        } else {
            BlockPos newPrimary = this.determineConsistentPrimaryPosition(chestGroup);
            if (!newPrimary.equals((Object)primaryPos)) {
                this.updatePrimaryChestPositionForGroup(primaryPos, newPrimary, chestGroup);
            }
            this.validateChestConnectionsForGroup(newPrimary);
        }
    }

    private void validateChestConnectionsForGroup(BlockPos primaryChestPos) {
        Set<String> connectedMultiblocks = this.chestToMultiblocks.get(primaryChestPos);
        if (connectedMultiblocks == null) {
            return;
        }
        boolean needsUpdate = false;
        HashSet<String> multiblocksToRemove = new HashSet<String>();
        for (String multiblockId : connectedMultiblocks) {
            if (this.isAnyChestInGroupConnectedToMultiblock(primaryChestPos, multiblockId)) continue;
            multiblocksToRemove.add(multiblockId);
            needsUpdate = true;
        }
        for (String multiblockId : multiblocksToRemove) {
            connectedMultiblocks.remove(multiblockId);
            this.multiblockChests.get(multiblockId).remove(primaryChestPos);
            Logger.sendMessage("Removed disconnected multiblock " + multiblockId + " from chest group " + primaryChestPos, false);
        }
        if (needsUpdate) {
            for (String multiblockId : multiblocksToRemove) {
                this.sendChestCountSync(multiblockId, this.multiblockChests.get(multiblockId).size());
            }
        }
    }

    private void updatePrimaryChestPositionForGroup(BlockPos oldPrimary, BlockPos newPrimary, Set<BlockPos> chestGroup) {
        Set<String> multiblockIds = this.chestToMultiblocks.get(oldPrimary);
        if (multiblockIds != null) {
            for (String multiblockId : multiblockIds) {
                this.multiblockChests.get(multiblockId).remove(oldPrimary);
                this.multiblockChests.get(multiblockId).add(newPrimary);
            }
            this.chestToMultiblocks.remove(oldPrimary);
            this.chestToMultiblocks.put(newPrimary, multiblockIds);
        }
        this.chestGroups.remove(oldPrimary);
        this.registerChestGroup(newPrimary, chestGroup);
        Logger.sendMessage("Updated primary chest from " + oldPrimary + " to " + newPrimary + " for group: " + chestGroup, false);
    }

    private void validateChestConnectionsAfterBlockRemoval(String multiblockId) {
        HashSet chestsToCheck = new HashSet(this.multiblockChests.get(multiblockId));
        boolean needsUpdate = false;
        for (BlockPos primaryChestPos : chestsToCheck) {
            if (this.isAnyChestInGroupConnectedToMultiblock(primaryChestPos, multiblockId)) continue;
            this.multiblockChests.get(multiblockId).remove(primaryChestPos);
            Set<String> multiblockIds = this.chestToMultiblocks.get(primaryChestPos);
            if (multiblockIds != null) {
                multiblockIds.remove(multiblockId);
                if (multiblockIds.isEmpty()) {
                    this.chestToMultiblocks.remove(primaryChestPos);
                }
            }
            needsUpdate = true;
            Logger.sendMessage("Removed disconnected chest group (primary: " + primaryChestPos + ") from multiblock " + multiblockId, false);
        }
        if (needsUpdate) {
            this.sendChestCountSync(multiblockId, this.multiblockChests.get(multiblockId).size());
        }
    }

    public void onBlockPlaced(BlockPos newPos) {
        if (this.level.f_46443_) {
            return;
        }
        Logger.sendMessage("Processing block placement at " + newPos, true);
        if (this.blockToMultiblock.containsKey(newPos)) {
            Logger.sendMessage("WARNING: Block at " + newPos + " already in multiblock " + this.blockToMultiblock.get(newPos), true);
            return;
        }
        Set<String> adjacentMultiblocks = this.findAdjacentMultiblocks(newPos);
        if (adjacentMultiblocks.isEmpty()) {
            this.createSingleBlockMultiblock(newPos);
        } else if (adjacentMultiblocks.size() == 1) {
            String targetId = adjacentMultiblocks.iterator().next();
            this.joinMultiblock(newPos, targetId);
        } else {
            this.mergeMultiblocks(newPos, adjacentMultiblocks);
        }
    }

    private void createSingleBlockMultiblock(BlockPos pos) {
        Set<BlockPos> singleBlock = Collections.singleton(pos);
        boolean isOnShip = this.isBlockOnShip(pos);
        Long shipId = isOnShip ? this.getShipIdForBlock(pos) : null;
        String newId = this.createMultiblock(singleBlock, true, isOnShip, shipId);
        this.updateBlockEntity(pos, newId, singleBlock);
        Logger.sendMessage("Created single-block multiblock " + newId + " at " + pos + " (on ship: " + isOnShip + ")", false);
    }

    private void joinMultiblock(BlockPos newPos, String targetId) {
        MultiblockData targetData = this.multiblocks.get(targetId);
        if (targetData == null) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>(targetData.blocks);
        blocks.add(newPos);
        this.updateMultiblock(targetId, blocks, targetData.isOnShip, targetData.shipId);
        this.updateBlockEntity(newPos, targetId, blocks);
        Logger.sendMessage("Added block at " + newPos + " to multiblock " + targetId + " (inherited ship status: " + targetData.isOnShip + ")", false);
    }

    private void mergeMultiblocks(BlockPos newPos, Set<String> multiblockIds) {
        Direction requiredFacing = (Direction)this.level.m_8055_(newPos).m_61143_((Property)ShipItemTransportBlock.FACING);
        for (String id : multiblockIds) {
            BlockPos samplePos;
            Direction sampleFacing;
            Set<BlockPos> blocks = this.getMultiblockBlocks(id);
            if (blocks.isEmpty() || (sampleFacing = (Direction)this.level.m_8055_(samplePos = blocks.iterator().next()).m_61143_((Property)ShipItemTransportBlock.FACING)) == requiredFacing) continue;
            Logger.sendMessage("Cannot merge multiblocks with different facing directions", false);
            return;
        }
        String mainId = multiblockIds.iterator().next();
        MultiblockData mainData = this.multiblocks.get(mainId);
        HashSet<BlockPos> allMergedBlocks = new HashSet<BlockPos>(this.getMultiblockBlocks(mainId));
        allMergedBlocks.add(newPos);
        boolean mergedIsOnShip = mainData.isOnShip;
        Long mergedShipId = mainData.shipId;
        for (String id : multiblockIds) {
            MultiblockData data = this.multiblocks.get(id);
            if (data == null || !data.isOnShip) continue;
            mergedIsOnShip = true;
            mergedShipId = data.shipId;
            break;
        }
        HashSet<BlockPos> allPrimaryChests = new HashSet<BlockPos>();
        for (String id : multiblockIds) {
            Set<BlockPos> chests = this.multiblockChests.get(id);
            if (chests == null) continue;
            allPrimaryChests.addAll(chests);
        }
        for (String id : multiblockIds) {
            if (id.equals(mainId)) continue;
            allMergedBlocks.addAll(this.getMultiblockBlocks(id));
            this.removeMultiblock(id);
        }
        this.updateMultiblock(mainId, allMergedBlocks, mergedIsOnShip, mergedShipId);
        for (BlockPos primaryChestPos : allPrimaryChests) {
            if (this.multiblockChests.get(mainId).contains(primaryChestPos)) continue;
            this.multiblockChests.get(mainId).add(primaryChestPos);
            this.chestToMultiblocks.computeIfAbsent(primaryChestPos, k -> new HashSet()).add(mainId);
        }
        for (BlockPos pos : allMergedBlocks) {
            this.updateBlockEntity(pos, mainId, allMergedBlocks);
        }
        this.sendBlockCountSyncToAllMergedViewers(multiblockIds, mainId, allMergedBlocks.size());
        Logger.sendMessage("Merged " + multiblockIds.size() + " multiblocks into " + mainId + " with " + allMergedBlocks.size() + " blocks (on ship: " + mergedIsOnShip + ", shipId: " + mergedShipId + ")", false);
    }

    private void updateMultiblock(String id, Set<BlockPos> blocks, boolean isOnShip, Long shipId) {
        if (this.level.f_46443_) {
            return;
        }
        MultiblockData oldData = this.multiblocks.get(id);
        if (oldData != null) {
            for (BlockPos pos : oldData.blocks) {
                this.blockToMultiblock.remove(pos);
            }
        }
        for (BlockPos pos : blocks) {
            this.blockToMultiblock.put(pos, id);
        }
        this.multiblocks.put(id, new MultiblockData(id, new HashSet<BlockPos>(blocks), isOnShip, shipId));
        this.sendBlockCountSync(id, blocks.size());
        Logger.sendMessage("Updated multiblock " + id + " with " + blocks.size() + " blocks (on ship: " + isOnShip + ", shipId: " + shipId + ")", false);
    }

    public void onBlockRemoved(BlockPos removedPos) {
        if (this.level.f_46443_) {
            return;
        }
        String multiblockId = this.blockToMultiblock.get(removedPos);
        if (multiblockId == null) {
            return;
        }
        Logger.sendMessage("Processing block removal at " + removedPos + " from multiblock " + multiblockId, false);
        this.blockToMultiblock.remove(removedPos);
        Set<BlockPos> remainingBlocks = this.getMultiblockBlocks(multiblockId);
        remainingBlocks.remove(removedPos);
        if (remainingBlocks.isEmpty()) {
            this.removeMultiblock(multiblockId);
        } else {
            List<Set<BlockPos>> connectedComponents = this.findConnectedComponents(remainingBlocks);
            if (connectedComponents.size() == 1) {
                MultiblockData oldData = this.multiblocks.get(multiblockId);
                this.updateMultiblock(multiblockId, remainingBlocks, oldData.isOnShip, oldData.shipId);
                this.validateChestConnectionsAfterBlockRemoval(multiblockId);
            } else {
                MultiblockData originalData = this.multiblocks.get(multiblockId);
                boolean originalMode = this.getMultiblockMode(multiblockId);
                boolean originalIsOnShip = originalData.isOnShip;
                Long originalShipId = originalData.shipId;
                this.removeMultiblock(multiblockId);
                for (Set<BlockPos> component : connectedComponents) {
                    if (component.isEmpty()) continue;
                    String newMultiblockId = this.createMultiblock(component, originalMode, originalIsOnShip, originalShipId);
                    for (BlockPos pos : component) {
                        this.updateBlockEntity(pos, newMultiblockId, component);
                        this.sendBlockCountSyncToViewers(pos, component.size());
                    }
                }
                Logger.sendMessage("Split multiblock into " + connectedComponents.size() + " components (preserved ship status: " + originalIsOnShip + ")", false);
            }
        }
    }

    private Set<String> findAdjacentMultiblocks(BlockPos pos) {
        if (this.level.f_46443_) {
            return Collections.emptySet();
        }
        HashSet<String> multiblocks = new HashSet<String>();
        for (Direction dir : Direction.values()) {
            String multiblockId;
            BlockPos neighborPos = pos.m_121945_(dir);
            if (!this.canConnect(pos, neighborPos, this.level) || (multiblockId = this.blockToMultiblock.get(neighborPos)) == null || !this.isValidBlock(neighborPos)) continue;
            multiblocks.add(multiblockId);
        }
        return multiblocks;
    }

    private boolean canConnect(BlockPos pos1, BlockPos pos2, Level level) {
        Direction facing2;
        BlockState state1 = level.m_8055_(pos1);
        BlockState state2 = level.m_8055_(pos2);
        if (!(state1.m_60734_() instanceof ShipItemTransportBlock) || !(state2.m_60734_() instanceof ShipItemTransportBlock)) {
            return false;
        }
        Direction facing1 = (Direction)state1.m_61143_((Property)ShipItemTransportBlock.FACING);
        if (facing1 != (facing2 = (Direction)state2.m_61143_((Property)ShipItemTransportBlock.FACING))) {
            return false;
        }
        return this.areOnSamePlane(pos1, pos2, facing1);
    }

    private boolean areOnSamePlane(BlockPos pos1, BlockPos pos2, Direction facing) {
        switch (facing) {
            case UP: 
            case DOWN: {
                return pos1.m_123342_() == pos2.m_123342_();
            }
            case NORTH: 
            case SOUTH: {
                return pos1.m_123343_() == pos2.m_123343_();
            }
            case EAST: 
            case WEST: {
                return pos1.m_123341_() == pos2.m_123341_();
            }
        }
        return false;
    }

    private List<Set<BlockPos>> findConnectedComponents(Set<BlockPos> blocks) {
        ArrayList<Set<BlockPos>> components = new ArrayList<Set<BlockPos>>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (BlockPos start : blocks) {
            if (visited.contains(start)) continue;
            HashSet<BlockPos> component = new HashSet<BlockPos>();
            this.floodFill(start, blocks, component, visited);
            components.add(component);
        }
        return components;
    }

    private void floodFill(BlockPos start, Set<BlockPos> allBlocks, Set<BlockPos> component, Set<BlockPos> visited) {
        Stack<BlockPos> stack = new Stack<BlockPos>();
        stack.push(start);
        while (!stack.isEmpty()) {
            BlockPos current = (BlockPos)stack.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            component.add(current);
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.m_121945_(dir);
                if (!allBlocks.contains(neighbor) || visited.contains(neighbor) || !this.canConnect(current, neighbor, this.level)) continue;
                stack.push(neighbor);
            }
        }
    }

    private void updateBlockEntity(BlockPos pos, String multiblockId, Set<BlockPos> blocks) {
        BlockEntity blockEntity = this.level.m_7702_(pos);
        if (blockEntity instanceof ShipItemTransportBlockEntity) {
            ShipItemTransportBlockEntity blockEntity2 = (ShipItemTransportBlockEntity)blockEntity;
            blockEntity2.setMultiblock(multiblockId, blocks);
            blockEntity2.m_6596_();
            if (this.level instanceof ServerLevel) {
                this.level.m_7260_(pos, this.level.m_8055_(pos), this.level.m_8055_(pos), 3);
            }
        }
    }

    private boolean isValidBlock(BlockPos pos) {
        return this.level.m_46749_(pos) && this.level.m_8055_(pos).m_60734_() instanceof ShipItemTransportBlock && this.level.m_7702_(pos) instanceof ShipItemTransportBlockEntity;
    }

    private void sendBlockCountSyncToAllMergedViewers(Set<String> mergedMultiblockIds, String newMultiblockId, int newBlockCount) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockCountSyncPacket syncPacket = new BlockCountSyncPacket(newBlockCount);
            for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                String viewedMultiblockId;
                ShipItemTransportMenu menu;
                AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
                if (!(abstractContainerMenu instanceof ShipItemTransportMenu) || (menu = (ShipItemTransportMenu)abstractContainerMenu).getBlockEntity() == null || !mergedMultiblockIds.contains(viewedMultiblockId = menu.getBlockEntity().getMultiblockId()) && !newMultiblockId.equals(viewedMultiblockId)) continue;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)syncPacket);
            }
        }
    }

    private void sendBlockCountSyncToViewers(BlockPos blockPos, int blockCount) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockCountSyncPacket syncPacket = new BlockCountSyncPacket(blockCount);
            for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                ShipItemTransportMenu menu;
                AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
                if (!(abstractContainerMenu instanceof ShipItemTransportMenu) || (menu = (ShipItemTransportMenu)abstractContainerMenu).getBlockEntity() == null || !menu.getBlockEntity().m_58899_().equals((Object)blockPos)) continue;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)syncPacket);
            }
        }
    }

    private void sendBlockCountSync(String multiblockId, int blockCount) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockCountSyncPacket syncPacket = new BlockCountSyncPacket(blockCount);
            for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                String viewedMultiblockId;
                ShipItemTransportMenu menu;
                AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
                if (!(abstractContainerMenu instanceof ShipItemTransportMenu) || (menu = (ShipItemTransportMenu)abstractContainerMenu).getBlockEntity() == null || !multiblockId.equals(viewedMultiblockId = menu.getBlockEntity().getMultiblockId())) continue;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)syncPacket);
            }
        }
    }

    private void sendChestCountSync(String multiblockId, int chestCount) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChestCountSyncPacket syncPacket = new ChestCountSyncPacket(chestCount);
            for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                String viewedMultiblockId;
                ShipItemTransportMenu menu;
                AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
                if (!(abstractContainerMenu instanceof ShipItemTransportMenu) || (menu = (ShipItemTransportMenu)abstractContainerMenu).getBlockEntity() == null || !multiblockId.equals(viewedMultiblockId = menu.getBlockEntity().getMultiblockId())) continue;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)syncPacket);
            }
        }
    }

    private void sendShipInfoSync(String multiblockId, boolean isOnShip, long shipId) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShipInfoSyncPacket syncPacket = new ShipInfoSyncPacket(isOnShip, shipId);
            for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                String viewedMultiblockId;
                ShipItemTransportMenu menu;
                AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
                if (!(abstractContainerMenu instanceof ShipItemTransportMenu) || (menu = (ShipItemTransportMenu)abstractContainerMenu).getBlockEntity() == null || !multiblockId.equals(viewedMultiblockId = menu.getBlockEntity().getMultiblockId())) continue;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)syncPacket);
            }
        }
    }

    public void sendInitialShipInfoSync(ServerPlayer player, String multiblockId) {
        if (this.level.f_46443_) {
            return;
        }
        MultiblockData data = this.multiblocks.get(multiblockId);
        if (data != null) {
            long shipId = data.shipId != null ? data.shipId : -1L;
            ShipInfoSyncPacket syncPacket = new ShipInfoSyncPacket(data.isOnShip, shipId);
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)syncPacket);
        }
    }

    private String createMultiblock(Set<BlockPos> blocks, boolean importMode, boolean isOnShip, Long shipId) {
        if (this.level.f_46443_) {
            return null;
        }
        String id = UUID.randomUUID().toString();
        this.multiblocks.put(id, new MultiblockData(id, new HashSet<BlockPos>(blocks), isOnShip, shipId));
        this.multiblockModes.put(id, importMode);
        this.multiblockChests.put(id, new HashSet());
        for (BlockPos pos : blocks) {
            this.blockToMultiblock.put(pos, id);
        }
        Logger.sendMessage("Created new multiblock " + id + " with " + blocks.size() + " blocks (on ship: " + isOnShip + ", shipId: " + shipId + ")", false);
        return id;
    }

    private Ship findShipForBlock(BlockPos worldPos) {
        if (this.level.f_46443_) {
            return null;
        }
        ShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((Level)this.level);
        if (shipWorld == null) {
            return null;
        }
        for (Ship ship : shipWorld.getLoadedShips()) {
            AABBic shipAABB = ship.getShipAABB();
            if (shipAABB == null || worldPos.m_123341_() < shipAABB.minX() || worldPos.m_123341_() > shipAABB.maxX() || worldPos.m_123342_() < shipAABB.minY() || worldPos.m_123342_() > shipAABB.maxY() || worldPos.m_123343_() < shipAABB.minZ() || worldPos.m_123343_() > shipAABB.maxZ()) continue;
            return ship;
        }
        return null;
    }

    private boolean isBlockOnShip(BlockPos worldPos) {
        return this.findShipForBlock(worldPos) != null;
    }

    private Long getShipIdForBlock(BlockPos worldPos) {
        Ship ship = this.findShipForBlock(worldPos);
        return ship != null ? Long.valueOf(ship.getId()) : null;
    }

    public boolean isMultiblockOnShip(String multiblockId) {
        if (this.level.f_46443_) {
            return false;
        }
        MultiblockData data = this.multiblocks.get(multiblockId);
        return data != null && data.isOnShip;
    }

    public Long getMultiblockShipId(String multiblockId) {
        if (this.level.f_46443_) {
            return null;
        }
        MultiblockData data = this.multiblocks.get(multiblockId);
        return data.shipId != null ? data.shipId : -1L;
    }

    public String getMultiblockShipInfo(String multiblockId) {
        Ship ship;
        if (this.level.f_46443_) {
            return "Ground";
        }
        MultiblockData data = this.multiblocks.get(multiblockId);
        if (data == null || !data.isOnShip || data.shipId == null) {
            return "Ground";
        }
        ShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((Level)this.level);
        if (shipWorld != null && (ship = shipWorld.getAllShips().getById(data.shipId.longValue())) != null) {
            return "Ship " + data.shipId;
        }
        return "Ship " + data.shipId;
    }

    private static class MultiblockTransferData {
        public final String multiblockId;
        public final Set<BlockPos> blocks;
        public final boolean isOnShip;
        public final Long shipId;
        public final Direction worldFacing;
        public final AABB extendedOBB;
        public final boolean isImportMode;
        public final int blockCount;
        public final Set<BlockPos> chests;
        public final Vec3 center;

        public MultiblockTransferData(String multiblockId, Set<BlockPos> blocks, boolean isOnShip, Long shipId, Direction worldFacing, AABB extendedOBB, boolean isImportMode, int blockCount, Set<BlockPos> chests, Vec3 center) {
            this.multiblockId = multiblockId;
            this.blocks = blocks;
            this.isOnShip = isOnShip;
            this.shipId = shipId;
            this.worldFacing = worldFacing;
            this.extendedOBB = extendedOBB;
            this.isImportMode = isImportMode;
            this.blockCount = blockCount;
            this.chests = chests;
            this.center = center;
        }
    }

    private static class MultiblockData {
        public final String id;
        public final Set<BlockPos> blocks;
        public final boolean isOnShip;
        public final Long shipId;

        public MultiblockData(String id, Set<BlockPos> blocks, boolean isOnShip, Long shipId) {
            this.id = id;
            this.blocks = blocks;
            this.isOnShip = isOnShip;
            this.shipId = shipId;
        }
    }
}

