/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import shipItemTransport.code.ChestHelper;
import shipItemTransport.code.Logger;
import shipItemTransport.code.ModBlockEntities;
import shipItemTransport.code.MultiblockManager;
import shipItemTransport.code.ShipItemTransportBlockEntity;
import shipItemTransport.code.ShipItemTransportMod;

public class ShipItemTransportBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty FORMED = BooleanProperty.m_61465_((String)"formed");

    public ShipItemTransportBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60955_().m_60913_(3.0f, 6.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)FORMED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return player.m_36298_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FORMED});
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        return Collections.singletonList(new ItemStack((ItemLike)ShipItemTransportMod.SHIP_ITEM_TRANSPORTER_ITEM.get()));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        Logger.sendMessage("Block placed at " + pos + " - processing immediately 1", true);
        if (!level.f_46443_ && level.m_46749_(pos)) {
            Logger.sendMessage("Block placed at " + pos + " - processing immediately 2", true);
            MultiblockManager manager = MultiblockManager.get(level);
            if (manager != null) {
                manager.onBlockPlaced(pos);
                this.scanForNearbyChests(level, pos, manager);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && level.m_46749_(pos) && state.m_60734_() != newState.m_60734_()) {
            Logger.sendMessage("Block at " + pos + " is being removed", false);
            MultiblockManager manager = MultiblockManager.get(level);
            if (manager != null) {
                manager.onBlockRemoved(pos);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        MultiblockManager manager;
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, isMoving);
        if (!level.f_46443_ && (manager = MultiblockManager.get(level)) != null) {
            if (ChestHelper.isChest(level, neighborPos)) {
                Logger.sendMessage("Chest detected at " + neighborPos + " near multiblock block at " + pos, false);
                manager.handleChestNearMultiblock(neighborPos, pos);
            } else {
                manager.handlePossibleChestRemoval(neighborPos);
            }
        }
    }

    private void scanForNearbyChests(Level level, BlockPos blockPos, MultiblockManager manager) {
        for (Direction dir : this.getValidConnectionDirections(level, blockPos)) {
            BlockPos checkPos = blockPos.m_121945_(dir);
            if (!ChestHelper.isChest(level, checkPos)) continue;
            Logger.sendMessage("Found existing chest at " + checkPos + " during block placement", false);
            manager.handleChestNearMultiblock(checkPos, blockPos);
        }
    }

    private Direction[] getValidConnectionDirections(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return (Direction[])Arrays.stream(Direction.values()).filter(dir -> dir != facing).toArray(Direction[]::new);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ShipItemTransportBlockEntity) {
            ShipItemTransportBlockEntity transportBlockEntity = (ShipItemTransportBlockEntity)blockEntity;
            transportBlockEntity.openMenu((ServerPlayer)player);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShipItemTransportBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ShipItemTransportBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.SHIP_ITEM_TRANSPORTER.get()), ShipItemTransportBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

