/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import shipItemTransport.code.ChestHelper;
import shipItemTransport.code.Logger;
import shipItemTransport.code.ModBlockEntities;
import shipItemTransport.code.MultiblockManager;
import shipItemTransport.code.ShipItemTransportBlock;
import shipItemTransport.code.ShipItemTransportMenu;

public class ShipItemTransportBlockEntity
extends BlockEntity
implements MenuProvider {
    private String multiblockId = null;
    boolean needsRegistration = true;
    private String oldMultiblockId = null;
    private boolean importMode = true;

    public ShipItemTransportBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SHIP_ITEM_TRANSPORTER.get(), pos, state);
    }

    public boolean isImportMode() {
        MultiblockManager manager;
        if (this.multiblockId != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && (manager = MultiblockManager.get(this.f_58857_)) != null) {
            return manager.getMultiblockMode(this.multiblockId);
        }
        return this.importMode;
    }

    public void setImportMode(boolean importMode) {
        this.importMode = importMode;
        this.m_6596_();
    }

    public void setMultiblock(String id, Set<BlockPos> members) {
        this.multiblockId = id;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean shouldBeFormed;
            BlockState currentState = this.f_58857_.m_8055_(this.m_58899_());
            boolean bl = shouldBeFormed = id != null && members.size() > 1;
            if ((Boolean)currentState.m_61143_((Property)ShipItemTransportBlock.FORMED) != shouldBeFormed) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)currentState.m_61124_((Property)ShipItemTransportBlock.FORMED, (Comparable)Boolean.valueOf(shouldBeFormed)), 3);
            }
        }
        Logger.sendMessage("Block at " + this.m_58899_() + " set to multiblock " + id + " with " + members.size() + " blocks", false);
    }

    public String getMultiblockId() {
        return this.multiblockId;
    }

    public int getMultiblockSize() {
        MultiblockManager manager;
        if (this.multiblockId != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && (manager = MultiblockManager.get(this.f_58857_)) != null) {
            return manager.getMultiblockBlocks(this.multiblockId).size();
        }
        return 1;
    }

    public int getChestCount() {
        MultiblockManager manager;
        if (this.multiblockId != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && (manager = MultiblockManager.get(this.f_58857_)) != null) {
            return manager.getMultiblockChestCount(this.multiblockId);
        }
        return 0;
    }

    public boolean isOnShip() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.multiblockId == null) {
            return false;
        }
        MultiblockManager manager = MultiblockManager.get(this.f_58857_);
        return manager != null && manager.isMultiblockOnShip(this.multiblockId);
    }

    public String getShipConnectionInfo() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.multiblockId == null) {
            return "Ground";
        }
        MultiblockManager manager = MultiblockManager.get(this.f_58857_);
        return manager != null ? manager.getMultiblockShipInfo(this.multiblockId) : "Ground";
    }

    public void toggleMode() {
        MultiblockManager manager;
        if (this.multiblockId != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && (manager = MultiblockManager.get(this.f_58857_)) != null) {
            manager.toggleMultiblockMode(this.multiblockId);
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        Logger.sendMessage("saving additional data for block entity: multiblock id == " + this.multiblockId, true);
        super.m_183515_(tag);
        if (this.multiblockId != null) {
            tag.m_128359_("MultiblockId", this.multiblockId);
        }
        tag.m_128379_("ImportMode", this.importMode);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        Logger.sendMessage("Loaded block at " + this.m_58899_(), true);
        if (tag.m_128441_("ImportMode")) {
            this.importMode = tag.m_128471_("ImportMode");
        }
        if (tag.m_128441_("MultiblockId")) {
            this.multiblockId = tag.m_128461_("MultiblockId");
            Logger.sendMessage("Loaded block at " + this.m_58899_() + " belonging to multiblock " + this.multiblockId + " with mode: " + (this.importMode ? "IMPORT" : "EXPORT"), true);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ShipItemTransportBlockEntity blockEntity) {
        if (blockEntity.needsRegistration) {
            blockEntity.registerWithMultiblock();
            blockEntity.needsRegistration = false;
        }
    }

    private void registerWithMultiblock() {
        while (this.f_58857_ == null) {
            try {
                Thread.sleep(300L);
                Logger.sendMessage("Waiting for block entity Level to load", true);
            }
            catch (InterruptedException e) {
                Logger.sendMessage("Interrupted while sleeping block entity", true);
            }
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        MultiblockManager manager = MultiblockManager.get(this.f_58857_);
        if (manager == null) {
            return;
        }
        Logger.sendMessage("Block at " + this.m_58899_() + " registering with multiblock " + this.multiblockId, false);
        Set<BlockPos> existingBlocks = manager.getMultiblockBlocks(this.multiblockId);
        if (existingBlocks.isEmpty()) {
            HashSet<BlockPos> newBlocks = new HashSet<BlockPos>();
            newBlocks.add(this.m_58899_());
            manager.recreateMultiblock(newBlocks, this.importMode, this.multiblockId);
            Logger.sendMessage("Created new multiblock " + this.multiblockId + " with block at " + this.m_58899_(), false);
        } else {
            HashSet<BlockPos> updatedBlocks = new HashSet<BlockPos>(existingBlocks);
            updatedBlocks.add(this.m_58899_());
            manager.updateMultiblock(this.multiblockId, updatedBlocks);
            Logger.sendMessage("Added block at " + this.m_58899_() + " to existing multiblock " + this.multiblockId, false);
        }
        Set<BlockPos> currentMembers = manager.getMultiblockBlocks(this.multiblockId);
        this.setMultiblock(this.multiblockId, currentMembers);
        this.scanForChests();
    }

    private void scanForChests() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.multiblockId == null) {
            return;
        }
        MultiblockManager manager = MultiblockManager.get(this.f_58857_);
        if (manager == null) {
            return;
        }
        for (Direction dir : ChestHelper.getValidConnectionDirections(this.f_58857_, this.m_58899_())) {
            BlockPos checkPos = this.m_58899_().m_121945_(dir);
            if (!ChestHelper.isChest(this.f_58857_, checkPos)) continue;
            manager.handleChestNearMultiblock(checkPos, this.m_58899_());
        }
    }

    public void m_7651_() {
        MultiblockManager manager;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.multiblockId != null && this.f_58857_.m_46749_(this.f_58858_) && !this.f_58857_.m_8055_(this.f_58858_).m_60713_(this.m_58900_().m_60734_()) && (manager = MultiblockManager.get(this.f_58857_)) != null) {
            manager.onBlockRemoved(this.m_58899_());
        }
        super.m_7651_();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.ship_item_transport_mod.ship_item_transporter");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new ShipItemTransportMenu(containerId, playerInventory, this, this.isImportMode(), this.getMultiblockSize(), this.getChestCount(), this.isOnShip(), MultiblockManager.get(this.f_58857_).getMultiblockShipId(this.multiblockId));
    }

    public void markForClientUpdate() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public void openMenu(ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this, buf -> {
            buf.m_130064_(this.m_58899_());
            buf.writeBoolean(this.isImportMode());
            buf.writeInt(this.getMultiblockSize());
            buf.writeInt(this.getChestCount());
            buf.writeBoolean(this.isOnShip());
            long shipId = MultiblockManager.get(this.f_58857_).getMultiblockShipId(this.multiblockId);
            buf.writeLong(shipId);
        });
    }
}

