/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import shipItemTransport.code.Logger;
import shipItemTransport.code.ModMenuTypes;
import shipItemTransport.code.MultiblockManager;
import shipItemTransport.code.ShipItemTransportBlockEntity;
import shipItemTransport.code.ShipItemTransportMod;

public class ShipItemTransportMenu
extends AbstractContainerMenu {
    public final ShipItemTransportBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private boolean currentMode;
    private int currentBlockCount;
    private int currentChestCount;
    private boolean currentIsOnShip;
    private long currentShipId;

    public ShipItemTransportMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), extraData.readBoolean(), extraData.readInt(), extraData.readInt(), extraData.readBoolean(), extraData.readLong());
    }

    public ShipItemTransportMenu(int containerId, Inventory inv, BlockEntity blockEntity, boolean currentMode, int currentBlockCount, int currentChestCount, boolean currentIsOnShip, long currentShipId) {
        super((MenuType)ModMenuTypes.SHIP_ITEM_TRANSPORTER_MENU.get(), containerId);
        this.blockEntity = blockEntity instanceof ShipItemTransportBlockEntity ? (ShipItemTransportBlockEntity)blockEntity : null;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)inv.f_35978_.m_9236_(), (BlockPos)(blockEntity != null ? blockEntity.m_58899_() : BlockPos.f_121853_));
        this.currentMode = currentMode;
        this.currentBlockCount = currentBlockCount;
        this.currentChestCount = currentChestCount;
        this.currentIsOnShip = currentIsOnShip;
        this.currentShipId = currentShipId;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null) {
            return false;
        }
        return ShipItemTransportMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)ShipItemTransportMod.SHIP_ITEM_TRANSPORTER.get()));
    }

    public ShipItemTransportBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getMultiblockSize() {
        return this.currentBlockCount;
    }

    public int getChestCount() {
        return this.currentChestCount;
    }

    public boolean isImportMode() {
        return this.currentMode;
    }

    public String getShipConnectionInfo() {
        if (this.currentIsOnShip && this.currentShipId != -1L) {
            return "Ship " + this.currentShipId;
        }
        return "Ground";
    }

    public boolean isOnShip() {
        return this.currentIsOnShip;
    }

    public long getShipId() {
        return this.currentShipId;
    }

    public void setCurrentMode(boolean mode) {
        this.currentMode = mode;
    }

    public void setCurrentBlockCount(int blockCount) {
        this.currentBlockCount = blockCount;
    }

    public void setCurrentChestCount(int chestCount) {
        this.currentChestCount = chestCount;
    }

    public void setShipInfo(boolean isOnShip, long shipId) {
        this.currentIsOnShip = isOnShip;
        this.currentShipId = shipId;
    }

    public void toggleMode() {
        if (this.blockEntity.m_58904_().f_46443_) {
            Logger.sendMessage("in method toggling mode on client", true);
        } else {
            Logger.sendMessage("in method toggling mode on server", true);
        }
        if (this.blockEntity != null && this.blockEntity.getMultiblockId() != null && this.blockEntity.m_58904_() != null) {
            MultiblockManager manager = MultiblockManager.get(this.blockEntity.m_58904_());
            if (manager != null) {
                manager.toggleMultiblockMode(this.blockEntity.getMultiblockId());
                if (this.blockEntity.m_58904_().f_46443_) {
                    Logger.sendMessage("toggling mode on client", true);
                } else {
                    Logger.sendMessage("toggling mode on server", true);
                }
            }
        } else if (this.blockEntity != null) {
            this.blockEntity.toggleMode();
        }
    }
}

