/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import shipItemTransport.code.Logger;
import shipItemTransport.code.NetworkHandler;
import shipItemTransport.code.ShipItemTransportMenu;
import shipItemTransport.code.ToggleModePacket;

public class ShipItemTransportScreen
extends AbstractContainerScreen<ShipItemTransportMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ship_item_transport_mod", "textures/gui/ship_item_transporter_gui.png");
    private Button modeButton;
    private boolean currentImportMode;
    private int currentBlockCount;
    private int currentChestCount;
    private String currentShipInfo;

    public ShipItemTransportScreen(ShipItemTransportMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 140;
        this.f_97731_ = 100000;
        this.currentImportMode = menu.isImportMode();
        this.currentBlockCount = menu.getMultiblockSize();
        this.currentChestCount = menu.getChestCount();
        this.currentShipInfo = menu.getShipConnectionInfo();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.modeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getModeButtonText(), button -> {
            if (((ShipItemTransportMenu)this.f_97732_).getBlockEntity() != null && this.f_96541_ != null) {
                BlockPos pos = ((ShipItemTransportMenu)this.f_97732_).getBlockEntity().m_58899_();
                if (((ShipItemTransportMenu)this.f_97732_).blockEntity.m_58904_().f_46443_) {
                    Logger.sendMessage("in method init  on client", true);
                } else {
                    Logger.sendMessage("in method init  on server", true);
                }
                NetworkHandler.INSTANCE.sendToServer((Object)new ToggleModePacket(pos));
            }
        }).m_252987_(this.f_97735_ + 60, this.f_97736_ + 90, 56, 20).m_253136_());
    }

    private Component getModeButtonText() {
        return Component.m_237115_((String)(this.currentImportMode ? "gui.ship_item_transport.import" : "gui.ship_item_transport.export"));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.currentShipInfo = ((ShipItemTransportMenu)this.f_97732_).getShipConnectionInfo();
        guiGraphics.m_280056_(this.f_96547_, "Connected Blocks: " + this.currentBlockCount, this.f_97735_ + 8, this.f_97736_ + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Connected Chests: " + this.currentChestCount, this.f_97735_ + 8, this.f_97736_ + 35, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Mode: " + (this.currentImportMode ? "Import" : "Export"), this.f_97735_ + 8, this.f_97736_ + 50, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Connected to: " + this.currentShipInfo, this.f_97735_ + 8, this.f_97736_ + 65, 0x404040, false);
        if (this.currentShipInfo.equals("Ground")) {
            guiGraphics.m_280056_(this.f_96547_, "Status: Ready for ship transfer", this.f_97735_ + 8, this.f_97736_ + 80, 0x404040, false);
        } else {
            guiGraphics.m_280056_(this.f_96547_, "Status: Ship transport active", this.f_97735_ + 8, this.f_97736_ + 80, 0x404040, false);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
    }

    public void updateModeFromServer(boolean serverImportMode) {
        this.currentImportMode = serverImportMode;
        if (this.modeButton != null) {
            this.modeButton.m_93666_(this.getModeButtonText());
        }
    }

    public void updateBlockCountFromServer(int serverBlockCount) {
        this.currentBlockCount = serverBlockCount;
    }

    public void updateChestCountFromServer(int serverChestCount) {
        this.currentChestCount = serverChestCount;
    }

    public void updateShipInfoFromServer(boolean isOnShip, long shipId) {
        ((ShipItemTransportMenu)this.f_97732_).setShipInfo(isOnShip, shipId);
        this.currentShipInfo = ((ShipItemTransportMenu)this.f_97732_).getShipConnectionInfo();
    }
}

