/*
 * Decompiled with CFR 0.152.
 */
package shipItemTransport.code;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import shipItemTransport.code.MultiblockManager;
import shipItemTransport.code.NetworkHandler;
import shipItemTransport.code.ShipItemTransportBlockEntity;
import shipItemTransport.code.ShipItemTransportMenu;
import shipItemTransport.code.SyncModePacket;

public class ToggleModePacket {
    private final BlockPos blockPos;

    public ToggleModePacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public ToggleModePacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Level level;
            BlockEntity patt1184$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt1184$temp = (level = player.m_9236_()).m_7702_(this.blockPos)) instanceof ShipItemTransportBlockEntity) {
                ShipItemTransportBlockEntity blockEntity = (ShipItemTransportBlockEntity)patt1184$temp;
                String multiblockId = blockEntity.getMultiblockId();
                if (multiblockId != null) {
                    MultiblockManager manager = MultiblockManager.get(level);
                    if (manager != null) {
                        manager.toggleMultiblockMode(multiblockId);
                        boolean newMode = manager.getMultiblockMode(multiblockId);
                        SyncModePacket syncPacket = new SyncModePacket(newMode);
                        for (ServerPlayer serverPlayer : level.m_6907_()) {
                            String viewedMultiblockId;
                            ShipItemTransportMenu menu;
                            AbstractContainerMenu patt2128$temp = serverPlayer.f_36096_;
                            if (!(patt2128$temp instanceof ShipItemTransportMenu) || (menu = (ShipItemTransportMenu)patt2128$temp).getBlockEntity() == null || !multiblockId.equals(viewedMultiblockId = menu.getBlockEntity().getMultiblockId())) continue;
                            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)syncPacket);
                        }
                    }
                } else {
                    ShipItemTransportMenu menu;
                    blockEntity.toggleMode();
                    boolean newMode = blockEntity.isImportMode();
                    AbstractContainerMenu patt3066$temp = player.f_36096_;
                    if (patt3066$temp instanceof ShipItemTransportMenu && (menu = (ShipItemTransportMenu)patt3066$temp).getBlockEntity() != null && menu.getBlockEntity().m_58899_().equals((Object)this.blockPos)) {
                        SyncModePacket syncPacket = new SyncModePacket(newMode);
                        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)syncPacket);
                    }
                }
            }
        });
        return true;
    }
}

