package com.joshiegemfinder.synchronisedblockstates.common.client.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockInfoRegistry;
import com.joshiegemfinder.synchronisedblockstates.common.util.RegistryBlockInfoWrapper;

import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;

public class BlockInfoRegistryComparable {

	private final List<class_5321<class_2248>> orderedKeys;
	private final Reference2ObjectOpenHashMap<class_5321<class_2248>, RegistryBlockInfoWrapper.Impl> blockInfoMap;

	public BlockInfoRegistryComparable(BlockInfoRegistry registry) {
		final RegistryBlockInfoWrapper.Impl[] blocks = registry.getBlocks();
		orderedKeys = new ArrayList<class_5321<class_2248>>(blocks.length);
		blockInfoMap = new Reference2ObjectOpenHashMap<class_5321<class_2248>, RegistryBlockInfoWrapper.Impl>(blocks.length);
		
		for(int i = 0; i < blocks.length; ++i) {
			final RegistryBlockInfoWrapper.Impl block = blocks[i];
			final class_5321<class_2248> key = block.getKey();
			orderedKeys.add(key);
			blockInfoMap.put(key, block);
		}
	}

	public BlockInfoRegistryComparable(List<class_5321<class_2248>> defaultKeyOrdering, BlockInfoRegistry registry) {
		final RegistryBlockInfoWrapper.Impl[] blocks = registry.getBlocks();
		final int registryBlockCount = blocks.length;
		final int defaultKeyCount = defaultKeyOrdering.size();
		
		orderedKeys = new ArrayList<class_5321<class_2248>>(registryBlockCount);
		blockInfoMap = new Reference2ObjectOpenHashMap<class_5321<class_2248>, RegistryBlockInfoWrapper.Impl>(registryBlockCount);

		Reference2IntLinkedOpenHashMap<class_5321<class_2248>> keyIndexes = new Reference2IntLinkedOpenHashMap<class_5321<class_2248>>(defaultKeyCount);
		for(int i = 0; i < defaultKeyCount; ++i) {
			keyIndexes.put(defaultKeyOrdering.get(i), i);
		}
		keyIndexes.defaultReturnValue(-1);
		
		@SuppressWarnings("unchecked")
		class_5321<class_2248>[] keysHit = new class_5321[defaultKeyCount];
		List<class_5321<class_2248>> keysMissed = new ArrayList<class_5321<class_2248>>(registryBlockCount);

		for(int i = 0; i < registryBlockCount; ++i) {
			final RegistryBlockInfoWrapper.Impl block = blocks[i];
			final class_5321<class_2248> key = block.getKey();
			blockInfoMap.put(key, block);
			
			int hit = keyIndexes.removeInt(key);
			if(hit != -1) {
				keysHit[hit] = key;
			} else {
				keysMissed.add(key);
			}
		}
		
		for(int i = 0; i < defaultKeyCount; ++i) {
			if(keysHit[i] != null) {
				orderedKeys.add(keysHit[i]);
			}
		}
		
		orderedKeys.addAll(keysMissed);
		
	}
}
