package com.joshiegemfinder.synchronisedblockstates.common.client.util;

import java.lang.ref.SoftReference;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2361;
import net.minecraft.class_2680;
import org.jetbrains.annotations.ApiStatus;

import com.joshiegemfinder.synchronisedblockstates.common.mixinexports.client.BlockMixinExports;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockInfoRegistry;

public class MappingUtil {

	public static final ProxyIdMapper<class_2680> PROXY_BLOCK_STATE_REGISTRY = class_156.method_656(() -> {
		class_2361<class_2680> stateRegistry = class_2248.field_10651;
		if(stateRegistry instanceof ProxyIdMapper<class_2680> proxyStateRegistry) {
			return proxyStateRegistry;
		} else {
			return BlockMixinExports.PROXY_BLOCK_STATE_REGISTRY;
		}
	});
	
	public static ProxyIdMapper<class_2680> getProxyMapper() {
		return PROXY_BLOCK_STATE_REGISTRY;
	}
	
	public static class_2361<class_2680> getCurrentMapper() {
		return getProxyMapper().getSourceMapper();
	}
	
	public static void setCurrentMapper(class_2361<class_2680> mapper) {
		getProxyMapper().setSourceMapper(mapper);
	}
	
	public static boolean isUsingCustomBlockStateRegistry() {
		return !(getProxyMapper().getSourceMapper() instanceof RemappingIdMapper<class_2680>);
	}

	public static class_2361<class_2680> getCurrentBlockStateRegistry() {
		return getProxyMapper().getSourceMapper();
	}

	public static class_2361<class_2680> getOriginalBlockStateRegistry() {
		class_2361<class_2680> blockstateMapper = getCurrentMapper();
		
		while(blockstateMapper instanceof RemappingIdMapper<class_2680> proxy) {
			blockstateMapper = proxy.getOriginalMapper();
		}
		
		return blockstateMapper;
	}

	public static class_2361<class_2680> restoreToOriginalBlockStateRegistry() {
		class_2361<class_2680> originalMapper = getOriginalBlockStateRegistry();
		getProxyMapper().setSourceMapper(originalMapper);
		return originalMapper;
	}

	// weak reference because the polymer mod exists and *will* screw with things
	@ApiStatus.Internal
	private static SoftReference<BlockInfoRegistry> ORIGINAL_CLIENT_REGISTRY = null;
	
	public static BlockInfoRegistry getOriginalBlockInfoRegistry() {
		if(ORIGINAL_CLIENT_REGISTRY == null || ORIGINAL_CLIENT_REGISTRY.get() == null) {
			final BlockInfoRegistry registry = BlockInfoRegistry.createRegistry(getOriginalBlockStateRegistry());
			ORIGINAL_CLIENT_REGISTRY = new SoftReference<>(registry);
			return registry;
		}
		return ORIGINAL_CLIENT_REGISTRY.get();
	}
	
	public static BlockInfoRegistry getCurrentBlockInfoRegistry() {
		class_2361<class_2680> currentMapper = getCurrentMapper();
		
		if(currentMapper == getOriginalBlockStateRegistry()) {
			return getOriginalBlockInfoRegistry();
		} else {
			return BlockInfoRegistry.createRegistry(currentMapper);
		}
	}
}
