package com.joshiegemfinder.synchronisedblockstates.common.client.util;

import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2361;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import com.google.common.collect.Lists;

import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;

/**
 * A mutable IdMapper wrapper, allowing us to swap the mapper being used without needing to change any references to Block.BLOCK_STATE_REGISTRY
 * @param <T>
 */
public class ProxyIdMapper<T> extends class_2361<T> {

	protected int lastNextId = this.field_11099;
	
	@Nullable
	protected class_2361<T> sourceMapper = null;

	public ProxyIdMapper(int i) {
		super(i);
//		this.idToT = Lists.<T>newArrayListWithExpectedSize(i);
//		this.tToId = new Object2IntOpenCustomHashMap<>(i, Util.identityStrategy()); //Reference2IntOpenHashMap would be a faster implementation
//		this.tToId.defaultReturnValue(-1);
	}
	
	public ProxyIdMapper(class_2361<T> sourceMapper) {
		super(0);
		this.setSourceMapper(sourceMapper);
	}
	
	public boolean isProxying() {
		return this.sourceMapper != null;
	}
	
	public class_2361<T> getSourceMapper() {
		return this.sourceMapper;
	}
	
	public void setSourceMapper(@NotNull class_2361<T> sourceMapper) {
		this.sourceMapper = Objects.requireNonNull(sourceMapper);
		this.lastNextId = this.field_11099 = sourceMapper.field_11099;
		this.field_11100 = sourceMapper.field_11100;
		this.field_11098 = sourceMapper.field_11098;
	}
	
	public void removeSourceMapper() {
		this.removeSourceMapper(512);
	}
	
	public void removeSourceMapper(int newSize) {
		this.sourceMapper = null;
		this.field_11098 = Lists.<T>newArrayListWithExpectedSize(newSize);
		this.field_11100 = new Object2IntOpenCustomHashMap<>(newSize, class_156.method_655());
		this.field_11100.defaultReturnValue(-1);
		this.lastNextId = this.field_11099 = 0;
	}
	
	private void trackNextIdChanges() {
		if(this.lastNextId != this.field_11099) { // nextId has been unexpectedly changed by a mixin
			this.lastNextId = this.sourceMapper.field_11099 = this.field_11099;
		} else { // otherwise, update to match any nextId changes to sourceMapper
			this.lastNextId = this.field_11099 = this.sourceMapper.field_11099;
		}
	}
	
	@Override
	public void method_10203(T object, int i) {
		this.trackNextIdChanges();
		this.sourceMapper.method_10203(object, i);
		this.lastNextId = this.field_11099 = this.sourceMapper.field_11099;
	}

	@Override
	public void method_10205(T object) {
		this.trackNextIdChanges();
		this.method_10203(object, this.sourceMapper.field_11099);
	}
}
