package com.joshiegemfinder.synchronisedblockstates.common.network.packet;

import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;
import com.joshiegemfinder.synchronisedblockstates.common.util.RegistryBlockInfoWrapper;

public record ChunkedBlockRegistryBlockInfoPacket(UUID uuid, int blockInfoOffset, RegistryBlockInfoWrapper[] blockInfoArray) {

	public static final class_2960 TYPE = new class_2960(SynchronisedBlockstates.MOD_ID, "chunked_block_sync_block_info");

	public static void encode(class_2540 buf, ChunkedBlockRegistryBlockInfoPacket packet) {
		buf.method_10797(packet.uuid());
		buf.writeInt(packet.blockInfoOffset());
		
		final RegistryBlockInfoWrapper[] blockInfoArray = packet.blockInfoArray();
		
		buf.method_10804(blockInfoArray.length);
		for(int i = 0; i < blockInfoArray.length; ++i) {
			RegistryBlockInfoWrapper.encodeRegistry(buf, blockInfoArray[i]);
		}
	}
	
	public static ChunkedBlockRegistryBlockInfoPacket decode(class_2540 buf) {
		UUID uuid = buf.method_10790();
		int blockInfoOffset = buf.readInt();
		
		final int blockInfoCount = buf.method_10816();
		final RegistryBlockInfoWrapper[] blockInfoArray = new RegistryBlockInfoWrapper[blockInfoCount];
		for(int i = 0; i < blockInfoCount; ++i) {
			blockInfoArray[i] = RegistryBlockInfoWrapper.decodeRegistry(buf);
		}
		
		return new ChunkedBlockRegistryBlockInfoPacket(uuid, blockInfoOffset, blockInfoArray);
	}
	
}
