package com.joshiegemfinder.synchronisedblockstates.common.network.packet;

import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;
import com.joshiegemfinder.synchronisedblockstates.common.util.PropertyRepresentative;

public record ChunkedBlockRegistryPropertyPacket(UUID uuid, int propertyOffset, PropertyRepresentative[] propertyRepresentatives) {

	public static final class_2960 TYPE = new class_2960(SynchronisedBlockstates.MOD_ID, "chunked_block_sync_properties");

	public static void encode(class_2540 buf, ChunkedBlockRegistryPropertyPacket packet) {
		buf.method_10797(packet.uuid());
		buf.writeInt(packet.propertyOffset());
		
		final PropertyRepresentative[] propertyRepresentatives = packet.propertyRepresentatives();
		
		buf.method_10804(propertyRepresentatives.length);
		for(int i = 0; i < propertyRepresentatives.length; ++i) {
			PropertyRepresentative.encode(buf, propertyRepresentatives[i]);
		}
	}
	
	public static ChunkedBlockRegistryPropertyPacket decode(class_2540 buf) {
		UUID uuid = buf.method_10790();
		int propertyOffset = buf.readInt();
		
		final int propertyCount = buf.method_10816();
		final PropertyRepresentative[] propertyRepresentatives = new PropertyRepresentative[propertyCount];
		for(int i = 0; i < propertyCount; ++i) {
			propertyRepresentatives[i] = PropertyRepresentative.decode(buf);
		}
		
		return new ChunkedBlockRegistryPropertyPacket(uuid, propertyOffset, propertyRepresentatives);
	}
	
}
