package com.joshiegemfinder.synchronisedblockstates.common.network.packet;

import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;

public record ChunkedBlockRegistryStartPacket(UUID uuid, int totalPropertyCount, int totalBlockCount) {

	public static final class_2960 TYPE = new class_2960(SynchronisedBlockstates.MOD_ID, "chunked_block_sync_start");

	public static void encode(class_2540 buf, ChunkedBlockRegistryStartPacket packet) {
		buf.method_10797(packet.uuid());
		buf.writeInt(packet.totalPropertyCount());
		buf.writeInt(packet.totalBlockCount());
	}
	
	public static ChunkedBlockRegistryStartPacket decode(class_2540 buf) {
		UUID uuid = buf.method_10790();
		int totalPropertyCount = buf.readInt();
		int totalBlockCount = buf.readInt();
		return new ChunkedBlockRegistryStartPacket(uuid, totalPropertyCount, totalBlockCount);
	}
	
}
