package com.joshiegemfinder.synchronisedblockstates.common.util;

import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public abstract sealed class BlockInfoWrapper permits ServerBlockInfoWrapper, ClientBlockInfoWrapper, RegistryBlockInfoWrapper {

	protected final class_5321<class_2248> key;
	
	public BlockInfoWrapper(class_5321<class_2248> key) {
		this.key = key;
	}
	
	public final class_5321<class_2248> getKey() {
		return this.key;
	}
	
	public abstract PropertyRepresentative[] getProperties();
	public int getPropertyCount() {
		return this.getProperties().length;
	}
	
	public abstract int[] getStateGlobalIndexes();
	public int getStateCount() {
		return this.getStateGlobalIndexes().length;
	}
	
	public static void encode(class_2540 buf, final BlockInfoWrapper blockInfo) {
		// Write block key
		buf.method_44116(blockInfo.getKey());

		// Write properties
		final PropertyRepresentative[] properties = blockInfo.getProperties();
		final int propertyCount = properties.length;
		
		// Write property count
		buf.method_10804(propertyCount);
		// Write each individual property
		for(int i = 0; i < propertyCount; ++i) {
			PropertyRepresentative.encode(buf, properties[i]);
		}
		
		// Write states
		final int[] states = blockInfo.getStateGlobalIndexes();
		final int stateCount = states.length;
		
		// "State count can be calculated from properties" - update: it cannot, because air
//		buf.writeVarIntArray(states);
		// Write state count
		buf.method_10804(stateCount);
		// Write each individual state index
		for(int i = 0; i < stateCount; ++i) {
			buf.method_10804(states[i]);
		}
	}
	
	public static BlockInfoWrapper decode(class_2540 buf) {
		// Read the block key
		class_5321<class_2248> blockKey = buf.method_44112(class_7924.field_41254);

//		// State count can be calculated from properties
		int stateCount = 1;
		
		// Read property count
		final int propertyCount = buf.method_10816();
		
		// Read properties
		final PropertyRepresentative[] properties = new PropertyRepresentative[propertyCount];

		for(int i = 0; i < propertyCount; ++i) {
//			properties[i] = PropertyRepresentative.decode(buf);
			PropertyRepresentative property = properties[i] = PropertyRepresentative.decode(buf);
			stateCount *= property.allowedValues().length;
		}
		
		// Read global state indexes
//		final int stateCount = buf.readVarInt();
		int[] stateGlobalIndexes = new int[stateCount];
		for(int i = 0; i < stateCount; ++i) {
			stateGlobalIndexes[i] = buf.method_10816();
		}
//		int[] stateGlobalIndexes = buf.readVarIntArray();
		
		return new ClientBlockInfoWrapper(blockKey, properties, stateGlobalIndexes);
	}
}
