package com.joshiegemfinder.synchronisedblockstates.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2769;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;

public record PropertyRepresentative(String name, String propertyClass, String[] allowedValues) {

	// String::intern has some issues, apparently
	public static final ObjectOpenHashSet<String> STRING_INTERNER = new ObjectOpenHashSet<String>();
	public static final Object2ObjectOpenHashMap<PropertyRepresentative.InternKey, PropertyRepresentative> PROPERTY_INTERNER = new Object2ObjectOpenHashMap<PropertyRepresentative.InternKey, PropertyRepresentative>();
	public static final Reference2ObjectOpenHashMap<class_2769<?>, PropertyRepresentative> PROPERTY_MAP = new Reference2ObjectOpenHashMap<class_2769<?>, PropertyRepresentative>();

	public static int compare(class_2769<?> property1, class_2769<?> property2) {
		return String.CASE_INSENSITIVE_ORDER.compare(property1.method_11899(), property2.method_11899());
	}
	
	@Deprecated
	public PropertyRepresentative(String name, String propertyClass, String[] allowedValues) {
		this.name = name;
		this.propertyClass = propertyClass;
		this.allowedValues = allowedValues;
	}

	@Override
	public final String toString() {
		return String.format("PropertyRepresentative[name=%s, propertyClass=%s, allowedValues=%s]", this.name, this.propertyClass, Arrays.toString(this.allowedValues));
//		return String.format("PropertyRepresentative[name=%s, allowedValues=%s]", this.name, Arrays.toString(this.allowedValues));
	}
	
	public static PropertyRepresentative of(class_2769<?> property) {
		return PROPERTY_MAP.computeIfAbsent(property, (class_2769<?> key) -> PropertyRepresentative.create(key.method_11899(), key.method_11902().getName(), getPropertyNameArray(key)));
	}
	
	public static <T extends Comparable<T>> String[] getPropertyNameArray(class_2769<T> property) {
//		return (String[])(property.getPossibleValues().stream().map(v -> property.getName(v)).toArray());
		final Collection<T> values = property.method_11898();
		final int count = values.size();
		final String[] names = new String[count];
		int i = 0;
		for(T val : values) {
			names[i++] = property.method_11901(val);
		}
		return names;
	}
	
	public static PropertyRepresentative create(String name, String propertyClass, String[] allowedValues) {
		return PROPERTY_INTERNER.computeIfAbsent(new InternKey(name, propertyClass, allowedValues), (PropertyRepresentative.InternKey key) -> {
			key.intern();
			return new PropertyRepresentative(key.name, key.propertyClass, key.allowedValues);
		});
	}
	
	public static void encode(class_2540 buf, final PropertyRepresentative property) {
		buf.method_10814(property.name);
		buf.method_10814(property.propertyClass);
		final String[] allowedValues = property.allowedValues;
		final int allowedValueCount = allowedValues.length;
		buf.method_10804(allowedValueCount);
		for(int i = 0; i < allowedValueCount; ++i) {
			buf.method_10814(allowedValues[i]);
		}
	}

	public static PropertyRepresentative decode(class_2540 buf) {
		String name = buf.method_19772();	
		String propertyClass = buf.method_19772();
		final int allowedValueCount = buf.method_10816();
		final String[] allowedValues = new String[allowedValueCount];
		for(int i = 0; i < allowedValueCount; ++i) {
			allowedValues[i] = buf.method_19772();
		}
		
		return PropertyRepresentative.create(name, propertyClass, allowedValues);
	}
	
	@Override
	public final int hashCode() {
		return name.hashCode() * 31 + propertyClass.hashCode();
//		return name.hashCode();
	}
	
	@Override
	public final boolean equals(Object arg0) {
		// we interned the name and property class so we can use == here
		return arg0 instanceof PropertyRepresentative property && (this.name == property.name && /*this.propertyClass == property.propertyClass &&*/ Arrays.equals(this.allowedValues, property.allowedValues));
	}
	
	public static final class InternKey {

		private boolean hasInterned = false;
		private String name;
		private String propertyClass;
		private String[] allowedValues;
		
		public InternKey(String name, String propertyClass, String[] allowedValues) {
			this.name = name;
			this.propertyClass = propertyClass;
			
			String[] sortedAllowedValues = allowedValues.clone();
			sortValues(sortedAllowedValues);
			
			this.allowedValues = sortedAllowedValues;
		}

		public static void sortValues(String[] values) {
			Arrays.sort(values, String.CASE_INSENSITIVE_ORDER);
		}
		
		public static <T> void sortValues(T[] values, Function<T, String> keyExtractor) {
			Arrays.sort(values, Comparator.comparing(keyExtractor, String.CASE_INSENSITIVE_ORDER));
		}
		
		public void intern() {
			if(this.hasInterned) return; 
//			this.name = this.name.intern();
			this.name = STRING_INTERNER.addOrGet(this.name);
//			this.propertyClass = this.propertyClass.intern();
			this.propertyClass = STRING_INTERNER.addOrGet(this.propertyClass);
			for(int i = 0; i < this.allowedValues.length; ++i) {
//				this.allowedValues[i] = this.allowedValues[i].intern();
				this.allowedValues[i] = STRING_INTERNER.addOrGet(this.allowedValues[i]);
			}
			this.hasInterned = true;
		}
		
		@Override
		public final int hashCode() {
			return name.hashCode() * 31 + propertyClass.hashCode();
//			return name.hashCode();
		}
		
		@Override
		public final boolean equals(Object arg0) {
			return arg0 instanceof InternKey property && (Objects.equals(this.name, property.name) && /*Objects.equals(this.propertyClass, property.propertyClass) &&*/ Arrays.equals(this.allowedValues, property.allowedValues));
		}
	}
}
