package com.joshiegemfinder.synchronisedblockstates.common.util;

import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public sealed abstract class RegistryBlockInfoWrapper extends BlockInfoWrapper permits RegistryBlockInfoWrapper.Impl, RegistryBlockInfoWrapper.Empty {

	protected final int[] propertyRepresentativeIndexes;
	protected final int[] stateGlobalIndexes;
	
	public RegistryBlockInfoWrapper(class_5321<class_2248> key, int[] propertyRepresentativeIndexes, int[] stateGlobalIndexes) {
		super(key);
		
		this.propertyRepresentativeIndexes = propertyRepresentativeIndexes;
		this.stateGlobalIndexes = stateGlobalIndexes;
	}
	
	public int[] getPropertyIndexes() {
		return this.propertyRepresentativeIndexes;
	}
	
	@Override
	public abstract PropertyRepresentative[] getProperties();

	@Override
	public int[] getStateGlobalIndexes() {
		return this.stateGlobalIndexes;
	}
	
	public ClientBlockInfoWrapper toClientWrapper() {
		return new ClientBlockInfoWrapper(this.getKey(), this.getProperties(), this.getStateGlobalIndexes());
	}

	public static void encodeRegistry(class_2540 buf, final RegistryBlockInfoWrapper blockInfo) {
		// Write block key
		buf.method_44116(blockInfo.getKey());

		// Write properties
		buf.method_10806(blockInfo.getPropertyIndexes());
		
		// Write states
		buf.method_10806(blockInfo.getStateGlobalIndexes());
	}

	public static final RegistryBlockInfoWrapper.Empty decodeRegistry(class_2540 buf) {
		// Read the block key
		class_5321<class_2248> blockKey = buf.method_44112(class_7924.field_41254);
		
		// Read properties
		final int[] propertyRepresentativeIndexes = buf.method_10787();
		
		// Read global state indexes
		final int[] stateGlobalIndexes = buf.method_10787();
		
		return new RegistryBlockInfoWrapper.Empty(blockKey, propertyRepresentativeIndexes, stateGlobalIndexes);
	}

	public static final RegistryBlockInfoWrapper.Impl decodeRegistry(class_2540 buf, PropertyRepresentative[] propertyRegistry) {
		// Read the block key
		class_5321<class_2248> blockKey = buf.method_44112(class_7924.field_41254);
		
		// Read properties
		final int[] propertyRepresentativeIndexes = buf.method_10787();
		
		// Read global state indexes
		final int[] stateGlobalIndexes = buf.method_10787();
		
		return new RegistryBlockInfoWrapper.Impl(blockKey, propertyRepresentativeIndexes, stateGlobalIndexes, propertyRegistry);
	}
	
	public static final class Empty extends RegistryBlockInfoWrapper {
		public Empty(class_5321<class_2248> key, int[] propertyRepresentativeIndexes, int[] stateGlobalIndexes) {
			super(key, propertyRepresentativeIndexes, stateGlobalIndexes);
		}
		
		@Override
		public PropertyRepresentative[] getProperties() {
			throw new UnsupportedOperationException();
		}
	}
	
	public static final class Impl extends RegistryBlockInfoWrapper {
		protected final PropertyRepresentative[] propertyRegistry;
		
		public Impl(class_5321<class_2248> key, int[] propertyRepresentativeIndexes, int[] stateGlobalIndexes, PropertyRepresentative[] propertyRegistry) {
			super(key, propertyRepresentativeIndexes, stateGlobalIndexes);
			
			this.propertyRegistry = propertyRegistry;
		}
		
		@Override
		public PropertyRepresentative[] getProperties() {
			final int[] propertyRepresentativeIndexes = this.propertyRepresentativeIndexes;
			final int propertyCount = propertyRepresentativeIndexes.length;

			final PropertyRepresentative[] propertyRegistry = this.propertyRegistry;
			
			PropertyRepresentative[] propertyRepresentatives = new PropertyRepresentative[propertyCount];
			
			for(int i = 0; i < propertyCount; ++i) {
				int propertyIndex = propertyRepresentativeIndexes[i];
				propertyRepresentatives[i] = propertyRegistry[propertyIndex];
			}
			
			return propertyRepresentatives;
		}
	}
}
