package com.joshiegemfinder.synchronisedblockstates.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_5321;

public final class ServerBlockInfoWrapper extends BlockInfoWrapper {

	protected final class_2248 block;
//	protected final BlockRepresentative blockRepresentative;
	protected final int propertyCount;
	protected final class_2769<?>[] properties;
	protected final Object[][] propertyValues;
	protected final PropertyRepresentative[] propertyRepresentatives;
	protected final int stateCount;
	protected final int[] stateGlobalIndexes;
	
	
	public ServerBlockInfoWrapper(class_5321<class_2248> key, class_2248 block) {
		super(key);
		this.block = block;

		// order properties
		final class_2769<?>[] properties = this.properties = orderProperties(block);
		
		final int propertyCount = this.propertyCount = properties.length;
		
		final PropertyRepresentative[] propertyRepresentatives = this.propertyRepresentatives = new PropertyRepresentative[propertyCount];
		final Object[][] propertyValues = this.propertyValues = new Object[propertyCount][];
		
		int stateCount = 1;
		
		for(int i = 0; i < propertyCount; ++i) {
			// Get property
			final class_2769<?> property = properties[i];
			// Get value count
			final int valueCount = property.method_11898().size();
			// Get property representative
			PropertyRepresentative propertyRepresentative = propertyRepresentatives[i] = PropertyRepresentative.of(property);
			
			// Convert sorted strings to usable values for speed when we accept blockstates later on
			Object[] values = propertyValues[i] = new Object[valueCount];
			final String[] internedAllowedValues = propertyRepresentative.allowedValues();
			for(int j = 0; j < valueCount; ++j) {
				// TODO this might be bad for performance, switch to relying on InternKey::sortValues
				values[j] = property.method_11900(internedAllowedValues[j]).get();
			}
			
			// Keep track of the number of states
			stateCount *= valueCount;
		}
		
		this.stateCount = stateCount;
		this.stateGlobalIndexes = new int[stateCount];
	}

	protected class_2769<?>[] orderProperties(class_2248 block) {
		class_2689<class_2248, class_2680> stateDefinition = block.method_9595();
		List<class_2769<?>> propertyList = new ArrayList<>(stateDefinition.method_11659());
		propertyList.sort(PropertyRepresentative::compare);
		return propertyList.toArray(new class_2769<?>[0]);
	}
	
	public class_2248 getBlock() {
		return this.block;
	}
	
	public class_2769<?>[] getPropertyObjects() {
		return this.properties;
	}

	protected int getBlockStateIndex(class_2680 state) {
		int index = 0;
		for(int propertyIndex = 0; propertyIndex < this.properties.length; ++propertyIndex) {
			class_2769<?> property = this.properties[propertyIndex];
			
			Optional<?> valueOptional = state.method_28500(property);
			if(valueOptional.isEmpty()) {
				return -1;
			}
			
			Object stateValue = valueOptional.get();
			
			Object[] values = this.propertyValues[propertyIndex];

			index *= values.length;
			
			for(int i = 0; i < values.length; ++i) {
				Object value = values[i];

				if(Objects.equals(value, stateValue)) {
//				if(value == stateValue) {
					index += i;
					break;
				}
			}
		}
		
		return index;
	}

	public void acceptBlockState(class_2680 state, int globalIndex) {
		int stateIndex = getBlockStateIndex(state);
		this.stateGlobalIndexes[stateIndex] = globalIndex;
	}
	
	@Override
	public PropertyRepresentative[] getProperties() {
		return this.propertyRepresentatives;
	}

	@Override
	public int[] getStateGlobalIndexes() {
		return this.stateGlobalIndexes;
	}
	
	@Override
	public int getStateCount() {
		return this.stateCount;
	}
}
