package com.joshiegemfinder.synchronisedblockstates.fabric.network;

import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;
import com.joshiegemfinder.synchronisedblockstates.common.network.login.TaskManagerGetter;
import com.joshiegemfinder.synchronisedblockstates.common.network.packet.ChunkedBlockRegistryBlockInfoPacket;
import com.joshiegemfinder.synchronisedblockstates.common.network.packet.ChunkedBlockRegistryCompletePacket;
import com.joshiegemfinder.synchronisedblockstates.common.network.packet.ChunkedBlockRegistryPropertyPacket;
import com.joshiegemfinder.synchronisedblockstates.common.network.packet.ChunkedBlockRegistryStartPacket;
import com.joshiegemfinder.synchronisedblockstates.common.network.packet.LoginTaskProbePacket;
import com.joshiegemfinder.synchronisedblockstates.common.network.packet.UnchunkedBlockRegistryPacket;
import com.joshiegemfinder.synchronisedblockstates.common.network.task.SyncBlockstatesTask;
import com.joshiegemfinder.synchronisedblockstates.fabric.event.CollectLoginTasksEvent;
import com.joshiegemfinder.synchronisedblockstates.fabric.mixin.ServerLoginPacketListenerImplConnectionAccessor;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking.LoginSynchronizer;
import net.minecraft.class_2540;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;

public class SynchronisedBlockstatesNetworkFabric {


	public static void registerTasks() {
		CollectLoginTasksEvent.EVENT.register((packetListener, server, profile, queryIdGenerator, taskConsumer) -> {
			// if it's a memory connection, that means we're sharing the same static Block.BLOCK_STATE_REGISTRY instance anyways
			boolean isMemoryConnection = ((ServerLoginPacketListenerImplConnectionAccessor)packetListener).getConnection().method_10756();
			if(!isMemoryConnection) {
				taskConsumer.accept(new SyncBlockstatesTask(queryIdGenerator));
			}
		});
	}
	
	public static void taskDataResponse(MinecraftServer server, class_3248 handler, boolean understood, class_2540 buf, LoginSynchronizer synchronizer, PacketSender responseSender) {
		if(!(handler instanceof TaskManagerGetter taskManagerGetter)) {
			return;
		}
		
		SyncBlockstatesTask task = taskManagerGetter.getCurrentTask(SyncBlockstatesTask.TYPE);
		
		if(task != null) {
			task.handleChunkedRegistryDataResponse(responseSender::sendPacket);
		}
	}
	
	public static void registerPackets() {
		ServerLoginNetworking.registerGlobalReceiver(LoginTaskProbePacket.TYPE, (server, handler, understood, buf, synchronizer, responseSender) -> {
			LoginTaskProbePacket packet = LoginTaskProbePacket.decode(buf);
			
			if(packet.networkVersion() != SynchronisedBlockstates.NETWORK_VERSION) {
				SynchronisedBlockstates.LOGGER.warn("Connecting client running network version {} to a server running network version {}", packet.networkVersion(), SynchronisedBlockstates.NETWORK_VERSION);
			}
			
			if(!(handler instanceof TaskManagerGetter taskManagerGetter)) {
				return;
			}
			
			if(!understood) {
				// they are not running synchronised blockstates, don't send them the full state registry because they'll just discard it
				taskManagerGetter.completeTask(SyncBlockstatesTask.TYPE);
			} else {
				SyncBlockstatesTask task = taskManagerGetter.getCurrentTask(SyncBlockstatesTask.TYPE);
				
				if(task != null) {
					task.sendRegistry(responseSender::sendPacket);
				}
			}
		});

		ServerLoginNetworking.registerGlobalReceiver(UnchunkedBlockRegistryPacket.TYPE, (server, handler, understood, buf, synchronizer, responseSender) -> {
			if(understood) {
				String response = buf.method_19772();
				SynchronisedBlockstates.LOGGER.info("Unchunked registry response from client: {}", response);
			}
			
			if(handler instanceof TaskManagerGetter taskManagerGetter) {
				SynchronisedBlockstates.LOGGER.info("Completing task for unchunked registry");
				taskManagerGetter.completeTask(SyncBlockstatesTask.TYPE);
			}
		});

		ServerLoginNetworking.registerGlobalReceiver(ChunkedBlockRegistryStartPacket.TYPE, (server, handler, understood, buf, synchronizer, responseSender) -> {
			boolean canSend = false;
			if(understood) {
				canSend = buf.readBoolean();
			}
			
			if(!(handler instanceof TaskManagerGetter taskManagerGetter)) {
				return;
			}
			
			if(!canSend) {
				taskManagerGetter.completeTask(SyncBlockstatesTask.TYPE);
				return;
			}
			
			SyncBlockstatesTask task = taskManagerGetter.getCurrentTask(SyncBlockstatesTask.TYPE);
			
			if(task != null) {
				task.sendChunkedRegistryData(responseSender::sendPacket);
			}
		});

		ServerLoginNetworking.registerGlobalReceiver(ChunkedBlockRegistryPropertyPacket.TYPE, SynchronisedBlockstatesNetworkFabric::taskDataResponse);

		ServerLoginNetworking.registerGlobalReceiver(ChunkedBlockRegistryBlockInfoPacket.TYPE, SynchronisedBlockstatesNetworkFabric::taskDataResponse);

		ServerLoginNetworking.registerGlobalReceiver(ChunkedBlockRegistryCompletePacket.TYPE, (server, handler, understood, buf, synchronizer, responseSender) -> {
			String response = buf.method_19772();
			SynchronisedBlockstates.LOGGER.info("Chunked registry response from client: {}", response);
			
			if(handler instanceof TaskManagerGetter taskManagerGetter) {
				SynchronisedBlockstates.LOGGER.info("Completing task for chunked registry");
				taskManagerGetter.completeTask(SyncBlockstatesTask.TYPE);
			}
		});
	}

}
