package com.joshiegemfinder.synchronisedblockstates.fabric.network.login;

import java.util.Objects;
import java.util.function.Consumer;

import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;
import com.joshiegemfinder.synchronisedblockstates.common.network.login.QueryIdGenerator;
import com.joshiegemfinder.synchronisedblockstates.common.network.login.TaskManager;
import com.joshiegemfinder.synchronisedblockstates.fabric.event.CollectLoginTasksEvent;
import com.joshiegemfinder.synchronisedblockstates.fabric.mixin.ServerLoginPacketListenerImplConnectionAccessor;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;

public class FabricTaskManager extends TaskManager {

	protected final class_3248 packetListener;
	protected final QueryIdGenerator queryIdGenerator;
	
	public FabricTaskManager(class_3248 packetListener) {
		super();
		this.packetListener = Objects.requireNonNull(packetListener);
		QueryIdGenerator queryIdGenerator = null;
		try {
			queryIdGenerator = new FabricImplBasedQueryIdGenerator(packetListener);
		} catch(Throwable t) {
			SynchronisedBlockstates.LOGGER.warn("Could not extract Query ID Factory from fabric networking impl, are we behind a connector?");
			// catch Throwable to also catch ClassDefNotFound
		}
		
		if(queryIdGenerator == null) {
			queryIdGenerator = QueryIdGenerator.create();
		}
		
		this.queryIdGenerator = queryIdGenerator;
	}
	
	@Override
	protected void collectTasksInternal(MinecraftServer server, GameProfile profile) {
		CollectLoginTasksEvent.EVENT.invoker().collectTasks(this.packetListener, server, profile, this.queryIdGenerator, this.taskQueue::add);
	}

	@Override
	protected boolean isAcceptingMessages() {
		return this.packetListener.method_48106();
	}

	@Override
	protected Consumer<class_2596<?>> getPacketSender() {
		return ((ServerLoginPacketListenerImplConnectionAccessor)packetListener).getConnection()::method_10743;
	}

	@Override
	protected void keepConnectionAlive() {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void disconnect(class_2561 component) {
		this.packetListener.method_14380(component);
	}

}
