package com.joshiegemfinder.synchronisedblockstates.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronisedBlockstates {

	public static final String MOD_ID = "synchronisedblockstates";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static final String FATALLY_MISSING_BLOCKSTATES_CLIENT = "synchronisedblockstates.client_fatally_missing_entries";
	public static final String FATALLY_MISSING_BLOCKSTATES_SERVER = "synchronisedblockstates.server_fatally_missing_entries";
	public static final String FATALLY_MISSING_BLOCKSTATES_BOTH = "synchronisedblockstates.both_fatally_missing_entries";

	// For handling the connector mod
	public static enum Mappings {
		NOT_INITIALIZED,
		INTERMEDIARY,
		SEARGE;
	}
	
	public static boolean isInitializedServer = false;
	public static Mappings initializedMappingsServer = Mappings.NOT_INITIALIZED;
	
	public static boolean isInitializedClient = false;
	public static Mappings initializedMappingsClient = Mappings.NOT_INITIALIZED;
	
}
