package com.joshiegemfinder.synchronisedblockstates.intermediary.network.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import class_8606;
import com.google.common.collect.Lists;
import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockStateRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.IndexHolder;
import com.joshiegemfinder.synchronisedblockstates.common.util.StateDefinitionRepresentative;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.SynchronisedBlockstatesNetwork;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundChunkedBlockstateSyncDataPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundChunkedBlockstateSyncEndPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundChunkedBlockstateSyncStartPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundSynchroniseBlockstatesPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.util.IntermediaryBlockStateHelper;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2248;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_8605;

public class SynchroniseBlockstatesTask implements class_8605 {
	
	public static final class_8605.class_8606 TYPE = new class_8606(SynchronisedBlockstatesNetwork.SYNCHRONISE_BLOCKSTATES_PACKET_ID.toString());

	@Override
	public class_8606 method_52375() {
		return TYPE;
	}
	
//	protected final MinecraftServer server;
//	
//	public SynchroniseBlockstatesTask(MinecraftServer server) {
//		this.server = server;
//	}
	
	
	@Override
	public void method_52376(Consumer<class_2596<?>> consumer) {
		SynchronisedBlockstates.LOGGER.info("Starting send packet task");
		int size = class_2248.field_10651.method_10204();

		// vanilla has 26684 blockstates
		if(size <= 50_000) {
			sendWithoutChunking(consumer);
		} else {
			sendChunked(consumer);
		}
		
		SynchronisedBlockstates.LOGGER.info("Ending send packet task");
	}
	
	public void sendWithoutChunking(Consumer<class_2596<?>> consumer) {
		final int totalStateCount = class_2248.field_10651.method_10204();
		BlockStateRepresentative[] states = new BlockStateRepresentative[totalStateCount];
		
		IntermediaryBlockStateHelper.beginCache();
		for(int i = 0; i < totalStateCount; ++i) {
			class_2680 blockState = class_2248.method_9531(i);
			states[i] = IntermediaryBlockStateHelper.wrapState(blockState);
		}
		IntermediaryBlockStateHelper.endCache();
		
		SynchronisedBlockstates.LOGGER.info("Sending unchunked blockstate packet...");

		consumer.accept(ServerConfigurationNetworking.createS2CPacket(new ClientboundSynchroniseBlockstatesPacket(states)));
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void sendChunked(Consumer<class_2596<?>> consumer) {
		final int totalStateCount = class_2248.field_10651.method_10204();

		List<BlockRepresentative> blockKeysOrdered = new ArrayList<BlockRepresentative>();
		Map<BlockRepresentative, List<IndexHolder>> blocks = new Object2ObjectArrayMap<>();
		BlockStateRepresentative[] states = new BlockStateRepresentative[totalStateCount];
		
		IntermediaryBlockStateHelper.beginCache();
		for(int i = 0; i < totalStateCount; ++i) {
			class_2680 blockState = class_2248.method_9531(i);
			
			BlockStateRepresentative state = IntermediaryBlockStateHelper.wrapState(blockState);
			BlockRepresentative block = state.getBlock();

			states[i] = state;
			
			blocks.computeIfAbsent(block, (key) -> {
				blockKeysOrdered.add(key);
				return Lists.newArrayList();
			}).add(new IndexHolder(i, state));
		}
		IntermediaryBlockStateHelper.endCache();
		
		final int totalBlockCount = blockKeysOrdered.size();
		
		StateDefinitionRepresentative[] definitions = new StateDefinitionRepresentative[totalBlockCount];
		
		for(int i = 0; i < totalBlockCount; ++i) {
			// ArrayList implements RandomAccess
			BlockRepresentative block = blockKeysOrdered.get(i);
			
			// Write blockstates and their indexes
			List<IndexHolder> representatives = blocks.get(block);
			StateDefinitionRepresentative blockRepresentative = new StateDefinitionRepresentative(block, representatives.toArray(new IndexHolder[0]));
			definitions[i] = blockRepresentative;
		}
		
		
		
		
		SynchronisedBlockstates.LOGGER.info("Sending chunked blockstate packets...");

		UUID uuid = UUID.randomUUID();

		// this is the start of chunking
		consumer.accept(ServerConfigurationNetworking.createS2CPacket(new ClientboundChunkedBlockstateSyncStartPacket(uuid, totalStateCount, totalBlockCount)));
		
		int dataPacketsSent = 0;
		
		boolean first = true;
		int containedStates = 0;
		int startIndex = 0;
		int index = 0;
		List<StateDefinitionRepresentative> chunk = new ArrayList<StateDefinitionRepresentative>(totalBlockCount);
		
		while(index < totalBlockCount) {
			var rep = definitions[index];
			if(first) {
				first = false;
				containedStates = rep.stateCount;
				startIndex = index;
				chunk.clear();
				chunk.add(rep);
			} else {
				// if adding this would exceed the chunk size
				if(containedStates + rep.stateCount > 50_000) {
					var packet = new ClientboundChunkedBlockstateSyncDataPacket(uuid, startIndex, chunk.toArray(new StateDefinitionRepresentative[0]));
					
					consumer.accept(ServerConfigurationNetworking.createS2CPacket(packet));
					dataPacketsSent++;
					first = true;
					continue; // don't increment index, because we're rehandling this block
				} else {
					containedStates += rep.stateCount;
					chunk.add(rep);
				}
			}
			
			index++;
		}
		
		// if there's an unsent chunk, send it
		if(chunk.size() > 0) {
			var packet = new ClientboundChunkedBlockstateSyncDataPacket(uuid, startIndex, chunk.toArray(new StateDefinitionRepresentative[0]));
			consumer.accept(ServerConfigurationNetworking.createS2CPacket(packet));
			dataPacketsSent++;
		}
		
		// this is the end of chunking
		consumer.accept(ServerConfigurationNetworking.createS2CPacket(new ClientboundChunkedBlockstateSyncEndPacket(uuid)));

		SynchronisedBlockstates.LOGGER.info("Successfully chunked blockstates: sent {} states in {} data packets", totalStateCount, dataPacketsSent);
	}
}
