package com.joshiegemfinder.synchronisedblockstates.intermediary.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5321;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.PropertyRepresentative;

public class IntermediaryBlockStateHelper {

	protected static boolean CACHE_BLOCKS = false;
	protected static final WeakHashMap<class_2248, BlockRepresentative<class_5321<class_2248>>> BLOCK_CACHE = new WeakHashMap<class_2248, BlockRepresentative<class_5321<class_2248>>>();

	public static <T extends Comparable<T>> String getPropertyValueName(class_2769<T> property, class_2680 state) {
		return property.method_11901(state.method_11654(property));
	}

	public static BlockRepresentative<class_5321<class_2248>> wrapBlock(class_2680 state) {
		return wrapBlock(state.method_41520().method_40230().get(), state.method_26204());
	}
	
	@SuppressWarnings("deprecation")
	public static BlockRepresentative<class_5321<class_2248>> wrapBlock(class_2248 block) {
		return wrapBlock(block.method_40142().method_40237(), block);
	}
	
	public static BlockRepresentative<class_5321<class_2248>> wrapBlock(class_5321<class_2248> key, class_2248 block) {
		Collection<class_2769<?>> properties = block.method_9595().method_11659();
		PropertyRepresentative[] propertyReference = properties.stream()
				.map(property -> PropertyRepresentative.of(property))
				.toList()
				.toArray(new PropertyRepresentative[0]);
		Arrays.sort(propertyReference, PropertyRepresentative::compare);
		return new BlockRepresentative<class_5321<class_2248>>(key, propertyReference);
	}

	public static void beginCache() {
		CACHE_BLOCKS = true;
		BLOCK_CACHE.clear();
	}
	
	public static IntermediaryBlockStateRepresentative wrapState(class_2680 state) {
		final BlockRepresentative<class_5321<class_2248>> block;
		if(CACHE_BLOCKS) {
			class_2248 stateBlock = state.method_26204();
			block = BLOCK_CACHE.computeIfAbsent(state.method_26204(), key -> {
				if(key == stateBlock) {
					return wrapBlock(state);
				} else {
					return wrapBlock(key);
				}
			});
		} else {
			block = wrapBlock(state);
		}
		
		IntermediaryBlockStateRepresentative stateHolder = new IntermediaryBlockStateRepresentative(block);

		for(class_2769<?> property : state.method_26204().method_9595().method_11659()) {
			String name = property.method_11899();
			
			var entry = stateHolder.propertyNameToRepresentative.get(name);
			
			int index = entry.rightInt();
			stateHolder.putValue(index, getPropertyValueName(property, state));
		}
		
		return stateHolder;
	}

	public static void endCache() {
		BLOCK_CACHE.clear();
		CACHE_BLOCKS = false;
	}
	
}
