package com.joshiegemfinder.synchronisedblockstates.intermediary.util;

import java.util.Collection;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5321;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockStateRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.PropertyRepresentative;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;

public class IntermediaryBlockStateRepresentative extends BlockStateRepresentative {

	public static final WeakHashMap<BlockRepresentative<?>, Object2ObjectArrayMap<String, ObjectIntPair<PropertyRepresentative>>> BLOCK_PROPERTY_STRING_MAP = new WeakHashMap<BlockRepresentative<?>, Object2ObjectArrayMap<String,ObjectIntPair<PropertyRepresentative>>>();
	
	public static Object2ObjectArrayMap<String, ObjectIntPair<PropertyRepresentative>> generatePropertyMapFromBlock(BlockRepresentative<?> block) {
		var propertyNameToRepresentative = new Object2ObjectArrayMap<String, ObjectIntPair<PropertyRepresentative>>(block.getPropertyCount());
		for(int i = 0; i < block.getPropertyCount(); ++i) {
			PropertyRepresentative property = block.getProperty(i);
			var pair = ObjectIntImmutablePair.of(property, i);
			propertyNameToRepresentative.put(property.getName(), pair);
		}
		return propertyNameToRepresentative;
	}
	
	public final Object2ObjectArrayMap<String, ObjectIntPair<PropertyRepresentative>> propertyNameToRepresentative;
	
	public IntermediaryBlockStateRepresentative(BlockRepresentative<?> block) {
		super(block);
		this.propertyNameToRepresentative = BLOCK_PROPERTY_STRING_MAP.computeIfAbsent(block, IntermediaryBlockStateRepresentative::generatePropertyMapFromBlock);
	}

	@Override
	public BlockStateRepresentative withBlock(BlockRepresentative<?> newBlock) {
		return new IntermediaryBlockStateRepresentative(newBlock);
	}

	@Override
	public boolean represents(Object object) {
		if(!(object instanceof class_2680 state)) { return false; }
		final BlockRepresentative<?> block = this.getBlock();
		final class_5321<class_2248> targetBlockKey = state.method_41520().method_40230().get();
		
		// Different block?
		if(!Objects.equals(block.getKey(), targetBlockKey))
			return false;
		
		// Different number of properties?
		Collection<class_2769<?>> stateProperties = state.method_28501();
		if(block.getPropertyCount() != stateProperties.size())
			return false;
		
		// Property values all the same?
//		for(int i = 0; i < block.getPropertyCount(); ++i) {
//			
//		}
		for(class_2769<?> property : stateProperties) {
			String name = property.method_11899();
			
			var entry = this.propertyNameToRepresentative.getOrDefault(name, null);
			if(entry == null) {
				return false;
			}
			
			PropertyRepresentative prop = entry.left();
			int index = entry.rightInt();
			if(!prop.represents(property) || !this.getValue(index).equals(IntermediaryBlockStateHelper.getPropertyValueName(property, state))) {
				return false;
			}
		}
		
		return true;
	}
	
}
