package com.joshiegemfinder.synchronisedblockstates.intermediary.util;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9139;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockRegistryRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockStateRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.PropertyRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.StateDefinitionRepresentative;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;

@SuppressWarnings("unchecked")
public class IntermediaryCodecs {

	public static void encodeStateDefinition(class_2540 buf, final StateDefinitionRepresentative stateDef) {
		// Write block name
		buf.method_44116((class_5321<class_2248>)stateDef.blockType.getKey());
		
		final List<PropertyRepresentative> properties = stateDef.blockType.getProperties();
		
		// Write property count
		buf.method_10804(properties.size());
		// Write all properties
		for(PropertyRepresentative property : properties) {
			PropertyRepresentative.STREAM_CODEC.encode(buf, property);
		}
		
		final BlockStateRepresentative[] stateBlocks = stateDef.states;
		// Write state count
		buf.method_10804(stateBlocks.length);
		// Write all states
		for(int stateIndex = 0; stateIndex < stateDef.stateCount; ++stateIndex) {
			final BlockStateRepresentative state = stateBlocks[stateIndex];
			final int globalIndex = stateDef.stateIndexes[stateIndex];
			
			// Write state's global index
			buf.method_10804(globalIndex);

			// Write state's properties
			for(int property = 0; property < properties.size(); ++property) {
				// Write values of all properties of the state
				buf.method_10814(state.getValue(property));
			}
		}
	}

	public static StateDefinitionRepresentative decodeStateDefinition(class_2540 buf) {
		final class_5321<class_2248> blockType = buf.method_44112(class_7924.field_41254);
		
		final int propertyCount = buf.method_10816();
		final PropertyRepresentative[] properties = new PropertyRepresentative[propertyCount];
		for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
			properties[propertyIndex] = PropertyRepresentative.STREAM_CODEC.decode(buf);
		}
		
		BlockRepresentative<class_5321<class_2248>> block = new BlockRepresentative<class_5321<class_2248>>(blockType, properties);
		
		final int stateCount = buf.method_10816();
		final IntermediaryBlockStateRepresentative[] stateBlocks = new IntermediaryBlockStateRepresentative[stateCount];
		final int[] stateGlobalIndexes = new int[stateCount];
		for(int stateIndex = 0; stateIndex < stateCount; ++stateIndex) {
			final int globalIndex = buf.method_10816();
			
			final IntermediaryBlockStateRepresentative state = new IntermediaryBlockStateRepresentative(block);

			for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
				state.putValue(propertyIndex, buf.method_19772().intern());
			}
			
			stateBlocks[stateIndex] = state;
			stateGlobalIndexes[stateIndex] = globalIndex;
		}
		
		return new StateDefinitionRepresentative(block, stateBlocks, stateGlobalIndexes);
	}
	
	public static StateDefinitionRepresentative decodeStateDefinitionWithGlobalIndex(class_2540 buf, final IntermediaryBlockStateRepresentative[] allStates) {
		final class_5321<class_2248> blockType = buf.method_44112(class_7924.field_41254);
		
		final int propertyCount = buf.method_10816();
		final PropertyRepresentative[] properties = new PropertyRepresentative[propertyCount];
		for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
			properties[propertyIndex] = PropertyRepresentative.STREAM_CODEC.decode(buf);
		}
		
		BlockRepresentative<class_5321<class_2248>> block = new BlockRepresentative<class_5321<class_2248>>(blockType, properties);
		
		final int stateCount = buf.method_10816();
		final IntermediaryBlockStateRepresentative[] stateBlocks = new IntermediaryBlockStateRepresentative[stateCount];
		final int[] stateGlobalIndexes = new int[stateCount];
		for(int stateIndex = 0; stateIndex < stateCount; ++stateIndex) {
			final int globalIndex = buf.method_10816();
			
			final IntermediaryBlockStateRepresentative state = new IntermediaryBlockStateRepresentative(block);

			for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
				state.putValue(propertyIndex, buf.method_19772().intern());
			}
			
			allStates[globalIndex] = state;
			stateBlocks[stateIndex] = state;
			stateGlobalIndexes[stateIndex] = globalIndex;
		}
		
		return new StateDefinitionRepresentative(block, stateBlocks, stateGlobalIndexes);
	}
	
	public static final class_9139<class_2540, StateDefinitionRepresentative[]> STATE_DEFINITION_ARRAY_STREAM_CODEC = class_9139.<class_2540, StateDefinitionRepresentative[]>method_56437(IntermediaryCodecs::encodeStateDefinitionArray, IntermediaryCodecs::decodeStateDefinitionArray);

	public static void encodeStateDefinitionArray(class_2540 buf, StateDefinitionRepresentative[] stateDefs) {
		buf.method_10804(stateDefs.length);
		for(var stateDef : stateDefs) {
			encodeStateDefinition(buf, stateDef);
		}
	}

	public static StateDefinitionRepresentative[] decodeStateDefinitionArray(class_2540 buf) {
		final int size = buf.method_10816();
		StateDefinitionRepresentative[] stateDefs = new StateDefinitionRepresentative[size];
		for(int i = 0; i < size; ++i) {
			final var stateDef = decodeStateDefinition(buf);
			stateDefs[i] = stateDef;
		}
		return stateDefs;
	}
	
	public static final class_9139<class_2540, BlockRegistryRepresentative> REGISTRY_STREAM_CODEC = class_9139.<class_2540, BlockRegistryRepresentative>method_56437(IntermediaryCodecs::encodeBlockRegistryRepresentative, IntermediaryCodecs::decodeBlockRegistryRepresentative);

	public static void encodeBlockRegistryRepresentative(class_2540 buf, BlockRegistryRepresentative registry) {
		final StateDefinitionRepresentative[] allBlocks = registry.allBlocks;
		
		final int totalStateCount = registry.allStates.length;
		final int totalBlockCount = allBlocks.length;
		// Write total state count
		buf.method_53002(totalStateCount);
		
		// Write total block count
		buf.method_53002(totalBlockCount);
		for(int blockIndex = 0; blockIndex < totalBlockCount; ++blockIndex) {
			final StateDefinitionRepresentative stateDef = allBlocks[blockIndex];
			encodeStateDefinition(buf, stateDef);
		}
	}

	public static BlockRegistryRepresentative decodeBlockRegistryRepresentative(class_2540 buf) {
		final int totalStateCount = buf.readInt();
		final int totalBlockCount = buf.readInt();
		
		final IntermediaryBlockStateRepresentative[] allStates = new IntermediaryBlockStateRepresentative[totalStateCount];
		final StateDefinitionRepresentative[] allBlocks = new StateDefinitionRepresentative[totalBlockCount];

		for(int blockIndex = 0; blockIndex < totalBlockCount; ++blockIndex) {
			allBlocks[blockIndex] = decodeStateDefinitionWithGlobalIndex(buf, allStates);
		}
		
		return new BlockRegistryRepresentative(allBlocks, allStates);
	}
	
	// Cowardly compressing packets instead of rewriting the whole mod a second time
	
	public static final class_9139<class_2540, BlockRegistryRepresentative> COMPRESSED_REGISTRY_STREAM_CODEC = class_9139.<class_2540, BlockRegistryRepresentative>method_56437(IntermediaryCodecs::encodeBlockRegistryRepresentative, IntermediaryCodecs::decodeBlockRegistryRepresentative);

	public static final Supplier<Deflater> DEFLATER_FACTORY = Deflater::new;
	
	private static final Deflater DEFAULT_DEFLATER = DEFLATER_FACTORY.get();
	private static final byte[] DEFAULT_DEFLATE_CHUNK = new byte[8192];
	
	public static void encodeBlockRegistryRepresentativeAndCompress(class_2540 buf, BlockRegistryRepresentative registry) {
//		var deflater = DEFLATER_FACTORY.get();
		var deflater = DEFAULT_DEFLATER;
		class_2540 uncompressedBuffer = new class_2540(Unpooled.buffer());
		encodeBlockRegistryRepresentative(uncompressedBuffer, registry);
		
		// read uncompressed size
		int uncompressedSize = uncompressedBuffer.readableBytes();

		// read regular uncompressed bytes to an array
		byte[] uncompressedBytes = new byte[uncompressedSize];
		uncompressedBuffer.method_52979(uncompressedBytes);
		
		
		// write uncompressed size to buffer
		buf.method_10804(uncompressedSize);
		
		// write compressed data to buffer
		try {
			deflater.setInput(uncompressedBytes, 0, uncompressedSize);
			deflater.finish();
			
			byte[] chunk = DEFAULT_DEFLATE_CHUNK;
			
			while(!deflater.finished()) {
				int chunkSize = deflater.deflate(chunk);
				buf.method_52980(chunk, 0, chunkSize);
			}
		} finally {
			deflater.reset();
		}
		
	}
	
	public static final Supplier<Inflater> INFLATER_FACTORY = Inflater::new;
	
	private static final Inflater DEFAULT_INFLATER = INFLATER_FACTORY.get();
//	private static final byte[] DEFAULT_INFLATE_CHUNK = new byte[8192];

	public static ByteBuffer getDataBuffer(ByteBuf buf) {
		ByteBuffer byteBuffer;
		// if it has an underlying direct buffer that we can get
		if (buf.nioBufferCount() > 0) {
			byteBuffer = buf.nioBuffer();
			buf.skipBytes(buf.readableBytes());
		} else {
			byteBuffer = ByteBuffer.allocateDirect(buf.readableBytes());
			buf.readBytes(byteBuffer);
			byteBuffer.flip();
		}
		return byteBuffer;
	}

	public static BlockRegistryRepresentative decodeCompressedBlockRegistryRepresentative(class_2540 buf) {
		int uncompressedSize = buf.method_10816();

		var inflater = DEFAULT_INFLATER;

		class_2540 uncompressedBuffer;
		
		ByteBuffer byteBuffer = getDataBuffer(buf);
		try {
			inflater.setInput(byteBuffer);
			
			ByteBuf outputBuf = buf.alloc().directBuffer(uncompressedSize);
			
			try {
				// inflate to outputBuf's direct buffer (for speed)
				ByteBuffer outputBuffer = outputBuf.internalNioBuffer(0, uncompressedSize);
				int initialPosition = outputBuffer.position();
				inflater.inflate(outputBuffer);
				// confirm sizes are equal
				int actualSize = outputBuffer.position() - initialPosition;
				if (actualSize != uncompressedSize) {
					throw new DecoderException("Badly compressed packet - actual length of uncompressed payload " + actualSize + " does not match declared size " + uncompressedSize);
				} else {
					// update outputBuf writing index to match the now-read packet
					outputBuf.writerIndex(outputBuf.writerIndex() + actualSize);
				}
			} catch (Exception err) {
				outputBuf.release();
				throw new RuntimeException(err);
			}
			
			uncompressedBuffer = new class_2540(outputBuf);
		} finally {
			inflater.reset();
		}
		
		return decodeBlockRegistryRepresentative(uncompressedBuffer);
	}
	
	// Legacy codecs

	public static final class_9139<class_2540, BlockRegistryRepresentative> LEGACY_REGISTRY_STREAM_CODEC = class_9139.<class_2540, BlockRegistryRepresentative>method_56437(IntermediaryCodecs::encodeBlockRegistryRepresentativeLegacy, IntermediaryCodecs::decodeBlockRegistryRepresentativeLegacy);

	public static void encodeBlockRegistryRepresentativeLegacy(class_2540 buf, BlockRegistryRepresentative registry) {
		final StateDefinitionRepresentative[] allBlocks = registry.allBlocks;
		
		final int totalStateCount = registry.allStates.length;
		final int totalBlockCount = allBlocks.length;
		// Write total state count
		buf.method_53002(totalStateCount);
		
		// Write total block count
		buf.method_53002(totalBlockCount);
		for(int blockIndex = 0; blockIndex < totalBlockCount; ++blockIndex) {
			final StateDefinitionRepresentative stateDef = allBlocks[blockIndex];
			// Write block name
			buf.method_44116((class_5321<class_2248>)stateDef.blockType.getKey());
			
			final List<PropertyRepresentative> properties = stateDef.blockType.getProperties();
			
			// Write property count
			buf.method_10804(properties.size());
			// Write all properties
			for(PropertyRepresentative property : properties) {
				PropertyRepresentative.STREAM_CODEC.encode(buf, property);
			}
			
			final BlockStateRepresentative[] stateBlocks = stateDef.states;
			// Write state count
			buf.method_10804(stateBlocks.length);
			// Write all states
			for(int stateIndex = 0; stateIndex < stateDef.stateCount; ++stateIndex) {
				final BlockStateRepresentative state = stateBlocks[stateIndex];
				final int globalIndex = stateDef.stateIndexes[stateIndex];
				
				// Write state's global index
				buf.method_10804(globalIndex);

				// Write state's properties
				for(int property = 0; property < properties.size(); ++property) {
					// Write values of all properties of the state
					buf.method_10814(state.getValue(property));
				}
			}
		}
		
	}

	public static BlockRegistryRepresentative decodeBlockRegistryRepresentativeLegacy(class_2540 buf) {
		final int totalStateCount = buf.readInt();
		final int totalBlockCount = buf.readInt();
		
		final IntermediaryBlockStateRepresentative[] allStates = new IntermediaryBlockStateRepresentative[totalStateCount];
		final StateDefinitionRepresentative[] allBlocks = new StateDefinitionRepresentative[totalBlockCount];

		for(int blockIndex = 0; blockIndex < totalBlockCount; ++blockIndex) {
			final class_5321<class_2248> blockType = buf.method_44112(class_7924.field_41254);
			
			final int propertyCount = buf.method_10816();
			final PropertyRepresentative[] properties = new PropertyRepresentative[propertyCount];
			for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
				properties[propertyIndex] = PropertyRepresentative.STREAM_CODEC.decode(buf);
			}
			
			BlockRepresentative<class_5321<class_2248>> block = new BlockRepresentative<class_5321<class_2248>>(blockType, properties);
			
			final int stateCount = buf.method_10816();
			final IntermediaryBlockStateRepresentative[] stateBlocks = new IntermediaryBlockStateRepresentative[stateCount];
			final int[] stateGlobalIndexes = new int[stateCount];
			for(int stateIndex = 0; stateIndex < stateCount; ++stateIndex) {
				final int globalIndex = buf.method_10816();
				
				final IntermediaryBlockStateRepresentative state = new IntermediaryBlockStateRepresentative(block);

				for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
					state.putValue(propertyIndex, buf.method_19772().intern());
				}
				
				allStates[globalIndex] = state;
				stateBlocks[stateIndex] = state;
				stateGlobalIndexes[stateIndex] = globalIndex;
			}
			
			allBlocks[blockIndex] = new StateDefinitionRepresentative(block, stateBlocks, stateGlobalIndexes);
		}
		
		return new BlockRegistryRepresentative(allBlocks, allStates);
	}

	
//	public static final StreamCodec<FriendlyByteBuf, IntermediaryBlockStateRepresentative> BLOCKSTATE_STREAM_CODEC = StreamCodec.<FriendlyByteBuf, IntermediaryBlockStateRepresentative>of(IntermediaryCodecs::writeBlockState, IntermediaryCodecs::readBlockState);
//
//	public static final StreamCodec<FriendlyByteBuf, IntermediaryBlockStateRepresentative[]> BLOCKSTATE_ARRAY_STREAM_CODEC = StreamCodec.<FriendlyByteBuf, IntermediaryBlockStateRepresentative[]>of(IntermediaryCodecs::writeBlockStateArray, IntermediaryCodecs::readBlockStateArray);
//
//	public static final void writeBlockState(FriendlyByteBuf buf, IntermediaryBlockStateRepresentative state) {
//		buf.writeResourceKey(state.getBlock());
//		Collection<PropertyRepresentative> properties = state.getProperties();
//		buf.writeVarInt(properties.size());
//		for(PropertyRepresentative property : properties) {
//			property.streamCodec().encode(buf, property);
//			buf.writeUtf(state.getValue(property));
//		}
//	}
//	
//	public static final IntermediaryBlockStateRepresentative readBlockState(FriendlyByteBuf buf) {
//		ResourceKey<Block> blockKey = buf.readResourceKey(Registries.BLOCK);
//		int propertyCount = buf.readVarInt();
//		
//		IntermediaryBlockStateRepresentative representative = new IntermediaryBlockStateRepresentative(blockKey, propertyCount);
//		
//		for(int i = 0; i < propertyCount; ++i) {
//			PropertyRepresentative property = PropertyRepresentative.STREAM_CODEC.decode(buf);
//			String value = buf.readUtf();
//			representative.putValue(property, value);
//		}
//		
//		return representative;
//	}
//	
//
//	public static final void writeBlockStateArray(FriendlyByteBuf buf, IntermediaryBlockStateRepresentative[] states) {
//		int size = states.length;
//		buf.writeInt(size);
//
//		// Collect blocks and states so they can be grouped efficiently
//		List<ResourceKey<Block>> blockKeysOrdered = new ArrayList<ResourceKey<Block>>();
//		Map<ResourceKey<Block>, List<IndexHolder<IntermediaryBlockStateRepresentative>>> blocks = new Object2ObjectArrayMap<>();
//		Map<ResourceKey<Block>, Set<PropertyRepresentative>> blockProperties = new Object2ObjectArrayMap<>();
//		
//		for(int i = 0; i < size; ++i) {
//			IntermediaryBlockStateRepresentative state = states[i];
//			ResourceKey<Block> key = state.getBlock();
//			if(!blocks.containsKey(key)) {
//				blockKeysOrdered.add(key);
//				blocks.put(key, new ArrayList<>());
//			}
//			blocks.get(key).add(new IndexHolder<IntermediaryBlockStateRepresentative>(i, state));
//			
//			Set<PropertyRepresentative> properties = blockProperties.computeIfAbsent(key, x -> new ObjectArraySet<>());
//			properties.addAll(state.getProperties());
//		}
//		
//		// Encode each block as a group
//		
//		buf.writeInt(blockKeysOrdered.size()); // Represented block count
//		for(ResourceKey<Block> block : blockKeysOrdered) {
//			// Write name
//			buf.writeResourceKey(block);
//
//			Set<PropertyRepresentative> properties = blockProperties.get(block);
//			PropertyRepresentative[] sortedProperties = properties.toArray(new PropertyRepresentative[0]);
//			Arrays.sort(sortedProperties, PropertyRepresentative::compare);
//			
//			// Write properties
//			buf.writeVarInt(sortedProperties.length);
//			for(PropertyRepresentative property : sortedProperties) {
//				property.streamCodec().encode(buf, property);
//			}
//
//			// Write blockstates and their indexes
//			List<IndexHolder<IntermediaryBlockStateRepresentative>> representatives = blocks.get(block);
//			
//			buf.writeVarInt(representatives.size());
//			for(IndexHolder<IntermediaryBlockStateRepresentative> holder : representatives) {
//				int index = holder.index();
//				buf.writeVarInt(index);
//				BlockStateRepresentative<ResourceKey<Block>> state = holder.state();
//				buf.writeVarInt(state.getPropertyCount());
//				for(PropertyRepresentative property : sortedProperties) {
//					buf.writeOptional(state.getValueOptional(property), ByteBufCodecs.STRING_UTF8);
//				}
//			}
//		}
//		
//	}
//	
//	public static final IntermediaryBlockStateRepresentative[] readBlockStateArray(FriendlyByteBuf buf) {
//		final int size = buf.readInt();
//		IntermediaryBlockStateRepresentative[] array = new IntermediaryBlockStateRepresentative[size];
//		
//		final int representedBlockCount = buf.readInt();
//		for(int blockIndex = 0; blockIndex < representedBlockCount; ++blockIndex) {
//			ResourceKey<Block> blockKey = buf.readResourceKey(Registries.BLOCK);
//			
//			final int propertyCount = buf.readVarInt();
//			final PropertyRepresentative[] sortedProperties = new PropertyRepresentative[propertyCount];
//			for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
//				sortedProperties[propertyIndex] = PropertyRepresentative.STREAM_CODEC.decode(buf);
//			}
//			
//			final int stateCount = buf.readVarInt();
//			for(int relativeStateIndex = 0; relativeStateIndex < stateCount; ++relativeStateIndex) {
//				final int index = buf.readVarInt();
//				final int statePropertyCount = buf.readVarInt();
//				
//				IntermediaryBlockStateRepresentative state = new IntermediaryBlockStateRepresentative(blockKey, statePropertyCount);
//				
//				for(int propertyIndex = 0; propertyIndex < propertyCount; ++propertyIndex) {
//					Optional<String> propertyValue = buf.readOptional(ByteBufCodecs.STRING_UTF8);
//					if(propertyValue.isPresent()) {
//						state.putValue(sortedProperties[propertyIndex], propertyValue.get());
//					}
//				}
//				
//				array[index] = state;
//			}
//		}
//		
//		return array;
//	}
	
}
