package com.joshiegemfinder.synchronisedblockstates.intermediary.util;

import java.util.Arrays;
import net.minecraft.class_2361;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;

public class RemappedIdMapper<T> extends class_2361<T> {

//	protected final IdMapper<T> sourceMapper;

	protected int currentCapacity;
	protected int[] forwardMappings;
	protected Int2IntLinkedOpenHashMap backwardsMappings;

	public final boolean hasNoMapping(int index) {
		return forwardMappings[index] == 0;
	}
	
	public final int getForwardMapping(int index) {
		return forwardMappings[index] - 1;
	}
	
	public final int getBackwardsMapping(int index) {
		return backwardsMappings.getOrDefault(index, index);
	}

	// index - client mapping, value - server mapping
	public final void setMapping(int index, int value) {
		forwardMappings[index] = value + 1;
		this.backwardsMappings.put(index, value);
	}
	
	public RemappedIdMapper(class_2361<T> originalMapper) {
		this(originalMapper.method_10204());
		originalMapper.forEach((t) -> {
			this.method_10203(t, originalMapper.method_10206(t));
		});
		
	}

	public RemappedIdMapper(int size) {
		this.currentCapacity = size;
		this.forwardMappings = new int[size];
		this.backwardsMappings = new Int2IntLinkedOpenHashMap(size);
	}
	
	// ---- Remapped Methods ----
	
	@Override
	public void method_10203(T object, int i) {
		if(i >= currentCapacity) {
			this.forwardMappings = Arrays.copyOf(forwardMappings, Math.max(currentCapacity * 2, i));
			setMapping(i, i);
			super.method_10203(object, i);
		} else if(hasNoMapping(i)) {
			setMapping(i, i);
			super.method_10203(object, i);
		} else {
			super.method_10203(object, this.forwardMappings[i]);
		}
	}
	
	// ---- Raw Methods ----
	
	public void addMappingRaw(T object, int i) {
		super.method_10203(object, i);
	}

//	@Nullable
//	public T byIdRaw(int i) {
//		return super.byId(i);
//	}
}
