package com.joshiegemfinder.synchronisedblockstates.intermediary.util;

import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.minecraft.class_2361;

public class RemappedProxyIdMapper<T> extends class_2361<T> {

	/**
	 * When returned from a {@link MappingProvider}, the value will not be added to the mapper
	 */
	public static final int NO_VALUE_INDEX = -1;
	
	@FunctionalInterface
	public static interface MappingProvider<T> {
		/**
		 * Remap the object with the original index to a different index</br>
		 * Returning {@link RemappedProxyIdMapper#NO_VALUE_INDEX} will hide it from the mapper, as if it had never been added
		 * @param originalIndex The original index of the value
		 * @param object The value to be added
		 * @return The new index, or {@link RemappedProxyIdMapper#NO_VALUE_INDEX} to cancel it being added to the proxy
		 */
		public int getMappedIndex(int originalIndex, T object);
	}
	
	protected final class_2361<T> originalMapper;
	protected final MappingProvider<T> mappingProvider;

	// TODO: Move to IntList!!!! Maps are WAY TOO SLOW!!!!
	protected Int2IntMap originalIdToMappedId;
	protected Int2IntMap mappedIdToOriginalId;

	public RemappedProxyIdMapper(class_2361<T> originalMapper, MappingProvider<T> mappingProvider) {
		this(originalMapper.method_10204(), originalMapper, mappingProvider);
	}
	
	public RemappedProxyIdMapper(int initialSize, class_2361<T> originalMapper, MappingProvider<T> mappingProvider) {
		this(initialSize, originalMapper, mappingProvider, true);
	}
	
	public RemappedProxyIdMapper(int initialSize, class_2361<T> originalMapper, MappingProvider<T> mappingProvider, boolean initialize) {
		super(initialSize);
		this.originalMapper = originalMapper;
		this.mappingProvider = mappingProvider;

		this.originalIdToMappedId = new Int2IntAVLTreeMap();//new Int2IntArrayMap(initialSize);
		this.mappedIdToOriginalId = new Int2IntAVLTreeMap();//new Int2IntArrayMap(initialSize);
		mappedIdToOriginalId.defaultReturnValue(NO_VALUE_INDEX);

		if(initialize)
			for(var entry : originalMapper.field_11100.reference2IntEntrySet()) {
				this.addMappedMapping(entry.getKey(), entry.getIntValue());
			}
	}
	
	public class_2361<T> getOriginalMapper() {
		return this.originalMapper;
	}
	
	protected int mapped(int originalIndex, T object) {
		int mappedIndex = this.mappingProvider.getMappedIndex(originalIndex, object);
		this.setMapping(originalIndex, mappedIndex);
		return mappedIndex;
	}
	
	public int setMapping(int originalIndex, int mappedIndex) {
		originalIdToMappedId.put(originalIndex, mappedIndex);
		
		if(mappedIndex != NO_VALUE_INDEX)
			mappedIdToOriginalId.put(mappedIndex, originalIndex);
		return mappedIndex;
	}

	@Override
	public void method_10203(final T object, final int i) {
		getOriginalMapper().method_10203(object, i);
		this.addMappedMapping(object, i);
	}

	public void addMappedMapping(final T object, final int i) {
		final int mappedIndex = mapped(i, object);
		if(mappedIndex != NO_VALUE_INDEX)
			this.addMappingRaw(object, mappedIndex);
	}
	
	public void addMappingRaw(final T object, final int i) {
		super.method_10203(object, i);
	}

	@Override
	public void method_10205(T object) {
		// We add mappings based off of the original mapper's ids
		this.method_10203(object, getOriginalMapper().field_11099);
		// Alternatively:
//		getOriginalMapper().add(object);
//		final int mappedIndex = mapped(getOriginalMapper().getId(object), object);
//		if(mappedIndex != NO_VALUE_INDEX)
//			this.addMappingRaw(object, mappedIndex);
	}

	public void addRaw(T object) {
		super.method_10205(object);
	}
	
}
