package com.joshiegemfinder.synchronisedblockstates.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.google.common.collect.Lists;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;

@SuppressWarnings({"unchecked", "rawtypes"})
public class BlockRegistryRepresentative {

	
	public final StateDefinitionRepresentative[] allBlocks;
	public final BlockStateRepresentative[] allStates;
	
	public BlockRegistryRepresentative(StateDefinitionRepresentative[] allBlocks, BlockStateRepresentative[] allStates) {
		this.allBlocks = allBlocks;
		this.allStates = allStates;
	}
	
	
	public static BlockRegistryRepresentative fromStates(BlockStateRepresentative[] states) {
		final int size = states.length;
		List<BlockRepresentative> blockKeysOrdered = new ArrayList<BlockRepresentative>();
		Map<BlockRepresentative, List<IndexHolder>> blocks = new Object2ObjectArrayMap<>();

		BlockRepresentative prevBlock = null;
		List<IndexHolder> prevBlockList = null;
		
		for(int i = 0; i < size; ++i) {
			BlockStateRepresentative state = states[i];
			BlockRepresentative block = state.getBlock();
			
			final List<IndexHolder> blockList;
			
			if(Objects.equals(block, prevBlock)) {
				blockList = prevBlockList;
			} else {
				blockList = blocks.computeIfAbsent(block, (key) -> {
					blockKeysOrdered.add(key);
					return Lists.newArrayList();
				});
			}
			
			blockList.add(new IndexHolder(i, state));
			
			prevBlock = block;
			prevBlockList = blockList;
		}

		StateDefinitionRepresentative[] definitions = new StateDefinitionRepresentative[blockKeysOrdered.size()];
		
		for(int i = 0; i < blockKeysOrdered.size(); ++i) {
			BlockRepresentative block = blockKeysOrdered.get(i);
			
			// Write blockstates and their indexes
			List<IndexHolder> representatives = blocks.get(block);
			StateDefinitionRepresentative blockRepresentative = new StateDefinitionRepresentative(block, representatives.toArray(new IndexHolder[0]));
			definitions[i] = blockRepresentative;
		}
		
		return new BlockRegistryRepresentative(definitions, states);
	}
}
