package com.joshiegemfinder.synchronisedblockstates.common.util;

public abstract class BlockStateRepresentative {
	protected final BlockRepresentative<?> block;
	// property names and values can always be turned into strings and back
	protected final String[] properties;
	
//	protected final int index;
	
	public BlockStateRepresentative(BlockRepresentative<?> block) {
		this.block = block;
		this.properties = new String[block.getPropertyCount()];
	}

	public BlockRepresentative<?> getBlock() {
		return this.block;
	}

	public int getIndex(PropertyRepresentative property) {
		return this.getBlock().getPropertyIndex(property);
	}
	
	public String getValue(int index) {
		return this.properties[index];
	}
	
//	public String getValue(PropertyRepresentative property) {
//		return this.getValue(this.getIndex(property));
//	}
	
//	public Optional<String> getValueOptional(PropertyRepresentative property) {
//		int index = this.getIndex(property);
//		if(0 <= index && index < this.properties.length) {
//			return Optional.of(this.getValue(index));
//		} else {
//			return Optional.empty();
//		}
//	}

	public void putValue(int index, String string) {
		this.properties[index] = string;
	}
	
//	public void putValue(PropertyRepresentative property, String string) {
//		this.putValue(this.getIndex(property), string);
//	}
	
	public abstract BlockStateRepresentative withBlock(BlockRepresentative<?> newBlock);
	
	public BlockStateRepresentative reorderFor(BlockRepresentative<?> newBlock) {
		int[] remapping = this.getBlock().createReorderMapping(newBlock);
		if(remapping == null) {
			return null;
		} else {
			BlockStateRepresentative newState = withBlock(newBlock);
			for(int i = 0; i < remapping.length; ++i) {
				int index = remapping[i];
				newState.putValue(index, this.getValue(index));
			}
			return newState;
		}
	}
	
	@Override
	public int hashCode() {
		return block.hashCode();
	}
	
	@Override
	public boolean equals(Object object) {
		if(this == object) {
			return true;
		} else if(object instanceof BlockStateRepresentative other) {
			final BlockRepresentative<?> block = this.getBlock();
			if(!block.equals(other.getBlock())) {
				return false;
			}

			final int propertyCount = this.getBlock().getPropertyCount();
			
			for(int i = 0; i < propertyCount; ++i) {
				if(!this.getValue(i).equals(other.getValue(i))) {
					return false;
				}
			}
			
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		
		builder.append(this.getBlock().asString());
		builder.append('[');
		final BlockRepresentative<?> block = this.getBlock();
		final int propertyCount = block.getPropertyCount();
		for(int i = 0; i < propertyCount; ++i) {
			builder.append(block.getProperty(i).getName());
			builder.append('=');
			builder.append(this.getValue(i));
			if(i != propertyCount - 1)
				builder.append(',');
		}
		builder.append(']');
		
		return builder.toString();
	}
	
	public abstract boolean represents(Object state);
	
}
