package com.joshiegemfinder.synchronisedblockstates.common.util;

import java.util.Objects;

import org.jetbrains.annotations.Nullable;

public record ClassRepresentative(String className, @Nullable Class<?> clazz) {
	
	public String getClassName() {
		return clazz != null ? clazz.getName() : className;
	}

	public boolean represents(Class<?> valueClass) {
		return valueClass != null && (clazz != null ? clazz.equals(valueClass) : this.className().equals(valueClass.getName()));
	}
	
	@Override
	public final int hashCode() {
		return this.getClassName().hashCode();
	}
	
	@Override
	public final boolean equals(Object arg0) {
		if(this == arg0) {
			return true;
		} else {
			return (arg0 instanceof ClassRepresentative that) ? this.getClassName().equals(that.getClassName()) : false;
		}
	}

	public static ClassRepresentative of(String className, ClassLoader loader) {
		Class<?> clazz = null;
        try {
        	clazz = Class.forName(className, false, loader);
        } catch(ClassNotFoundException exception) {
        	try {
            	clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        	} catch(ClassNotFoundException exception2) {
        		clazz = null;
        	}
        } catch(SecurityException exception) {
        	try {
				clazz = Class.forName(className);
			} catch (ClassNotFoundException e) {
	        	clazz = null;
			}
        }

    	return new ClassRepresentative(clazz != null ? clazz.getName() : className, clazz);
	}

	public static ClassRepresentative of(String className) {
        return of(className, ClassLoader.getSystemClassLoader());
	}

	public static ClassRepresentative of(Class<?> clazz) {
		Objects.requireNonNull(clazz);
		return new ClassRepresentative(clazz.getName(), clazz);
	}
}
