package com.joshiegemfinder.synchronisedblockstates.common.util;

import net.minecraft.class_2540;
import net.minecraft.class_2769;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PropertyRepresentative(String name, ClassRepresentative clazz) {

	public static int compare(PropertyRepresentative property1, PropertyRepresentative property2) { //names should never be equal
		return property1.getName().compareToIgnoreCase(property2.getName());
	}

	public static int compare(class_2769<?> property1, class_2769<?> property2) { //names should never be equal
		return property1.method_11899().compareToIgnoreCase(property2.method_11899());
	}
	
	public static final class_9139<class_2540, PropertyRepresentative> STREAM_CODEC = class_9139.method_56435(
			class_9135.field_48554, PropertyRepresentative::name,
			class_9135.field_48554, PropertyRepresentative::getPropertyClassName,
			PropertyRepresentative::new
		);
	
	public PropertyRepresentative(String name, String className) {
		this(name, ClassRepresentative.of(className, PropertyRepresentative.class.getClassLoader()));
	}
	
	public PropertyRepresentative(String name, Class<?> clazz) {
		this(name, ClassRepresentative.of(clazz));
	}
	
	public class_9139<class_2540, PropertyRepresentative> streamCodec() {
		return STREAM_CODEC;
	}
	
	public String getName() {
		return this.name();
	}
	
	public String getPropertyName() {
		return this.name();
	}
	
	public String getPropertyClassName() {
		return this.clazz().getClassName();
	}

	public boolean represents(class_2769<?> property) {
		return this.name().equals(property.method_11899()) && this.clazz().represents(property.method_11902());
	}
	
	
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		} else if(!(object instanceof PropertyRepresentative property)) {
			return false;
		} else {
			return this.clazz.equals(property.clazz) && this.name.equals(property.name);
		}
	}

	public int hashCode() {
		return 31 * this.clazz.hashCode() + this.name.hashCode();
	}

	public static PropertyRepresentative of(class_2769<?> property) {
		return new PropertyRepresentative(property.method_11899(), property.method_11902());
	}
}
