package com.joshiegemfinder.synchronisedblockstates.intermediary.fabric;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

import com.google.common.collect.Sets;
import com.joshiegemfinder.synchronisedblockstates.common.ClientAckResponse;
import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockRegistryRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.BlockStateRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.IndexHolder;
import com.joshiegemfinder.synchronisedblockstates.common.util.MappingSafeResourceKeyHelper;
import com.joshiegemfinder.synchronisedblockstates.common.util.PropertyRepresentative;
import com.joshiegemfinder.synchronisedblockstates.common.util.StateDefinitionRepresentative;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.SynchronisedBlockstatesNetwork;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundSynchroniseBlockstatesPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ServerboundAckPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.util.BlockInfoWrapper;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.util.BlockInfoWrapperServer;
import com.joshiegemfinder.synchronisedblockstates.intermediary.util.IntermediaryBlockStateRepresentative;
import com.joshiegemfinder.synchronisedblockstates.intermediary.util.IntermediaryCodecs;
import com.joshiegemfinder.synchronisedblockstates.intermediary.util.ProxyIdMapper;
import com.joshiegemfinder.synchronisedblockstates.intermediary.util.RemappedProxyIdMapper;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2361;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_7923;
import net.minecraft.class_8674;

public class SynchronisedBlockstatesClient implements ClientModInitializer {

	public static boolean didRecieveBlockstatesFromServer = false;
	
	@Override
	public void onInitializeClient() {
//		SynchronisedBlockstatesNetwork.registerPackets();

//		SynchronisedBlockstates.LOGGER.info("Block.BLOCK_STATE_REGISTRY: {} [is proxy: {}]", Block.BLOCK_STATE_REGISTRY, Block.BLOCK_STATE_REGISTRY instanceof ProxyIdMapper<BlockState>);
		
//		{
//			int size = Block.BLOCK_STATE_REGISTRY.size();
//			
////			BlockStateRepresentative[] states = new BlockStateRepresentative[size];
////			
////			for(int i = 0; i < size; ++i) {
////				BlockState state = Block.stateById(i);
////				states[i] = new BlockStateRepresentative(state);
////			}
////			
////			final BlockRegistryRepresentative stateRegistry = BlockRegistryRepresentative.fromStates(states);
//
//			List<BlockInfoWrapperServer> blocksOrdered = new ArrayList<BlockInfoWrapperServer>(BuiltInRegistries.BLOCK.size());
//			Map<Block, BlockInfoWrapperServer> blocks = new Reference2ObjectOpenHashMap<>(BuiltInRegistries.BLOCK.size());
//
//			{
//				// cache last key to speed up indexing
//				Block prevKey = null;
//				BlockInfoWrapperServer prevValue = null;
//				for(int i = 0; i < size; ++i) {
//					BlockState blockState = Block.stateById(i);
//					Block block = blockState.getBlock();
//					
//					final BlockInfoWrapperServer blockInfo;
//					
//					if(block == prevKey) {
//						blockInfo = prevValue;
//					} else {
//						blockInfo = blocks.computeIfAbsent(block, (key) -> {
//							BlockInfoWrapperServer value = new BlockInfoWrapperServer(key);
//							blocksOrdered.add(value);
//							return value;
//						});
//					}
//					
//					blockInfo.acceptBlockState(i, blockState);
//					
//					prevKey = block;
//					prevValue = blockInfo;
//				}
//			}
//			
//			File file = new File(Minecraft.getInstance().gameDirectory, "vanillablockstates.dat");
//			try {
//				FileOutputStream stream = new FileOutputStream(file);
//				DataOutputStream output = new DataOutputStream(stream);
//				
//				FriendlyByteBuf buf = PacketByteBufs.create();
//				
////				BlockRegistryRepresentative.STREAM_CODEC.encode(buf, stateRegistry);
//				BlockInfoWrapper.ARRAY_STREAM_CODEC.encode(buf, blocksOrdered.toArray(new BlockInfoWrapper[0]));
//				
////				stream.write(Arrays.copyOfRange(bytes, startingIndex, endingIndex));
//				ByteBuf read = buf.resetReaderIndex();
//				read.readBytes(output, read.readableBytes());
//				output.close();
//			} catch (IOException e) {
//				e.printStackTrace();
//			}
//		}
		
		{
			final var oldFunction = MappingSafeResourceKeyHelper.keyAsString;
			MappingSafeResourceKeyHelper.keyAsString = (key) -> {
				if(key instanceof class_5321<?> resourceKey) {
					return resourceKey.method_29177().toString();
				} else {
					return oldFunction.apply(key);
				}
			};
		}

		
		SynchronisedBlockstatesNetwork.registerClient();
		
		ClientConfigurationConnectionEvents.INIT.register((class_8674 handler, class_310 client) -> {
			// TODO write a better workaround, because polymer makes this necessary
			restoreToOriginalBlockStateRegistry();
			
			didRecieveBlockstatesFromServer = false;
		});

		ClientConfigurationConnectionEvents.COMPLETE.register((class_8674 handler, class_310 client) -> {
			if(!didRecieveBlockstatesFromServer) {
				SynchronisedBlockstates.LOGGER.info("Didn't receive a blockstate packet from the server, falling back to vanilla blockstates");
				long start = System.nanoTime();
//				BlockStateRepresentative[] vanillaStates = readVanillaBlockStates();
				BlockRegistryRepresentative vanillaRegistry = readVanillaBlockStates();
				long end = System.nanoTime();
				SynchronisedBlockstates.LOGGER.info("Reading vanilla blockstates from file took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(end - start, TimeUnit.NANOSECONDS), end - start);
//				SynchronisedBlockstates.LOGGER.info("Didn't receive a blockstate packet from the server, assuming vanilla blockstates: {}", Arrays.toString(vanillaStates));
				if(vanillaRegistry == null)
					return;
				SynchronisedBlockstates.LOGGER.info("Getting original state registry");
				start = System.nanoTime();
				class_2361<class_2680> currentMapper = getCurrentBlockStateRegistry();
				end = System.nanoTime();
				SynchronisedBlockstates.LOGGER.info("Getting original state registry took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(end - start, TimeUnit.NANOSECONDS), end - start);

				SynchronisedBlockstates.LOGGER.info("Starting check states are okay");
				start = System.nanoTime();
				boolean areAllStatesOkay = areAllStatesOkay(currentMapper, vanillaRegistry.allStates);
				end = System.nanoTime();
				SynchronisedBlockstates.LOGGER.info("State check took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(end - start, TimeUnit.NANOSECONDS), end - start);

				if(!areAllStatesOkay && isUsingCustomBlockStateRegistry()) {
					currentMapper = restoreToOriginalBlockStateRegistry();
					areAllStatesOkay = areAllStatesOkay(currentMapper, vanillaRegistry.allStates);
				}
				
				if(!areAllStatesOkay) {
//					SynchronisedBlockstates.LOGGER.info("Converting vanilla blockstates to state registry");
//					start = System.nanoTime();
//					final BlockRegistryRepresentative blockstateRegistry = BlockRegistryRepresentative.fromStates(vanillaStates);
//					end = System.nanoTime();
//					SynchronisedBlockstates.LOGGER.info("Converting vanilla blockstates to state registry took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(end - start, TimeUnit.NANOSECONDS), end - start);

					SynchronisedBlockstates.LOGGER.info("Remapping modded states to vanilla states");
					start = System.nanoTime();
					remapAllBlockStates(currentMapper, vanillaRegistry, client);
					end = System.nanoTime();
					SynchronisedBlockstates.LOGGER.info("State remap took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(end - start, TimeUnit.NANOSECONDS), end - start);
				}
			}
		});
		
		ClientPlayConnectionEvents.DISCONNECT.register((class_634 handler, class_310 client) -> {
			restoreToOriginalBlockStateRegistry();
		});
	}
	
	public static ProxyIdMapper<class_2680> getProxyMapper() {
		return (ProxyIdMapper<class_2680>)class_2248.field_10651;
	}

	public static class_2361<class_2680> getMapper(class_2361<class_2680> mapper) {
		return getProxyMapper().getSourceMapper();
	}
	
	public static void setMapper(class_2361<class_2680> mapper) {
		getProxyMapper().setSourceMapper(mapper);
	}
	
	public static boolean isUsingCustomBlockStateRegistry() {
		return !(getProxyMapper().getSourceMapper() instanceof RemappedProxyIdMapper<class_2680>);
	}

	public static class_2361<class_2680> getCurrentBlockStateRegistry() {
		return getProxyMapper().getSourceMapper();
	}

	public static class_2361<class_2680> getOriginalBlockStateRegistry() {
		class_2361<class_2680> blockstateMapper = getProxyMapper().getSourceMapper();
		
		while(blockstateMapper instanceof RemappedProxyIdMapper<class_2680> proxy) {
			blockstateMapper = proxy.getOriginalMapper();
		}
		
		return blockstateMapper;
	}

	public static class_2361<class_2680> restoreToOriginalBlockStateRegistry() {
		class_2361<class_2680> originalMapper = getOriginalBlockStateRegistry();
		getProxyMapper().setSourceMapper(originalMapper);
		return originalMapper;
	}
	

	// Moved out of the packet classes because spigot
	public static void handleRecieveSynchroniseBlockstatesPacket(ClientboundSynchroniseBlockstatesPacket packet, ClientConfigurationNetworking.Context context) {
		handleRecieveBlockstates(packet.stateRegistry(), context);
	}

	public static void handleRecieveBlockstates(final BlockRegistryRepresentative stateRegistry, ClientConfigurationNetworking.Context context) {
		
		didRecieveBlockstatesFromServer = true;
		
		if(context.client().method_47392()) {
			restoreToOriginalBlockStateRegistry();
			context.responseSender().sendPacket(new ServerboundAckPacket(ClientAckResponse.OK));
			return;
		}
		
		context.client().execute(() -> {
			// Test current mapper
			class_2361<class_2680> currentMapper = getCurrentBlockStateRegistry();
			
			final BlockStateRepresentative[] blockstates = stateRegistry.allStates;
			
			remap: {
				if(SynchronisedBlockstatesClient.areAllStatesOkay(currentMapper, blockstates)) {
					context.responseSender().sendPacket(new ServerboundAckPacket(ClientAckResponse.OK));
					break remap;
				}
				
				if(isUsingCustomBlockStateRegistry()) {
					currentMapper = getOriginalBlockStateRegistry();
					if(SynchronisedBlockstatesClient.areAllStatesOkay(currentMapper, blockstates)) {
						setMapper(currentMapper);
						context.responseSender().sendPacket(new ServerboundAckPacket(ClientAckResponse.OK));
						break remap;
					}
				}
				
				SynchronisedBlockstatesClient.remapAllBlockStatesAndThenProgress(currentMapper, stateRegistry, context.client(), context.networkHandler(), context.responseSender());
			}
		});
		
	}
	
	public static BlockRegistryRepresentative readVanillaBlockStates() {
		try {
			byte[] bytes = IOUtils.resourceToByteArray("vanillablockstates.dat", Thread.currentThread().getContextClassLoader());
			class_2540 buf = PacketByteBufs.create();
			buf.method_52983(bytes);
			
			BlockInfoWrapper[] wrappers = BlockInfoWrapper.ARRAY_STREAM_CODEC.decode(buf);

			StateDefinitionRepresentative[] allBlocks = new StateDefinitionRepresentative[wrappers.length];
			int stateCount = 0;
			for(int i = 0; i < wrappers.length; ++i) {
				StateDefinitionRepresentative block = wrappers[i].toStateDefinitionRepresentative();
				allBlocks[i] = block;
				stateCount += block.stateCount;
			}
			
			BlockStateRepresentative[] allStates = new BlockStateRepresentative[stateCount];
			
			int stateIndex = 0;
			for(int i = 0; i < allBlocks.length; ++i) {
				StateDefinitionRepresentative block = allBlocks[i];
				System.arraycopy(block.states, 0, allStates, stateIndex, block.stateCount);
				stateIndex += block.stateCount;
			}
			
			return new BlockRegistryRepresentative(allBlocks, allStates);
		} catch (IOException e) {
			return null;
		}
	}
	
	
	public static boolean areAllStatesOkay(class_2361<class_2680> clientStateMapper, final BlockStateRepresentative[] serverStateList) {

		int serverStateCount = serverStateList.length;
		int clientStateCount = clientStateMapper.method_10204();
		
		if(serverStateCount != clientStateCount) {
			SynchronisedBlockstates.LOGGER.info("Mismatched size of server and client states [{} server, {} client]", serverStateCount, clientStateCount);
			return false;
		}
		
		for(int i = 0; i < serverStateList.length; ++i) {
			class_2680 realState = clientStateMapper.method_10200(i);
			BlockStateRepresentative serverState = serverStateList[i];
			if(!serverState.represents(realState)) {
				SynchronisedBlockstates.LOGGER.info("[Id {}] Server state {} doesn't match client state {}", i, realState, serverState.toString());
				return false;
			}
			if(i % 1000 == 0) {
				SynchronisedBlockstates.LOGGER.info("Synchronizing {} / {}", i, serverStateList.length);
			}
		}
		
		SynchronisedBlockstates.LOGGER.info("Synchronizing {} / {}", serverStateList.length, serverStateList.length);

		SynchronisedBlockstates.LOGGER.info("Finished validating blockstates!");
		return true;
		
	}
	
	public static class RemapInfo {
		public boolean clientHasMissingBlocks = false;
		public boolean serverHasMissingBlocks = false;
		public boolean clientHasMissingProperties = false;
		public boolean serverHasMissingProperties = false;
		
		public class_2361<class_2680> clientStateList;
		public BlockStateRepresentative[] serverStateList;
		
		public void markClientHasMissingBlocks() { clientHasMissingBlocks = true; }
		public void markServerHasMissingBlocks() { serverHasMissingBlocks = true; }
		public void markClientHasMissingProperties() { clientHasMissingProperties = true; }
		public void markServerHasMissingProperties() { serverHasMissingProperties = true; }
	}
	
	public static class BlockInfo {
		public final class_5321<class_2248> resourceKey;
		
		public BlockInfo(class_5321<class_2248> resourceKey) {
			this.resourceKey = resourceKey;
		}
		
		public boolean existsOnClient = false;
		public boolean existsOnServer = false;
		
		public List<IndexHolder<class_2680>> clientStates = new ObjectArrayList<>();
		public List<IndexHolder<IntermediaryBlockStateRepresentative>> serverStates = new ObjectArrayList<>();

		public Set<PropertyRepresentative> clientProperties = new ObjectArraySet<>();
		public Set<PropertyRepresentative> serverProperties = new ObjectArraySet<>();
		
		public void addClientState(int i, class_2680 state) {
			this.clientStates.add(new IndexHolder<class_2680>(i, state));
			this.existsOnClient = true;
//			clientProperties.addAll(state.getProperties().stream().map(PropertyRepresentative::of).toList());
		}

		public void addServerState(int i, IntermediaryBlockStateRepresentative state) {
			this.serverStates.add(new IndexHolder<IntermediaryBlockStateRepresentative>(i, state));
			this.existsOnServer = true;
//			serverProperties.addAll(state.getProperties());
		}
		
		public static BlockInfo onClient(class_5321<class_2248> resourceKey) {
			BlockInfo blockInfo = new BlockInfo(resourceKey);
			blockInfo.existsOnClient = true;
			class_2248 block = class_7923.field_41175.method_31189(resourceKey).orElseThrow();
			block.method_9595().method_11659().stream().map(PropertyRepresentative::of).forEach(blockInfo.clientProperties::add);
			blockInfo.serverProperties.addAll(blockInfo.clientProperties); // TODO remove, debugging
			return blockInfo;
		}
	}
	
	public static void analyzeBlockInfo(BlockInfo info, RemapInfo remapInfo, Int2IntArrayMap mappings) {
		if(!info.existsOnClient) {
			remapInfo.markClientHasMissingBlocks();
			SynchronisedBlockstates.LOGGER.info("Block {} is missing on client", info.resourceKey.method_29177());
			// TODO deferred mappings?
		} else if(!info.existsOnServer) {
			remapInfo.markServerHasMissingBlocks();
//			SynchronisedBlockstates.LOGGER.info("Block {} is missing on server", info.resourceKey.location());
			for(var state : info.clientStates) {
				mappings.put(state.index(), RemappedProxyIdMapper.NO_VALUE_INDEX);
			}
		} else {
			final boolean clientPropertiesAreSupersetOfServerProperties = info.clientProperties.containsAll(info.serverProperties);
			final boolean serverPropertiesAreSupersetOfClientProperties = info.serverProperties.containsAll(info.clientProperties);

			final boolean isServerMissingProperties = !clientPropertiesAreSupersetOfServerProperties;
			final boolean isClientMissingProperties = !serverPropertiesAreSupersetOfClientProperties;
//			final boolean isServerMissingProperties = false;
//			final boolean isClientMissingProperties = false;
			
			if(isServerMissingProperties) {
				remapInfo.markServerHasMissingProperties();
				
				Set<PropertyRepresentative> missingProperties = new ObjectArraySet<>(info.clientProperties);
				missingProperties.removeAll(info.serverProperties);
				SynchronisedBlockstates.LOGGER.info("Block {} is missing properties on server: {}", info.resourceKey.method_29177(), missingProperties);
			}
			if(isClientMissingProperties) {
				remapInfo.markClientHasMissingProperties();
				
				Set<PropertyRepresentative> missingProperties = new ObjectArraySet<>(info.serverProperties);
				missingProperties.removeAll(info.clientProperties);
				SynchronisedBlockstates.LOGGER.info("Block {} is missing properties on client: {}", info.resourceKey.method_29177(), missingProperties);
			}
			
			if(!isServerMissingProperties && !isClientMissingProperties) {
//				List<IndexHolder<BlockState>> clientStatesClone = new LinkedList<>(info.clientStates);
//				List<IndexHolder<IntermediaryBlockStateRepresentative>> serverStatesClone = new LinkedList<>(info.serverStates);
//
//				Iterator<IndexHolder<BlockState>> clientIterator = clientStatesClone.iterator();
//				Iterator<IndexHolder<IntermediaryBlockStateRepresentative>> serverIterator;
//				client: while(clientIterator.hasNext()) {
//					IndexHolder<BlockState> client = clientIterator.next();
//					
//					BlockState clientState = client.state();
//					
//					serverIterator = serverStatesClone.iterator();
//					while(serverIterator.hasNext()) {
//						IndexHolder<IntermediaryBlockStateRepresentative> server = serverIterator.next();
//						
//						BlockStateRepresentative serverState = server.state();
//						
//						if(serverState.represents(clientState)) {
//							mappings.put(client.index(), server.index());
//							clientIterator.remove();
//							serverIterator.remove();
//							continue client;
//						}
//					}
//				}
//				
//				if(!(clientStatesClone.isEmpty() && serverStatesClone.isEmpty())) {
//					SynchronisedBlockstates.LOGGER.info("Block {} is not okay! Remaining states {} {}", info.resourceKey.location(), clientStatesClone, serverStatesClone);
//				}

//				IdMapper<BlockState> clientStateList = remapInfo.clientStateList;
//
//				Block block = BuiltInRegistries.BLOCK.getOptional(info.resourceKey).orElseThrow();
//				StateDefinition<Block, BlockState> stateDefinition = block.getStateDefinition();
//				for(IndexHolder<IntermediaryBlockStateRepresentative> holder : info.serverStates) {
//					BlockStateRepresentative state = holder.state();
//					BlockState clientstate = block.defaultBlockState();
//					
//					for(PropertyRepresentative property : state.getProperties()) {
//						Property<?> prop = stateDefinition.getProperty(property.getName());
//						clientstate = setPropertyValueFromValueName(clientstate, prop, state.getValue(property));
//					}
//					
////					SynchronisedBlockstates.LOGGER.info("Remapping {}/{} id [{} -> {}]", state, clientstate, clientStateList.getId(clientstate), holder.index());
//					
//					mappings.put(clientStateList.getId(clientstate), holder.index());
//				}
				
			} else if(isServerMissingProperties && !isClientMissingProperties) {
				class_2248 block = class_7923.field_41175.method_31189(info.resourceKey).orElseThrow();
				class_2689<class_2248, class_2680> stateDefinition = block.method_9595();
				
				Set<PropertyRepresentative> missingPropertySet = new ObjectArraySet<>(info.clientProperties);
				missingPropertySet.removeAll(info.serverProperties);
				class_2769<?>[] missingProperties = (class_2769<?>[])missingPropertySet.stream().map(x -> stateDefinition.method_11663(x.getName())).toArray();
				Arrays.sort(missingProperties, PropertyRepresentative::compare);
				
				PropertyValueTree propertyAssigner = new PropertyValueTree(missingProperties);
				
				stateDefinition.method_11662();
				
				class_2361<class_2680> clientStateList = remapInfo.clientStateList;
				
				for(IndexHolder<IntermediaryBlockStateRepresentative> holder : info.serverStates) {
					BlockStateRepresentative state = holder.state();
					BlockRepresentative<?> remoteBlock = state.getBlock();
					
					class_2680 clientstate = block.method_9564();
					for(int i = 0; i < remoteBlock.getPropertyCount(); ++i) {
						var property = remoteBlock.getProperty(i);
						class_2769<?> prop = stateDefinition.method_11663(property.getName());
						clientstate = setPropertyValueFromValueName(clientstate, prop, state.getValue(i)).get();
					}
					
					propertyAssigner.setOriginalState(clientstate);
					
					final int index = holder.index();
					for(class_2680 blockstate : propertyAssigner) {
						SynchronisedBlockstates.LOGGER.info("Remapping {}/{} id [{} -> {}]", state, clientstate, clientStateList.method_10206(clientstate), index);
						
						mappings.put(clientStateList.method_10206(blockstate), index);
					}
				}
			}
		}
	}

	public static <T extends Comparable<T>> Optional<class_2680> setPropertyValueFromValueName(class_2680 state, class_2769<T> property, String value) {
		Optional<T> optionalValue = property.method_11900(value);
		return optionalValue.map(propertyValue -> state.method_11657(property, propertyValue));
	}

	@SuppressWarnings("unchecked")
	public static <T extends Comparable<T>> class_2680 setPropertyValueFromUncheckedObject(class_2680 state, class_2769<T> property, Object value) {
		return state.method_11657(property, (T)value);
	}
	
	public static class PropertyValueTree implements Iterable<class_2680>, Iterator<class_2680> {
		public final class_2769<?>[] properties;
		public final Object[][] values;
		public final int[] counts;
		public final int stateCount;
		public final int propertyCount;
		
		public boolean[] changed;
		public int[] indexes;
		
		protected boolean hasNext = false;
		protected class_2680 state = null;
		
		public PropertyValueTree(class_2769<?>[] properties) {
			this.properties = properties;
			final int propertyCount = this.propertyCount = properties.length;

			this.values = new Object[propertyCount][];
			this.counts = new int[propertyCount];
			
			int stateCount = 1;
			for(int i = 0; i < propertyCount; ++i) {
				Collection<?> possibleValues = this.properties[i].method_11898();
				stateCount *= (counts[i] = possibleValues.size());
				values[i] = possibleValues.toArray();
			}
			this.stateCount = stateCount;
			
			this.reset();
		}
		
		public boolean isLast(int propertyIndex) {
			return indexes[propertyIndex] == counts[propertyIndex];
		}
		
		protected void increment() {
//			if(isLast(0)) {
				int i = 0;
				while(isLast(i)) {
					indexes[i] = 0;
					changed[i] = true;
					i++;
					// We've just finished
					if(i == propertyCount) {
						hasNext = false;
						return;
					}
				}
				indexes[i]++;
				changed[i] = true;
//			} else {
//				indexes[0]++;
//				changed[0] = true;
//			}
		}
		
		public void reset() {
			indexes = new int[propertyCount];
			changed = new boolean[propertyCount];
			this.hasNext = true;
		}
		
		protected class_2680 next(class_2680 prevState) {
			for(int i = 0; i < propertyCount; ++i) {
				if(changed[i]) {
					prevState = setPropertyValueFromUncheckedObject(prevState, properties[i], values[i][indexes[i]]);
					changed[i] = false;
				}
			}
			increment();
			return prevState;
		}
		
		public void setOriginalState(@NotNull class_2680 state) {
			this.state = Objects.requireNonNull(state);
			this.reset();
		}
		
		public Iterator<class_2680> iterator() {
			this.reset();
			return this;
		}
		
		@Override
		public boolean hasNext() {
			return state != null && hasNext;
		}

		@Override
		public class_2680 next() {
			state = next(state);
			return state;
		}
		
		
	}
	
	@FunctionalInterface
	public static interface MappingSetter {
		public void setMapping(int index, int mapping);
	}
	
	public static boolean shouldOutputMissingEntries() {
		String property = System.getProperty("mod.synchronisedblockstates.outputMissingBlockstates", "false");
		if(property.equalsIgnoreCase("true") || property.equals("1")) {
			return true;
		} else {
			return false;
		}
	}
	
	public static void remapAllBlockStates(final class_2361<class_2680> clientStateList, final BlockRegistryRepresentative serverRegistry, final class_310 client/*, @Nullable final Runnable sendKeepalive*/) {
		final BlockStateRepresentative[] serverStateList = serverRegistry.allStates;
		
		final boolean shouldOutputMissingEntries = shouldOutputMissingEntries();
		List<String> statesMissingFromClient = shouldOutputMissingEntries ? new ArrayList<String>(Math.max(10, Math.abs(serverRegistry.allStates.length - clientStateList.method_10204()))) : null;
		List<String> statesMissingFromServer = shouldOutputMissingEntries ? new ArrayList<String>(Math.max(10, Math.abs(serverRegistry.allStates.length - clientStateList.method_10204()))) : null;
		
		SynchronisedBlockstates.LOGGER.info("Collecting mappings");
		final long startMappings = System.nanoTime();
		
//		final int initialSize = clientStateList.idToT.size();
//		final MutableInt mutableSize = new MutableInt(initialSize);
//		final IntArrayList mappings = new IntArrayList(initialSize);
//		final BooleanArrayList mappingExists = new BooleanArrayList(initialSize);
//		mappings.size(initialSize);
//		mappingExists.size(initialSize);
		
		RemappedProxyIdMapper<class_2680> remapper = new RemappedProxyIdMapper<class_2680>(serverStateList.length, clientStateList, (int originalIndex, class_2680 object) -> -1, false);
		
		MappingSetter setMapping = (int index, int mapping) -> {
//			if(mutableSize.intValue() < index) {
//				mutableSize.setValue(index);
//				mappings.size(index);
//				mappingExists.size(index);
//			}
//			mappings.set(index, mapping);
//			mappingExists.set(index, true);
			remapper.setMapping(index, mapping);
			if(mapping != RemappedProxyIdMapper.NO_VALUE_INDEX)
				remapper.addMappingRaw(clientStateList.method_10200(index), mapping);
		};
//		mappings.defaultReturnValue(RemappedProxyIdMapper.NO_VALUE_INDEX);
		
//		final RemapInfo remapInfo = new RemapInfo();
//		remapInfo.clientStateList = clientStateList;
//		remapInfo.serverStateList = serverStateList;
//		
//		Object2ObjectOpenHashMap<ResourceKey<Block>, BlockInfo> blocks = new Object2ObjectOpenHashMap<ResourceKey<Block>, SynchronisedBlockstatesClient.BlockInfo>();
//
//		for(int i = 0; i < clientStateList.size(); ++i) {
//			BlockState state = clientStateList.byId(i);
//			ResourceKey<Block> key = state.getBlockHolder().unwrapKey().get();
//			BlockInfo info = blocks.computeIfAbsent(key, BlockInfo::onClient);
//			info.addClientState(i, state);
//		}
//
//		for(int i = 0; i < serverStateList.length; ++i) {
//			BlockStateRepresentative state = serverStateList[i];
//			ResourceKey<Block> key = state.getBlock();
//			BlockInfo info = blocks.computeIfAbsent(key, BlockInfo::new);
//			info.addServerState(i, state);
//		}
//		
//		for(BlockInfo info : blocks.values()) {
//			analyzeBlockInfo(info, remapInfo, mappings);
//		}
		
//		for(int i = 0; i < serverStateList.length; ++i) {
//			BlockStateRepresentative state = serverStateList[i];
//			ResourceKey<Block> key = state.getBlock();
//			Block block = BuiltInRegistries.BLOCK.getOptional(key).orElseThrow();
//			BlockState clientstate = block.defaultBlockState();
//			StateDefinition<Block, BlockState> stateDefinition = block.getStateDefinition();
//			for(PropertyRepresentative property : state.getProperties()) {
//				Property<?> prop = stateDefinition.getProperty(property.getName());
//				clientstate = setPropertyValueFromValueName(clientstate, prop, state.getValue(property));
//			}
//			
////			SynchronisedBlockstates.LOGGER.info("Remapping {}/{} id [{} -> {}]", state, clientstate, clientStateList.getId(clientstate), i);
//			
//			mappings.put(clientStateList.getId(clientstate), i);
//		}
		
		final int airIndex = clientStateList.method_10206(class_2246.field_10124.method_9564());

//		final int totalMappings = serverRegistry.allStates.length;
//		long lastLogTime = startMappings;
//		int seenCount = 0;
		
		Set<class_2248> seenClientBlocks = shouldOutputMissingEntries ? Sets.newIdentityHashSet() : null;
		
		final StateDefinitionRepresentative[] allBlocks = serverRegistry.allBlocks;
		for(StateDefinitionRepresentative serverBlock : allBlocks) {
			BlockRepresentative<?> serverBlockHolder = serverBlock.blockType;
			@SuppressWarnings("unchecked")
			final class_2248 clientBlock = class_7923.field_41175.method_31189((class_5321<class_2248>)serverBlockHolder.getKey()).orElse(null);
			if(shouldOutputMissingEntries) {
				seenClientBlocks.add(clientBlock);
			}
			if(clientBlock == null) {
				for(final int id : serverBlock.stateIndexes) {
					setMapping.setMapping(id, airIndex);
				}
				if(shouldOutputMissingEntries) {
					for(final var state : serverBlock.states) {
						statesMissingFromClient.add(state.toString());
					}
				}
			} else {
				final class_2689<class_2248, class_2680> stateDefinition = clientBlock.method_9595();

				final int serverPropertyCount = serverBlockHolder.getPropertyCount();
//				final int clientPropertyCount = stateDefinition.getProperties().size();
				
//				final PropertyRepresentative[] serverProperties = serverBlockHolder.properties;
				final class_2769<?>[] clientProperties = new class_2769<?>[serverPropertyCount];

				boolean serverHasPropertiesThatAreMissingFromTheClient = false;
				boolean clientHasPropertiesThatAreMissingFromTheServer = false;
				boolean serverHasPropertyValuesThatAreMissingFromTheClient = false;
				boolean clientHasPropertyValuesThatAreMissingFromTheServer = false;
				
				int validClientProperties = 0;
				
				for(int propertyIndex = 0; propertyIndex < serverPropertyCount; ++propertyIndex) {
					final PropertyRepresentative serverProperty = serverBlockHolder.getProperty(propertyIndex);
					final class_2769<?> clientProperty = stateDefinition.method_11663(serverProperty.getName());
					if(clientProperty == null) {
						serverHasPropertiesThatAreMissingFromTheClient = true;
					} else {
						validClientProperties++;
					}
					clientProperties[propertyIndex] = clientProperty;
				}
				
				if(validClientProperties != stateDefinition.method_11659().size()) {
					clientHasPropertiesThatAreMissingFromTheServer = true;
				}
				
				for(int i = 0; i < serverBlock.stateCount; ++i) {
					BlockStateRepresentative serverState = serverBlock.states[i];
					class_2680 clientState = clientBlock.method_9564();
					
					for(int propertyIndex = 0; propertyIndex < serverPropertyCount; ++propertyIndex) {
						final class_2769<?> clientProperty = clientProperties[propertyIndex];
						if(clientProperty != null) {
							Optional<class_2680> newClientState = setPropertyValueFromValueName(clientState, clientProperty, serverState.getValue(propertyIndex));
							if(newClientState.isEmpty()) {
								serverHasPropertyValuesThatAreMissingFromTheClient = true;
							} else {
								clientState = newClientState.get();
							}
						}
					}
					
					setMapping.setMapping(clientStateList.method_10206(clientState), serverBlock.stateIndexes[i]);
					
//					seenCount++;
//					
//					if(seenCount % 1000 == 0 && sendKeepalive != null) {
//						final long currentTime = System.nanoTime();
//						if(currentTime - lastLogTime >= 1000000000L) {
//							sendKeepalive.run();
//							SynchronisedBlockstates.LOGGER.info("Mapping state {} / {}", seenCount, totalMappings);
//							lastLogTime = currentTime;
//						}
//					}
				}
				
				// TODO make proper
				if(shouldOutputMissingEntries) {
					String blockId = serverBlock.blockType.asString();
					if(serverHasPropertiesThatAreMissingFromTheClient) {
						SynchronisedBlockstates.LOGGER.info("Block {}: server has properties that are missing from the client", blockId);
					}
					if(clientHasPropertiesThatAreMissingFromTheServer) {
						SynchronisedBlockstates.LOGGER.info("Block {}: client has properties that are missing from the server", blockId);
					}
					if(serverHasPropertyValuesThatAreMissingFromTheClient) {
						SynchronisedBlockstates.LOGGER.info("Block {}: server has property values that are not valid on the client", blockId);
					}
					if(clientHasPropertyValuesThatAreMissingFromTheServer) {
						SynchronisedBlockstates.LOGGER.info("Block {}: client has property values that are not valid on the server", blockId);
					}
				}
			}
		}


		final long endMappings = System.nanoTime();
		SynchronisedBlockstates.LOGGER.info("Collecting mappings took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(endMappings - startMappings, TimeUnit.NANOSECONDS), endMappings - startMappings);
		
//		SynchronisedBlockstates.LOGGER.info("Initializing remapper");
//		final long startRemapper = System.nanoTime();
//		RemappedProxyIdMapper<BlockState> remapper = new RemappedProxyIdMapper<BlockState>(clientStateList, (int originalIndex, BlockState object) -> {
////			return mappings.containsKey(originalIndex) ? mappings.get(originalIndex) : originalIndex;
////			return mappings.get(originalIndex);
//			return !mappingExists.getBoolean(originalIndex) ? RemappedProxyIdMapper.NO_VALUE_INDEX : mappings.getInt(originalIndex);
//		});
//		final long endRemapper = System.nanoTime();
//		SynchronisedBlockstates.LOGGER.info("Initializing remapper took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(endRemapper - startRemapper, TimeUnit.NANOSECONDS), endRemapper - startRemapper);

		SynchronisedBlockstates.LOGGER.info("Proxying remapper into registry");
		final long startProxy = System.nanoTime();
		setMapper(remapper);
		final long endProxy = System.nanoTime();
		SynchronisedBlockstates.LOGGER.info("Proxying remapper into registry took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(endProxy - startProxy, TimeUnit.NANOSECONDS), endProxy - startProxy);
		
		if(shouldOutputMissingEntries) {
			SynchronisedBlockstates.LOGGER.info("Writing missing states to file");
			final long startOutput = System.nanoTime();

			try {
				class_310 minecraft = class_310.method_1551();
				Path outputFolderPath = Files.createDirectories(minecraft.field_1697.toPath().resolve("synchronized_blockstates"));
				String fileName = String.format("missing-states-%d.dat", System.currentTimeMillis());
				File outputFile = outputFolderPath.resolve(fileName).toFile();

//				OutputStream fileOutputStream = new FileOutputStream(outputFile);
				FileWriter fileOutputStream = new FileWriter(outputFile);
				fileOutputStream.write("States missing from the client:\n");
				if(statesMissingFromClient.size() == 0) {
					fileOutputStream.write("\tNone!\n");
				} else {
					for(String state : statesMissingFromClient) {
						fileOutputStream.write('\t');
						fileOutputStream.write(state);
						fileOutputStream.write('\n');
					}
				}
				fileOutputStream.write('\n');
				fileOutputStream.write("States missing from the server:\n");
				{
					boolean allSeen = true;
					for(var clientBlock : class_7923.field_41175) {
//					for(var entry : BuiltInRegistries.BLOCK.entrySet()) {
//						ResourceKey<Block> key = entry.getKey();
//						Block clientBlock = entry.getValue();
						if(!seenClientBlocks.contains(clientBlock)) {
							allSeen = false;
//							String location = key.location().toString();
							final class_2689<class_2248, class_2680> stateDefinition = clientBlock.method_9595();
							for(var state : stateDefinition.method_11662()) {
								fileOutputStream.write('\t');
								fileOutputStream.write(state.toString());
//								fileOutputStream.write(location);
//								fileOutputStream.write('[');
//								fileOutputStream.write((String)state.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
//								fileOutputStream.write(']');
								fileOutputStream.write('\n');
							}
						}
					}
					
					if(allSeen) {
						fileOutputStream.write("\tNone!\n");
					}
				}
				fileOutputStream.close();
			} catch(IOException e) {
				e.printStackTrace();
			}
			
			final long endOutput = System.nanoTime();
			SynchronisedBlockstates.LOGGER.info("Writing missing states to file took {} seconds ({} nanos)", TimeUnit.SECONDS.convert(endOutput - startOutput, TimeUnit.NANOSECONDS), endOutput - startOutput);
			
		}
//		SynchronisedBlockstates.LOGGER.info("Testing blockstates for 78: {}, 79: {} & 80: {}", Block.BLOCK_STATE_REGISTRY.byId(78), Block.BLOCK_STATE_REGISTRY.byId(79), Block.BLOCK_STATE_REGISTRY.byId(80));
	}
	
	public static void remapAllBlockStatesAndThenProgress(final class_2361<class_2680> clientStateList, final BlockRegistryRepresentative serverRegistry, final class_310 client, final class_8674 networkHandler, final PacketSender responseSender) {
//		remapAllBlockStates(clientStateList, serverRegistry, client);
//		responseSender.sendPacket(new ServerboundAckPacket(ClientAckResponse.OK));
		
		responseSender.sendPacket(new ServerboundAckPacket(ClientAckResponse.OK));
		remapAllBlockStates(clientStateList, serverRegistry, client);
	}
}