package com.joshiegemfinder.synchronisedblockstates.intermediary.network;

import com.joshiegemfinder.synchronisedblockstates.common.ClientAckResponse;
import com.joshiegemfinder.synchronisedblockstates.common.SynchronisedBlockstates;
import com.joshiegemfinder.synchronisedblockstates.intermediary.SynchronisedBlockstatesIntermediary;
import com.joshiegemfinder.synchronisedblockstates.intermediary.fabric.SynchronisedBlockstatesClient;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.client.ChunkedPacketReciever;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundChunkedBlockstateSyncDataPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundChunkedBlockstateSyncEndPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundChunkedBlockstateSyncStartPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ClientboundSynchroniseBlockstatesPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.packet.ServerboundAckPacket;
import com.joshiegemfinder.synchronisedblockstates.intermediary.network.task.SynchroniseBlockstatesTask;

import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9812;

public class SynchronisedBlockstatesNetwork {
	public static final class_2960 SYNCHRONISE_BLOCKSTATES_PACKET_ID = SynchronisedBlockstatesIntermediary.resourceLocation("synchronise_blockstates");
	public static final class_2960 CHUNKED_SYNCHRONISE_BLOCKSTATES_START_PACKET_ID = SynchronisedBlockstatesIntermediary.resourceLocation("blockstate_chunking_start");
	public static final class_2960 CHUNKED_SYNCHRONISE_BLOCKSTATES_DATA_PACKET_ID  = SynchronisedBlockstatesIntermediary.resourceLocation("blockstate_chunking_data");
	public static final class_2960 CHUNKED_SYNCHRONISE_BLOCKSTATES_END_PACKET_ID   = SynchronisedBlockstatesIntermediary.resourceLocation("blockstate_chunking_end");
	public static final class_2960 ACK_PACKET_ID = SynchronisedBlockstatesIntermediary.resourceLocation("ack");
	
	public static final void registerPackets() {
		PayloadTypeRegistry.configurationS2C().register(ClientboundSynchroniseBlockstatesPacket.TYPE, ClientboundSynchroniseBlockstatesPacket.CODEC);

		PayloadTypeRegistry.configurationS2C().register(ClientboundChunkedBlockstateSyncStartPacket.TYPE, ClientboundChunkedBlockstateSyncStartPacket.CODEC);
		PayloadTypeRegistry.configurationS2C().register(ClientboundChunkedBlockstateSyncDataPacket.TYPE, ClientboundChunkedBlockstateSyncDataPacket.CODEC);
		PayloadTypeRegistry.configurationS2C().register(ClientboundChunkedBlockstateSyncEndPacket.TYPE, ClientboundChunkedBlockstateSyncEndPacket.CODEC);
		
		PayloadTypeRegistry.configurationC2S().register(ServerboundAckPacket.TYPE, ServerboundAckPacket.CODEC);
	}
	
	public static final void registerServer() {

		ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
			SynchronisedBlockstates.LOGGER.info("Trying to send packet");
			if (ServerConfigurationNetworking.canSend(handler, SYNCHRONISE_BLOCKSTATES_PACKET_ID)) {
				SynchronisedBlockstates.LOGGER.info("Can send packet");
//				handler.addTask(new SynchroniseBlockstatesTask(server));
				handler.addTask(new SynchroniseBlockstatesTask());
			}
		});
		
		ServerConfigurationNetworking.registerGlobalReceiver(ServerboundAckPacket.TYPE, SynchronisedBlockstatesNetwork::handleAck);
	}
	
	public static final void registerClient() {
		ClientConfigurationNetworking.registerGlobalReceiver(ClientboundSynchroniseBlockstatesPacket.TYPE, SynchronisedBlockstatesClient::handleRecieveSynchroniseBlockstatesPacket);
		ChunkedPacketReciever.registerPacketsClient();
	}

	// Moved out of the packet classes because spigot
	public static void handleAck(ServerboundAckPacket packet, ServerConfigurationNetworking.Context context) {
		SynchronisedBlockstates.LOGGER.info("Recieved blockstates validated ack from client!");
		
		ClientAckResponse response = packet.response();
		if(response.isFail()) {
			SynchronisedBlockstates.LOGGER.info("Client blockstate sync failed");
			String disconnectionMessage;
			if(response.isClientAtFault() && !response.isServerAtFault())
				disconnectionMessage = SynchronisedBlockstates.FATALLY_MISSING_BLOCKSTATES_CLIENT;
			else if(!response.isClientAtFault() && response.isServerAtFault())
				disconnectionMessage = SynchronisedBlockstates.FATALLY_MISSING_BLOCKSTATES_SERVER;
			else
				disconnectionMessage = SynchronisedBlockstates.FATALLY_MISSING_BLOCKSTATES_BOTH;
			
			context.networkHandler().method_60673(new class_9812(class_2561.method_43471(disconnectionMessage)));
		}

		SynchronisedBlockstates.LOGGER.info("Completing sync blockstates task");
		context.networkHandler().completeTask(SynchroniseBlockstatesTask.TYPE);
	}
}
