
// define distinct values, counting from 1:
#define GREYSCALE_CHANNEL 1
#define BRIGHTNESS_CHANNEL 2
#define BLOODMOON_CHANNEL 3
#define TEST_CHANNEL 4

/*
signature:
 ADD_MARKER(channel, green, alpha, op, rate)
*/
// append different marker definitions
// x/255 = 0.y | ( 1 , 2 , 3 , 4)
//particle color ( 2 , 3 , 4 )
#define LIST_MARKERS ADD_MARKER(TEST_CHANNEL, 253, 249, 1, 1) ADD_MARKER(BLOODMOON_CHANNEL, 253, 250, 1, 9) ADD_MARKER(GREYSCALE_CHANNEL, 253, 251, 1, 0.1) ADD_MARKER(BRIGHTNESS_CHANNEL, 253, 252, 1, 0.1) 

#define MARKER_RED 254

// Screen pixel that the marker ends up on if it uses channel k:
// Mapping follows structure that is like an inverted cantor pairing (but only producing coordinates with an even sum)
#define MARKER_POS(k) (ivec2(2*int(ceil(sqrt(float(k))) - 1.0),0) + (k - int((ceil(sqrt(float(k))) - 1.0)*(ceil(sqrt(float(k))) - 1.0)) - 1)*ivec2(-1, 1))

