#version 330

layout(std140) uniform LightmapInfo {
    float AmbientLightFactor;
    float SkyFactor;
    float BlockFactor;
    float DarknessScale;
    float DarkenWorldFactor;
    float BrightnessFactor;
    vec3 SkyLightColor;
    vec3 AmbientColor;
} lightmapInfo;

//#define SKY_LIGHT_COLOUR lightmapInfo.SkyLightColor




uniform sampler2D MainSampler;
uniform sampler2D DataSampler;
uniform sampler2D BlurSampler;

layout(std140) uniform SamplerInfo {
    vec2 OutSize;
    vec2 InSize;
};

#moj_import <minecraft:globals.glsl>

#moj_import <bts:marker_settings.glsl>
#moj_import <bts:utils.glsl>
#moj_import <bts:data_reader.glsl>

in vec2 texCoord;

out vec4 fragColor;

void main() {
    //particle minecraft:entity_effect{color:[0.996078431372549, 0.9921568627450981, 1.0, 0.98039215686274],scale:1f}
    //particle minecraft:entity_effect{color:[0.996078431372549, 0.9921568627450981, 1.0, 0.988235294117647],scale:1f}
    //particle minecraft:entity_effect{color:[0.996078431372549, 0.9921568627450981, 1.0, 0.976470588235294],scale:1f}
///////////////////////////////////////////////////////////////


    // Apply  effect using the provided matrix
    float testAmount = readChannel(TEST_CHANNEL);
    if (testAmount > 0.001) {
        vec3 color = fragColor.rgb;
        // New transformation matrix
        mat3 testMatrix = mat3(
            1.0, 0.0, 0.0,  // red transformation
            1.4, 0.4, 0.2,  // Green transformation
            1.4, 0.2, 0.4   // Blue transformation
        );
        color = testMatrix * color; // Apply the transformation
        fragColor.rgb = mix(fragColor.rgb, color, testAmount);
    }




    vec4 texColor = texture(MainSampler, texCoord); // Fetch base texture color
    fragColor = texColor; // Initialize fragColor

    // Apply  effect using the provided matrix
    float grayAmount = readChannel(BRIGHTNESS_CHANNEL);
    if (grayAmount > 0.001) {
        vec3 color = fragColor.rgb;
        // New gray transformation matrix
mat3 grayMatrix = mat3(
    1.3, 0.0, 0.0,    // Red transformation
    0.0, 1.3, 0.0,    // Green transformation
    0.0, 0.0, 1.3   // Blue transformation
);
        color = grayMatrix * color; // Apply the  transformation
        fragColor.rgb = mix(fragColor.rgb, color, grayAmount);
    }




   // Apply effect using the provided matrix
    float redAmount = readChannel(BLOODMOON_CHANNEL);
    if (redAmount > 0.001) {
        vec3 color = fragColor.rgb;
        // New transformation matrix
        mat3 redMatrix = mat3(
            1.0, 0.0, 0.0,  // Red transformation
            0.4, 0.4, 0.2,  // Green transformation
            0.4, 0.2, 0.4   // Blue transformation
        );
        color = redMatrix * color; // Apply the transformation
        fragColor.rgb = mix(fragColor.rgb, color, redAmount);
    }

#ifdef DEBUG
    // Show data sampler on screen
    if (texCoord.x < .25 && texCoord.y < .25) {
        vec2 debugUV = texCoord * 4.0;
        vec4 col = texture(DataSampler, debugUV);
        if (debugUV.x > 1. / 5.0)
            col = vec4(vec3(fract(decodeColor(col))), 1.0);
        fragColor = col;
    }
#endif
}
