/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import info.rusty.webshoplink.Config;
import org.slf4j.Logger;

public class DebugLogger {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void log(String message) {
        DebugLogger.log(message, Config.DebugVerbosity.DEFAULT);
    }

    public static void log(String message, Config.DebugVerbosity minimumVerbosity) {
        if (Config.debugEnabled && Config.debugVerbosity.ordinal() >= minimumVerbosity.ordinal()) {
            LOGGER.info("[Webshoplink Debug] " + message);
        }
    }

    public static void logError(String message, Throwable error) {
        LOGGER.error("[Webshoplink Error] " + message, error);
    }
}

